/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.tools.monitor.jvmmon.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CodeblobDumpDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4665086660483868594L;
    private static CodeblobDumpDialog dialog;
    private JTextField methodNameField;
    private JCheckBox detailCheckBox;
    private boolean ok;
    private static String lastMethodName;
    private static boolean lastDetailFlag;

    public static boolean showDialog(JFrame frame, String title) {
        dialog = new CodeblobDumpDialog(frame, title);
        CodeblobDumpDialog.dialog.ok = false;
        dialog.setVisible(true);
        return CodeblobDumpDialog.dialog.ok;
    }

    public static String getMethodName() {
        return lastMethodName;
    }

    public static boolean getDetailFlag() {
        return lastDetailFlag;
    }

    private CodeblobDumpDialog(JFrame frame, String title) {
        super(frame, title, true);
        JPanel parameterPanel = new JPanel(new GridBagLayout());
        TitledBorder titleBorder = BorderFactory.createTitledBorder(Resources.getText("Codeblob selection", new Object[0]));
        titleBorder.setTitleJustification(1);
        parameterPanel.setBorder(titleBorder);
        this.createParameterContent(parameterPanel);
        JButton okButton = new JButton(Resources.getText("Ok", new Object[0]));
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        JButton cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.setContentPane(content);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)parameterPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.setLocationRelativeTo(frame);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            CodeblobDumpDialog.dialog.ok = false;
        } else if ("Ok".equals(e.getActionCommand())) {
            lastMethodName = this.methodNameField.getText();
            lastDetailFlag = this.detailCheckBox.isSelected();
            CodeblobDumpDialog.dialog.ok = true;
        }
        dialog.setVisible(false);
    }

    private void createParameterContent(JPanel descriptionPanel) {
        JLabel infoLabel = new JLabel(Resources.getText("Method name:", new Object[0]));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        this.methodNameField = new JTextField();
        this.methodNameField.setColumns(20);
        this.methodNameField.setText(lastMethodName);
        this.methodNameField.setEnabled(true);
        this.methodNameField.setEditable(true);
        this.detailCheckBox = new JCheckBox();
        this.detailCheckBox.setText(Resources.getText("Detailed info", new Object[0]));
        this.detailCheckBox.setEnabled(true);
        this.detailCheckBox.setSelected(lastDetailFlag);
        c.gridy = 0;
        c.gridx = 0;
        descriptionPanel.add((Component)infoLabel, c);
        c.gridy = 0;
        c.gridx = 1;
        descriptionPanel.add((Component)this.methodNameField, c);
        c.gridy = 1;
        c.gridx = 1;
        descriptionPanel.add((Component)this.detailCheckBox, c);
    }

    static {
        lastMethodName = "";
        lastDetailFlag = false;
    }
}

