/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tracing.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CommandLineFlagsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6694851974876708031L;
    private static CommandLineFlagsDialog dialog;
    private List<MonitoredVm> vms;
    private JTextField flagsField;

    public static void showDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        dialog = new CommandLineFlagsDialog(frame, title, vms);
        dialog.setVisible(true);
    }

    private CommandLineFlagsDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        super(frame, title, true);
        this.vms = vms;
        JPanel settingsPanel = new JPanel(new FlowLayout());
        TitledBorder titleBorder = BorderFactory.createTitledBorder(Resources.getText("Settings", new Object[0]));
        titleBorder.setTitleJustification(1);
        settingsPanel.setBorder(titleBorder);
        this.createSettingsContent(settingsPanel);
        JButton okButton = new JButton(Resources.getText("Ok", new Object[0]));
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        JButton cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.setContentPane(content);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)settingsPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.setLocationRelativeTo(frame);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            dialog.setVisible(false);
        } else if ("Ok".equals(e.getActionCommand())) {
            String flags = this.flagsField.getText();
            for (MonitoredVm vm : this.vms) {
                try {
                    vm.changeCommandLineFlags(flags);
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
            dialog.setVisible(false);
        }
    }

    private void createSettingsContent(JPanel settingsPanel) {
        JLabel flagsLabel = new JLabel(Resources.getText("Flags:", new Object[0]));
        this.flagsField = new JTextField();
        this.flagsField.setColumns(20);
        this.flagsField.setEnabled(true);
        this.flagsField.setEditable(true);
        settingsPanel.add(flagsLabel);
        settingsPanel.add(this.flagsField);
    }
}

