/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.tools.monitor.jvmmon.JvmMon;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tracing.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DebuggingDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 5095080026841519332L;
    private static final String[] SUSPEND_POLICY_STRINGS = new String[]{Resources.getText("Suspend None", new Object[0]), Resources.getText("Suspend All", new Object[0])};
    private static final SuspendPolicy[] SUSPEND_POLICIES = new SuspendPolicy[]{SuspendPolicy.SUSPEND_NONE, SuspendPolicy.SUSPEND_ALL};
    private static DebuggingDialog dialog;
    private List<MonitoredVm> vms;
    private JComboBox<String> suspendPolicyList;
    private final boolean onlyLocal;

    public static void showDialog(JFrame frame, String title, List<MonitoredVm> vms, boolean onlyLocal) {
        dialog = new DebuggingDialog(frame, title, vms, onlyLocal);
        dialog.setVisible(true);
    }

    private DebuggingDialog(JFrame frame, String title, List<MonitoredVm> vms, boolean onlyLocal) {
        super(frame, title, true);
        this.vms = vms;
        JPanel settingsPanel = new JPanel(new FlowLayout());
        TitledBorder titleBorder = BorderFactory.createTitledBorder(Resources.getText("Settings", new Object[0]));
        titleBorder.setTitleJustification(1);
        settingsPanel.setBorder(titleBorder);
        this.createSettingsContent(settingsPanel);
        JButton okButton = new JButton(Resources.getText("Ok", new Object[0]));
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        JButton cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.setContentPane(content);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)settingsPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.setLocationRelativeTo(frame);
        this.pack();
        this.setResizable(false);
        this.onlyLocal = onlyLocal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            dialog.setVisible(false);
        } else if ("Ok".equals(e.getActionCommand())) {
            SuspendPolicy suspendPolicy = SUSPEND_POLICIES[this.suspendPolicyList.getSelectedIndex()];
            for (MonitoredVm vm : this.vms) {
                try {
                    if (JvmMon.isNew()) {
                        vm.openDebugPort(suspendPolicy == SuspendPolicy.SUSPEND_ALL, this.onlyLocal);
                        continue;
                    }
                    if (this.onlyLocal) {
                        vm.getVmOld().startLocalDebug(suspendPolicy);
                        continue;
                    }
                    vm.getVmOld().startDebug(suspendPolicy);
                }
                catch (InvalidVmException | IOException ex) {
                    Trace.get(this.getClass()).error(ex);
                }
            }
            dialog.setVisible(false);
        }
    }

    private void createSettingsContent(JPanel settingsPanel) {
        JLabel suspendPolicyLabel = new JLabel(Resources.getText("Suspend Policy:", new Object[0]));
        this.suspendPolicyList = new JComboBox<String>(SUSPEND_POLICY_STRINGS);
        this.suspendPolicyList.setSelectedIndex(0);
        this.suspendPolicyList.addActionListener(this);
        settingsPanel.add(suspendPolicyLabel);
        settingsPanel.add(this.suspendPolicyList);
    }
}

