/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.tools.monitor.jvmmon.JvmMon;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tracing.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.text.NumberFormatter;

public class DebuggingPortRangeDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -62811412598693094L;
    private static DebuggingPortRangeDialog dialog;
    private List<MonitoredVm> vms;
    private JFormattedTextField numFromPortField;
    private JFormattedTextField numToPortField;

    public static void showDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        dialog = new DebuggingPortRangeDialog(frame, title, vms);
        dialog.setVisible(true);
    }

    private DebuggingPortRangeDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        super(frame, title, true);
        this.vms = vms;
        JPanel settingsPanel = new JPanel(new FlowLayout());
        TitledBorder titleBorder = BorderFactory.createTitledBorder(Resources.getText("Settings", new Object[0]));
        titleBorder.setTitleJustification(1);
        settingsPanel.setBorder(titleBorder);
        this.createSettingsContent(settingsPanel);
        JButton okButton = new JButton(Resources.getText("Ok", new Object[0]));
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        JButton cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.setContentPane(content);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)settingsPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.setLocationRelativeTo(frame);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            dialog.setVisible(false);
        } else if ("Ok".equals(e.getActionCommand())) {
            int fromPort = 0;
            int toPort = 0;
            try {
                fromPort = ((Number)this.numFromPortField.getValue()).intValue();
                toPort = ((Number)this.numToPortField.getValue()).intValue();
                if (fromPort < 0 || toPort < 0) {
                    JOptionPane.showMessageDialog(this, Resources.getText("The port range is not valid. Negative values are not allowed.", new Object[0]), Resources.getText("Invalid Input", new Object[0]), 0);
                    return;
                }
                if (fromPort > toPort) {
                    JOptionPane.showMessageDialog(this, Resources.getText("The port range is not valid. The left boundary is greater than the right one.", new Object[0]), Resources.getText("Invalid Input", new Object[0]), 0);
                    return;
                }
            }
            catch (Exception ex) {
                Trace.get(this.getClass()).error((Throwable)ex);
                return;
            }
            for (MonitoredVm vm : this.vms) {
                try {
                    if (JvmMon.isNew()) {
                        vm.setDefaultDebuggingPortRange(fromPort, toPort);
                        continue;
                    }
                    vm.getVmOld().setDefaultDebugPortRange(new PortRange(fromPort, toPort));
                }
                catch (InvalidVmException | IOException ex) {
                    Trace.get(this.getClass()).error(ex);
                }
            }
            dialog.setVisible(false);
        }
    }

    private void createSettingsContent(JPanel settingsPanel) {
        JLabel portRangeLabel = new JLabel(Resources.getText("Port range:", new Object[0]));
        NumberFormatter formatter = null;
        try {
            formatter = new NumberFormatter();
            formatter.setAllowsInvalid(false);
            formatter.setFormat(new DecimalFormat("##############"));
        }
        catch (Exception ex) {
            Trace.get(this.getClass()).error((Throwable)ex);
            return;
        }
        this.numFromPortField = new JFormattedTextField(formatter);
        this.numFromPortField.setColumns(4);
        this.numFromPortField.setValue(8000);
        this.numFromPortField.addPropertyChangeListener("fromPort", this);
        this.numFromPortField.setEnabled(true);
        this.numFromPortField.setEditable(true);
        JLabel portRangeSep = new JLabel(" - ");
        this.numToPortField = new JFormattedTextField(formatter);
        this.numToPortField.setColumns(4);
        this.numToPortField.setValue(8100);
        this.numToPortField.addPropertyChangeListener("toPort", this);
        this.numToPortField.setEnabled(true);
        this.numToPortField.setEditable(true);
        settingsPanel.add(portRangeLabel);
        settingsPanel.add(this.numFromPortField);
        settingsPanel.add(portRangeSep);
        settingsPanel.add(this.numToPortField);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JFormattedTextField source = (JFormattedTextField)evt.getSource();
        if (source == this.numFromPortField) {
            Object newValue = source.getValue();
            this.numToPortField.setValue(newValue);
        }
    }
}

