/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMon;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tracing.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class HeapDumpDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4784789085043293495L;
    private static HeapDumpDialog dialog;
    private List<MonitoredVm> vms;
    private JTextField infoField;

    public static void showDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        dialog = new HeapDumpDialog(frame, title, vms);
        dialog.setVisible(true);
    }

    private HeapDumpDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        super(frame, title, true);
        this.vms = vms;
        JPanel descriptionPanel = new JPanel(new FlowLayout());
        TitledBorder titleBorder = BorderFactory.createTitledBorder(Resources.getText("Description", new Object[0]));
        titleBorder.setTitleJustification(1);
        descriptionPanel.setBorder(titleBorder);
        this.createDescriptionContent(descriptionPanel);
        JButton okButton = new JButton(Resources.getText("Ok", new Object[0]));
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        JButton cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.setContentPane(content);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)descriptionPanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.setLocationRelativeTo(frame);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            dialog.setVisible(false);
        } else if ("Ok".equals(e.getActionCommand())) {
            String info = this.infoField.getText();
            for (MonitoredVm vm : this.vms) {
                try {
                    if (JvmMon.isNew()) {
                        vm.dumpHeap(true, info);
                        continue;
                    }
                    vm.getVmOld().dumpHeap(info);
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
            dialog.setVisible(false);
        }
    }

    private void createDescriptionContent(JPanel descriptionPanel) {
        JLabel infoLabel = new JLabel(Resources.getText("Information saved with the heap dump:", new Object[0]));
        this.infoField = new JTextField();
        this.infoField.setColumns(20);
        this.infoField.setEnabled(true);
        this.infoField.setEditable(true);
        descriptionPanel.add(infoLabel);
        descriptionPanel.add(this.infoField);
    }
}

