/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.impl.extensions.cluster.ClusterImpl;
import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.jvmmon.ConnectableVm;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.tools.monitor.jvmmon.JvmMon;
import com.sap.jvm.tools.monitor.jvmmon.JvmmonArgs;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintVirtualizationInfoCommand;
import com.sap.jvm.tools.monitor.jvmmon.gui.AboutDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.AddClusterDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.CodeblobDumpDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.CommandLineFlagsDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.DebuggingDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.DebuggingPortRangeDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.HeapDumpDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.IconManager;
import com.sap.jvm.tools.monitor.jvmmon.gui.StackTraceDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.TextfieldFocusAction;
import com.sap.jvm.tools.monitor.jvmmon.gui.TraceFlagsDialog;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmListEventListener;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmListPanel;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmPanel;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmPrintOutputPanel;
import com.sap.jvm.tools.util.desktop.PlatformUtil;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.misc.ToolsHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JvmMonGui
extends JFrame
implements ActionListener,
VmListEventListener {
    private static final long serialVersionUID = 2217023352883026396L;
    static final String VERSION = "2.4.14";
    static final String TITLE = Resources.getText("SAP JVM Monitoring Tool", new Object[0]);
    private static final int HORIZONTAL_INITIAL_SIZE = 1020;
    private static final int VERTICAL_INITIAL_SIZE = 700;
    private JMenuBar menuBar;
    private JToolBar toolBar;
    private VmPanel vmPanel;
    private VmListPanel vmListPanel;
    private VmPrintOutputPanel vmPrintOutputPanel;
    private List<MonitoringController> connectionList = new ArrayList<MonitoringController>();
    private Timer statusBarTimer;
    static final int REFRESH_DELAY_SECONDS = 5;
    File currentSaveDirectory = null;
    private int lastSymbolInfoNum = 10;
    private int lastFlightRecoderNum = 50;
    private JButton prevButton;
    private JButton nextButton;
    private JMenuItem prevMenuItem;
    private JMenuItem nextMenuItem;
    private JTextField searchPatternEdit;
    private JLabel statusBar;
    private static final boolean isMacOS = System.getProperty("os.name").startsWith("Mac OS X");
    static final String[] actionsAlwaysAvailable = new String[]{"refresh", "addCluster", "exit"};

    private static String printStackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    private static String usage() {
        return "Usage: jvmmon-gui [options]\n\n where options include:\n    --help|-h|-?\n            Print this help text.\n    --verbose\n            Enables verbose tracing of jvmmon operation.\n    --trace-file <trace file>\n            Directs tracing of jvmmon operation to trace file.\n            This is required for tracing as jvmmon-gui is usually started without console.\n";
    }

    public static void main(String[] args) {
        JvmmonArgs jvmmonArgs;
        try {
            jvmmonArgs = JvmmonArgs.parse(args);
        }
        catch (JvmmonArgs.IllegalJvmmonArgsException e) {
            JOptionPane.showMessageDialog(null, new JTextArea(e.getMessage() + "\n" + JvmMonGui.usage()), "Error", 0);
            return;
        }
        if (jvmmonArgs.printHelp) {
            JOptionPane.showMessageDialog(null, new JTextArea(JvmMonGui.usage()), "Jvmmon GUI usage", 1);
        } else {
            JvmMon.setNew(jvmmonArgs.isNewJvmmon);
            ToolsHelper.setToolsTracingLevel((boolean)jvmmonArgs.verbose, (String)jvmmonArgs.traceFileName);
            JvmMonGui.start();
        }
    }

    public static void start() {
        SwingUtilities.invokeLater(JvmMonGui::checkedStart);
    }

    static void checkedStart() {
        try {
            JvmMonGui.startGUI();
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, new JTextArea(JvmMonGui.printStackTraceToString(t)), "Error", 0);
            System.exit(-1);
        }
    }

    public static void startGUI() {
        PlatformUtil.initializeApp(TITLE, IconManager.DocIcon.getImage());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            Trace.error((Throwable)e, (String)"Error installing platform look&feel");
        }
        Locale.setDefault(Locale.US);
        JFrame.setDefaultLookAndFeelDecorated(true);
        JvmMonGui jvmMonGui = new JvmMonGui();
        PlatformUtil.initializeFrame(jvmMonGui, frame -> AboutDialog.show(frame));
        jvmMonGui.setIconImage(IconManager.DocIcon.getImage());
        jvmMonGui.setSize(1020, 700);
        jvmMonGui.setLocationRelativeTo(null);
        jvmMonGui.setVisible(true);
        if (InspectorInfo.couldElevate()) {
            JOptionPane.showMessageDialog(jvmMonGui, Resources.getText("Jvmmon-Gui is not run as administrator. This might limit the number of visible JVMs.", new Object[0]), Resources.getText("Warning", new Object[0]), 2);
        }
    }

    public JvmMonGui() {
        super(TITLE);
        try {
            this.connectionList.add(new MonitoringController());
        }
        catch (IOException ex) {
            Trace.get(this.getClass()).error((Throwable)ex);
        }
        this.setDefaultCloseOperation(3);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.statusBarTimer = new Timer();
        this.toolBar = new JToolBar();
        this.createToolbar(this.toolBar);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.createCommandMenu(this.menuBar);
        this.createPrintMenu(this.menuBar);
        this.createDumpMenu(this.menuBar);
        if (JvmMon.isNew()) {
            this.createMemoryStatMenu(this.menuBar);
        }
        this.createDebuggingMenu(this.menuBar);
        this.vmPanel = new VmPanel(this.connectionList);
        this.vmListPanel = this.vmPanel.getVmListPanel();
        this.vmListPanel.addVmListEventListener(this);
        this.vmListPanel.setSelectedRow(0);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setContentPane(content);
        Container cp = this.getContentPane();
        cp.add((Component)this.toolBar, "North");
        this.vmPrintOutputPanel = new VmPrintOutputPanel(this.createOutputToolbar());
        JSplitPane splitPane = new JSplitPane(0, this.vmPanel, this.vmPrintOutputPanel);
        cp.add((Component)splitPane, "Center");
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(10);
        JvmMonGui.flattenSplitPane(splitPane);
        this.statusBar = new JLabel();
        cp.add((Component)this.statusBar, "South");
        this.vmPanel.refreshData();
    }

    private void createMemoryStatMenu(JMenuBar newMenuBar) {
        JMenu memMenu = new JMenu(Resources.getText("Memory", new Object[0]));
        memMenu.setMnemonic(77);
        newMenuBar.add(memMenu);
        JMenuItem printMallocStatistic = new JMenuItem(Resources.getText("Print malloc statistic", new Object[0]));
        printMallocStatistic.addActionListener(this);
        printMallocStatistic.setActionCommand("printMallocStatistic");
        memMenu.add(printMallocStatistic);
        JMenuItem printMallocStatisticInternals = new JMenuItem(Resources.getText("Print malloc statistic internals", new Object[0]));
        printMallocStatisticInternals.addActionListener(this);
        printMallocStatisticInternals.setActionCommand("printMallocStatisticInternals");
        memMenu.add(printMallocStatisticInternals);
        JMenuItem printMemoryHistory = new JMenuItem(Resources.getText("Print memory history", new Object[0]));
        printMemoryHistory.addActionListener(this);
        printMemoryHistory.setActionCommand("printMemoryHistory");
        memMenu.add(printMemoryHistory);
        memMenu.addSeparator();
        JMenuItem startMallocStatistic = new JMenuItem(Resources.getText("Start malloc statistic", new Object[0]));
        startMallocStatistic.addActionListener(this);
        startMallocStatistic.setActionCommand("startMallocStatistic");
        memMenu.add(startMallocStatistic);
        JMenuItem stopMallocStatistic = new JMenuItem(Resources.getText("Stop malloc statistic", new Object[0]));
        stopMallocStatistic.addActionListener(this);
        stopMallocStatistic.setActionCommand("stopMallocStatistic");
        memMenu.add(stopMallocStatistic);
        JMenuItem resetMallocStatistic = new JMenuItem(Resources.getText("Reset malloc statistic", new Object[0]));
        resetMallocStatistic.addActionListener(this);
        resetMallocStatistic.setActionCommand("resetMallocStatistic");
        memMenu.add(resetMallocStatistic);
    }

    private void createDebuggingMenu(JMenuBar newMenuBar) {
        JMenu debuggingMenu = new JMenu(Resources.getText("Debugging", new Object[0]));
        debuggingMenu.setMnemonic(68);
        newMenuBar.add(debuggingMenu);
        JMenuItem setDebuggingPortRangeMI = new JMenuItem(Resources.getText("Set debugging port range...", new Object[0]));
        setDebuggingPortRangeMI.addActionListener(this);
        setDebuggingPortRangeMI.setActionCommand("setDebuggingPortRange");
        debuggingMenu.add(setDebuggingPortRangeMI);
        JMenuItem startDebuggingMI = new JMenuItem(Resources.getText("Start debugging...", new Object[0]));
        startDebuggingMI.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        startDebuggingMI.addActionListener(this);
        startDebuggingMI.setActionCommand("startDebugging");
        startDebuggingMI.setIcon(IconManager.Debugging);
        debuggingMenu.add(startDebuggingMI);
        JMenuItem startLocalDebuggingMI = new JMenuItem(Resources.getText("Start local debugging...", new Object[0]));
        startLocalDebuggingMI.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        startLocalDebuggingMI.addActionListener(this);
        startLocalDebuggingMI.setActionCommand("startLocalDebugging");
        startLocalDebuggingMI.setIcon(IconManager.LocalDebugging);
        debuggingMenu.add(startLocalDebuggingMI);
        JMenuItem stopDebuggingMI = new JMenuItem(Resources.getText("Stop debugging", new Object[0]));
        stopDebuggingMI.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        stopDebuggingMI.addActionListener(this);
        stopDebuggingMI.setActionCommand("stopDebugging");
        stopDebuggingMI.setIcon(IconManager.StopDebugging);
        debuggingMenu.add(stopDebuggingMI);
    }

    private void createDumpMenu(JMenuBar newMenuBar) {
        JMenu dumpMenu = new JMenu(Resources.getText("Dump", new Object[0]));
        dumpMenu.setMnemonic(85);
        newMenuBar.add(dumpMenu);
        JMenuItem dumpStackTraceMI = new JMenuItem(Resources.getText("Dump stack trace", new Object[0]));
        dumpStackTraceMI.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        dumpStackTraceMI.addActionListener(this);
        dumpStackTraceMI.setActionCommand("dumpStackTrace");
        dumpStackTraceMI.setIcon(IconManager.Stack);
        dumpMenu.add(dumpStackTraceMI);
        JMenuItem dumpStackTraceWithInfoMI = new JMenuItem(Resources.getText("Dump stack trace with information...", new Object[0]));
        dumpStackTraceWithInfoMI.setAccelerator(KeyStroke.getKeyStroke(83, 512));
        dumpStackTraceWithInfoMI.addActionListener(this);
        dumpStackTraceWithInfoMI.setActionCommand("dumpStackTraceWithInfo");
        dumpMenu.add(dumpStackTraceWithInfoMI);
        JMenuItem dumpHeapMI = new JMenuItem(Resources.getText("Dump heap", new Object[0]));
        dumpHeapMI.setAccelerator(KeyStroke.getKeyStroke(72, 128));
        dumpHeapMI.addActionListener(this);
        dumpHeapMI.setActionCommand("dumpHeap");
        dumpHeapMI.setIcon(IconManager.Heap);
        dumpMenu.add(dumpHeapMI);
        JMenuItem dumpHeapWithInfoMI = new JMenuItem(Resources.getText("Dump heap with information...", new Object[0]));
        dumpHeapWithInfoMI.setAccelerator(KeyStroke.getKeyStroke(72, 512));
        dumpHeapWithInfoMI.addActionListener(this);
        dumpHeapWithInfoMI.setActionCommand("dumpHeapWithInfo");
        dumpMenu.add(dumpHeapWithInfoMI);
        JMenuItem dumpDllInfoMI = new JMenuItem(Resources.getText("Dump DLL info", new Object[0]));
        dumpDllInfoMI.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        dumpDllInfoMI.addActionListener(this);
        dumpDllInfoMI.setActionCommand("dumpDllInfo");
        dumpDllInfoMI.setIcon(IconManager.DLL);
        dumpMenu.add(dumpDllInfoMI);
        JMenuItem dumpGcHistoryMI = new JMenuItem(Resources.getText("Dump garbage collection history", new Object[0]));
        dumpGcHistoryMI.addActionListener(this);
        dumpGcHistoryMI.setActionCommand("dumpGcHistory");
        dumpGcHistoryMI.setIcon(IconManager.GarbageHistory);
        dumpMenu.add(dumpGcHistoryMI);
        JMenuItem dumpClassStatMI = new JMenuItem(Resources.getText("Dump class statistic", new Object[0]));
        dumpClassStatMI.setAccelerator(KeyStroke.getKeyStroke(67, 192));
        dumpClassStatMI.addActionListener(this);
        dumpClassStatMI.setActionCommand("dumpClassStatistic");
        dumpClassStatMI.setIcon(IconManager.Classes);
        dumpMenu.add(dumpClassStatMI);
        JMenuItem dumpDetailedClassStatMI = new JMenuItem(Resources.getText("Dump detailed class statistic", new Object[0]));
        dumpDetailedClassStatMI.setAccelerator(KeyStroke.getKeyStroke(67, 576));
        dumpDetailedClassStatMI.addActionListener(this);
        dumpDetailedClassStatMI.setActionCommand("dumpDetailedClassStatistic");
        dumpMenu.add(dumpDetailedClassStatMI);
        JMenuItem dumpCodeblobsMI = new JMenuItem(Resources.getText("Dump Codeblobs...", new Object[0]));
        dumpCodeblobsMI.setAccelerator(KeyStroke.getKeyStroke(66, 576));
        dumpCodeblobsMI.addActionListener(this);
        dumpCodeblobsMI.setActionCommand("dumpCodeblobs");
        dumpMenu.add(dumpCodeblobsMI);
        JMenuItem dumpHsErrorInfoMI = new JMenuItem(Resources.getText("Dump HsErrorInfo", new Object[0]));
        dumpHsErrorInfoMI.setAccelerator(KeyStroke.getKeyStroke(69, 192));
        dumpHsErrorInfoMI.addActionListener(this);
        dumpHsErrorInfoMI.setActionCommand("dumpHsErrorInfo");
        dumpMenu.add(dumpHsErrorInfoMI);
        JMenuItem dumpSymboInfoMI = new JMenuItem(Resources.getText("Dump symbol info", new Object[0]));
        dumpSymboInfoMI.setAccelerator(KeyStroke.getKeyStroke(73, 192));
        dumpSymboInfoMI.addActionListener(this);
        dumpSymboInfoMI.setActionCommand("dumpSymbolInfo");
        dumpMenu.add(dumpSymboInfoMI);
        JMenuItem dumpSafepointStateMI = new JMenuItem(Resources.getText("Dump safepoint state", new Object[0]));
        dumpSafepointStateMI.addActionListener(this);
        dumpSafepointStateMI.setActionCommand("dumpSafepointState");
        dumpMenu.add(dumpSafepointStateMI);
    }

    private JMenu createCommandMenu(JMenuBar newMenuBar) {
        JMenu commandMenu = new JMenu(Resources.getText("Command", new Object[0]));
        commandMenu.setMnemonic(67);
        newMenuBar.add(commandMenu);
        JMenuItem refreshMI = new JMenuItem(Resources.getText("Refresh", new Object[0]));
        refreshMI.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        refreshMI.addActionListener(this);
        refreshMI.setActionCommand("refresh");
        refreshMI.setIcon(IconManager.Refresh);
        commandMenu.add(refreshMI);
        JMenuItem addClusterMI = new JMenuItem(Resources.getText("Add cluster...", new Object[0]));
        addClusterMI.addActionListener(this);
        addClusterMI.setActionCommand("addCluster");
        addClusterMI.setIcon(IconManager.AddCluster);
        commandMenu.add(addClusterMI);
        commandMenu.addSeparator();
        JMenuItem exitVmMI = new JMenuItem(Resources.getText("Exit VM", new Object[0]));
        exitVmMI.setAccelerator(KeyStroke.getKeyStroke(69, isMacOS ? 256 : 128));
        exitVmMI.addActionListener(this);
        exitVmMI.setActionCommand("exitVM");
        commandMenu.add(exitVmMI);
        JMenuItem forceGcMI = new JMenuItem(Resources.getText("Force garbage collection", new Object[0]));
        forceGcMI.setAccelerator(KeyStroke.getKeyStroke(71, isMacOS ? 256 : 128));
        forceGcMI.addActionListener(this);
        forceGcMI.setActionCommand("forceGc");
        forceGcMI.setIcon(IconManager.Garbage);
        commandMenu.add(forceGcMI);
        JMenuItem forceMaxGcMI = new JMenuItem(Resources.getText("Force maximum compaction GC", new Object[0]));
        forceMaxGcMI.setAccelerator(KeyStroke.getKeyStroke(71, isMacOS ? 256 : 192));
        forceMaxGcMI.addActionListener(this);
        forceMaxGcMI.setActionCommand("forceMaxGc");
        commandMenu.add(forceMaxGcMI);
        JMenuItem retrieveGcHistory = new JMenuItem(Resources.getText("Retrieve complete GC history...", new Object[0]));
        retrieveGcHistory.addActionListener(this);
        retrieveGcHistory.setActionCommand("retrieveGcHistory");
        commandMenu.add(retrieveGcHistory);
        JMenuItem stopProfilingMI = new JMenuItem(Resources.getText("Stop profiling", new Object[0]));
        stopProfilingMI.setAccelerator(KeyStroke.getKeyStroke(80, 512));
        stopProfilingMI.addActionListener(this);
        stopProfilingMI.setActionCommand("stopProfiling");
        commandMenu.add(stopProfilingMI);
        JMenuItem changeCommandlineFlagsMI = new JMenuItem(Resources.getText("Change command line flags...", new Object[0]));
        changeCommandlineFlagsMI.setAccelerator(KeyStroke.getKeyStroke(70, 512));
        changeCommandlineFlagsMI.addActionListener(this);
        changeCommandlineFlagsMI.setActionCommand("changeCmdFlags");
        commandMenu.add(changeCommandlineFlagsMI);
        JMenuItem setCoreSizeToHardLimitMI = new JMenuItem(Resources.getText("Set core size limit to max", new Object[0]));
        setCoreSizeToHardLimitMI.setAccelerator(KeyStroke.getKeyStroke(67, 512));
        setCoreSizeToHardLimitMI.addActionListener(this);
        setCoreSizeToHardLimitMI.setActionCommand("setCoreSizeToHardLimit");
        commandMenu.add(setCoreSizeToHardLimitMI);
        JMenuItem setTraceFlagsMI = new JMenuItem(Resources.getText("Set trace flags...", new Object[0]));
        setTraceFlagsMI.setAccelerator(KeyStroke.getKeyStroke(84, isMacOS ? 256 : 128));
        setTraceFlagsMI.addActionListener(this);
        setTraceFlagsMI.setActionCommand("setTraceFlags");
        setTraceFlagsMI.setIcon(IconManager.Flags);
        commandMenu.add(setTraceFlagsMI);
        if (!isMacOS) {
            commandMenu.addSeparator();
            JMenuItem aboutMI = new JMenuItem(Resources.getText("About", new Object[0]));
            aboutMI.addActionListener(this);
            aboutMI.setActionCommand("about");
            commandMenu.add(aboutMI);
            JMenuItem exitMI = new JMenuItem(Resources.getText("Exit", new Object[0]));
            exitMI.setAccelerator(KeyStroke.getKeyStroke(115, 512));
            exitMI.addActionListener(this);
            exitMI.setActionCommand("exit");
            commandMenu.add(exitMI);
        }
        return commandMenu;
    }

    private void createToolbar(JToolBar newToolBar) {
        JButton refreshButton = new JButton(IconManager.Refresh);
        refreshButton.setActionCommand("refresh");
        refreshButton.addActionListener(this);
        refreshButton.setToolTipText(Resources.getText("Refreshes the complete content", new Object[0]));
        newToolBar.add(refreshButton);
        JButton addClusterButton = new JButton(IconManager.AddCluster);
        addClusterButton.setActionCommand("addCluster");
        addClusterButton.addActionListener(this);
        addClusterButton.setToolTipText(Resources.getText("Add cluster...", new Object[0]));
        newToolBar.add(addClusterButton);
        newToolBar.addSeparator();
        JButton dumpStackTraceButton = new JButton(IconManager.Stack);
        dumpStackTraceButton.setActionCommand("dumpStackTrace");
        dumpStackTraceButton.addActionListener(this);
        dumpStackTraceButton.setToolTipText(Resources.getText("Dump stack trace", new Object[0]));
        newToolBar.add(dumpStackTraceButton);
        JButton dumpHeapButton = new JButton(IconManager.Heap);
        dumpHeapButton.setActionCommand("dumpHeap");
        dumpHeapButton.addActionListener(this);
        dumpHeapButton.setToolTipText(Resources.getText("Dump heap", new Object[0]));
        newToolBar.add(dumpHeapButton);
        JButton dumpDllInfoButton = new JButton(IconManager.DLL);
        dumpDllInfoButton.setActionCommand("dumpDllInfo");
        dumpDllInfoButton.addActionListener(this);
        dumpDllInfoButton.setToolTipText(Resources.getText("Dump DLL info", new Object[0]));
        newToolBar.add(dumpDllInfoButton);
        JButton forceGcButton = new JButton(IconManager.Garbage);
        forceGcButton.setActionCommand("forceGc");
        forceGcButton.addActionListener(this);
        forceGcButton.setToolTipText(Resources.getText("Force garbage collection", new Object[0]));
        newToolBar.add(forceGcButton);
        JButton dumpGcHistoryButton = new JButton(IconManager.GarbageHistory);
        dumpGcHistoryButton.setActionCommand("dumpGcHistory");
        dumpGcHistoryButton.addActionListener(this);
        dumpGcHistoryButton.setToolTipText(Resources.getText("Dump garbage collection history", new Object[0]));
        newToolBar.add(dumpGcHistoryButton);
        JButton dumpClassStatButton = new JButton(IconManager.Classes);
        dumpClassStatButton.setActionCommand("dumpClassStatistic");
        dumpClassStatButton.addActionListener(this);
        dumpClassStatButton.setToolTipText(Resources.getText("Dump class statistic", new Object[0]));
        newToolBar.add(dumpClassStatButton);
        newToolBar.addSeparator();
        JButton setTraceFlagsButton = new JButton(IconManager.Flags);
        setTraceFlagsButton.setActionCommand("setTraceFlags");
        setTraceFlagsButton.addActionListener(this);
        setTraceFlagsButton.setToolTipText(Resources.getText("Set trace flags...", new Object[0]));
        newToolBar.add(setTraceFlagsButton);
        newToolBar.addSeparator();
        JButton startDebuggingButton = new JButton(IconManager.Debugging);
        startDebuggingButton.setActionCommand("startDebugging");
        startDebuggingButton.addActionListener(this);
        startDebuggingButton.setToolTipText(Resources.getText("Start debugging...", new Object[0]));
        newToolBar.add(startDebuggingButton);
        JButton startLocalDebuggingButton = new JButton(IconManager.LocalDebugging);
        startLocalDebuggingButton.setActionCommand("startLocalDebugging");
        startLocalDebuggingButton.addActionListener(this);
        startLocalDebuggingButton.setToolTipText(Resources.getText("Start local debugging...", new Object[0]));
        newToolBar.add(startLocalDebuggingButton);
        JButton stopDebuggingButton = new JButton(IconManager.StopDebugging);
        stopDebuggingButton.setActionCommand("stopDebugging");
        stopDebuggingButton.addActionListener(this);
        stopDebuggingButton.setToolTipText(Resources.getText("Stop debugging", new Object[0]));
        newToolBar.add(stopDebuggingButton);
        newToolBar.setRollover(true);
    }

    private void createPrintMenu(JMenuBar newMenuBar) {
        JMenu printMenu = new JMenu(Resources.getText("Print", new Object[0]));
        printMenu.setMnemonic(80);
        newMenuBar.add(printMenu);
        JMenuItem printStackTraceMI = new JMenuItem(Resources.getText("Print stack trace", new Object[0]));
        printStackTraceMI.setAccelerator(KeyStroke.getKeyStroke(83, isMacOS ? 256 : 192));
        printStackTraceMI.addActionListener(this);
        printStackTraceMI.setActionCommand(MonitorOperation.GET_STACK_TRACE.toString());
        printMenu.add(printStackTraceMI);
        JMenuItem printDllInfoMI = new JMenuItem(Resources.getText("Print DLL info", new Object[0]));
        printDllInfoMI.addActionListener(this);
        printDllInfoMI.setActionCommand(MonitorOperation.GET_DLL_INFO.toString());
        printMenu.add(printDllInfoMI);
        JMenuItem printCCSInfo = new JMenuItem(Resources.getText("Print compressed class-space info", new Object[0]));
        printCCSInfo.addActionListener(this);
        printCCSInfo.setActionCommand(MonitorOperation.GET_CCS_INTERNALS.toString());
        printMenu.add(printCCSInfo);
        JMenuItem printGcHistoryMI = new JMenuItem(Resources.getText("Print garbage collection history", new Object[0]));
        printGcHistoryMI.addActionListener(this);
        printGcHistoryMI.setActionCommand(MonitorOperation.GET_GC_HISTORY.toString());
        printMenu.add(printGcHistoryMI);
        JMenuItem printClassStatMI = new JMenuItem(Resources.getText("Print class statistic", new Object[0]));
        printClassStatMI.addActionListener(this);
        printClassStatMI.setActionCommand(MonitorOperation.GET_CLASS_STATISTIC.toString());
        printMenu.add(printClassStatMI);
        JMenuItem printDetailedClassStatMI = new JMenuItem(Resources.getText("Print detailed class statistic", new Object[0]));
        printDetailedClassStatMI.addActionListener(this);
        printDetailedClassStatMI.setActionCommand(MonitorOperation.GET_CLASS_STATISTIC.toString() + "Detailed");
        printMenu.add(printDetailedClassStatMI);
        JMenuItem printCodeblobsMI = new JMenuItem(Resources.getText("Print Codeblobs...", new Object[0]));
        printCodeblobsMI.addActionListener(this);
        printCodeblobsMI.setActionCommand(MonitorOperation.GET_CODE_BLOBS.toString());
        printMenu.add(printCodeblobsMI);
        JMenuItem printHsErrorInfoMI = new JMenuItem(Resources.getText("Print HsErrorInfo", new Object[0]));
        printHsErrorInfoMI.addActionListener(this);
        printHsErrorInfoMI.setActionCommand(MonitorOperation.GET_HS_ERROR_INFO.toString());
        printMenu.add(printHsErrorInfoMI);
        JMenuItem printSymboInfoMI = new JMenuItem(Resources.getText("Print symbol info...", new Object[0]));
        printSymboInfoMI.addActionListener(this);
        printSymboInfoMI.setActionCommand(MonitorOperation.GET_SYMBOL_INFO.toString());
        printMenu.add(printSymboInfoMI);
        final String virtTitle = Resources.getText("Print virtualization info...", new Object[0]);
        JMenuItem printVirtualizationInfo = new JMenuItem(virtTitle);
        printVirtualizationInfo.addActionListener(new InternalOperationActionListener(){

            @Override
            public String getTitle(MonitoredVm vm) {
                return ">>> Performed operation \"" + virtTitle + "\" on host \"" + vm.getController().getHost() + "\" with PID " + vm.getPid() + ":\n\n";
            }

            @Override
            public List<String> getOutput(MonitoredVm vm) {
                return PrintVirtualizationInfoCommand.getResultAsText(vm.getController().getVmInternalsByProcessId(vm.getPid()));
            }
        });
        printMenu.add(printVirtualizationInfo);
        JMenuItem printSignalHandlers = new JMenuItem(Resources.getText("Print signal handlers", new Object[0]));
        printSignalHandlers.addActionListener(this);
        printSignalHandlers.setActionCommand(MonitorOperation.GET_SIGNAL_HANDLERS.toString());
        printMenu.add(printSignalHandlers);
        JMenuItem printSystemInformation = new JMenuItem(Resources.getText("Print system information", new Object[0]));
        printSystemInformation.addActionListener(this);
        printSystemInformation.setActionCommand(MonitorOperation.GET_SYSTEM_INFORMATION.toString());
        printMenu.add(printSystemInformation);
        JMenuItem printSystemProperties = new JMenuItem(Resources.getText("Print system properties", new Object[0]));
        printSystemProperties.addActionListener(this);
        printSystemProperties.setActionCommand(MonitorOperation.GET_SYSTEM_PROPERTIES.toString());
        printMenu.add(printSystemProperties);
        JMenuItem printFlightrecorderMI = new JMenuItem(Resources.getText("Print Flightrecorder...", new Object[0]));
        printFlightrecorderMI.addActionListener(this);
        printFlightrecorderMI.setActionCommand(MonitorOperation.GET_FLIGHT_RECORDER.toString());
        printFlightrecorderMI.setAccelerator(KeyStroke.getKeyStroke(70, isMacOS ? 256 : 192));
        printMenu.add(printFlightrecorderMI);
        JMenuItem printJITInfo = new JMenuItem(Resources.getText("Print JIT info", new Object[0]));
        printJITInfo.addActionListener(this);
        printJITInfo.setActionCommand(MonitorOperation.GET_JIT_INFO.toString());
        printMenu.add(printJITInfo);
        printMenu.addSeparator();
        JMenuItem savePrintOutputAsMI = new JMenuItem(Resources.getText("Save print output as...", new Object[0]));
        savePrintOutputAsMI.addActionListener(this);
        savePrintOutputAsMI.setActionCommand("saveOutputAs");
        savePrintOutputAsMI.setIcon(IconManager.Save);
        printMenu.add(savePrintOutputAsMI);
        JMenuItem clearPrintOutputMI = new JMenuItem(Resources.getText("Clear print output", new Object[0]));
        clearPrintOutputMI.addActionListener(this);
        clearPrintOutputMI.setActionCommand("clearOutput");
        clearPrintOutputMI.setIcon(IconManager.Clear);
        printMenu.add(clearPrintOutputMI);
        printMenu.addSeparator();
        this.prevMenuItem = new JMenuItem(Resources.getText("Focus previous match", new Object[0]));
        this.prevMenuItem.addActionListener(this);
        this.prevMenuItem.setActionCommand("prevMatch");
        this.prevMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, isMacOS ? 256 : 128));
        printMenu.add(this.prevMenuItem);
        this.nextMenuItem = new JMenuItem(Resources.getText("Focus next match", new Object[0]));
        this.nextMenuItem.addActionListener(this);
        this.nextMenuItem.setActionCommand("nextMatch");
        this.nextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        printMenu.add(this.nextMenuItem);
    }

    private JToolBar createOutputToolbar() {
        JToolBar outputToolbar = new JToolBar();
        JButton clearButton = new JButton(IconManager.Clear);
        clearButton.addActionListener(this);
        clearButton.setToolTipText(Resources.getText("Clear output text window", new Object[0]));
        clearButton.setActionCommand("clearOutput");
        outputToolbar.add(clearButton);
        JButton saveButton = new JButton(IconManager.Save);
        saveButton.addActionListener(this);
        saveButton.setToolTipText(Resources.getText("Save the print output into a file", new Object[0]));
        saveButton.setActionCommand("saveOutputAs");
        outputToolbar.add(saveButton);
        outputToolbar.addSeparator();
        JLabel searchLabel = new JLabel(Resources.getText("Search Pattern:", new Object[0]), 4);
        searchLabel.setToolTipText(Resources.getText("Search pattern (Ctrl-F)", new Object[0]));
        searchLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        outputToolbar.add(searchLabel);
        this.searchPatternEdit = new JTextField();
        this.searchPatternEdit.setMaximumSize(new Dimension(150, 30));
        this.searchPatternEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String pattern = textField.getText();
                if (pattern.length() != 0) {
                    JvmMonGui.this.vmPrintOutputPanel.setSearchPattern(pattern);
                } else {
                    JvmMonGui.this.vmPrintOutputPanel.setSearchPattern(null);
                }
                JvmMonGui.this.updatePrevNextButtons();
                JvmMonGui.this.vmPrintOutputPanel.getTextOutput().requestFocus();
            }
        });
        this.searchPatternEdit.getInputMap(2).put(KeyStroke.getKeyStroke(70, isMacOS ? 256 : 128), "setSearchFocus");
        this.searchPatternEdit.getActionMap().put("setSearchFocus", new TextfieldFocusAction(this.searchPatternEdit));
        this.searchPatternEdit.setToolTipText(Resources.getText("Search pattern (Ctrl-F)", new Object[0]));
        outputToolbar.add(this.searchPatternEdit);
        this.prevButton = new JButton(IconManager.LeftArrow);
        this.prevButton.addActionListener(this);
        this.prevButton.setToolTipText(Resources.getText("Focus previous match", new Object[0]));
        this.prevButton.setActionCommand("prevMatch");
        outputToolbar.add(this.prevButton);
        this.nextButton = new JButton(IconManager.RightArrow);
        this.nextButton.addActionListener(this);
        this.nextButton.setToolTipText(Resources.getText("Focus next match", new Object[0]));
        this.nextButton.setActionCommand("nextMatch");
        outputToolbar.add(this.nextButton);
        outputToolbar.setRollover(true);
        return outputToolbar;
    }

    private void performSimpleCommand(String cmd, MonitoredVm vm) throws IOException {
        ConnectableVm.LegacyMonitorOperationResult result = null;
        if ("dumpStackTrace".equals(cmd)) {
            vm.getStackTrace(true, true, null);
        } else if ("dumpHeap".equals(cmd)) {
            vm.dumpHeap(true, null);
        } else if ("dumpDllInfo".equals(cmd)) {
            vm.getDllInfo(true);
        } else if ("forceGc".equals(cmd)) {
            vm.forceGc(false);
        } else if ("forceMaxGc".equals(cmd)) {
            vm.forceGc(true);
        } else if ("dumpGcHistory".equals(cmd)) {
            vm.getGcHistory(true);
        } else if ("dumpClassStatistic".equals(cmd)) {
            vm.getClassStatistic(true, false);
        } else if ("dumpDetailedClassStatistic".equals(cmd)) {
            vm.getClassStatistic(true, true);
        } else if ("dumpHsErrorInfo".equals(cmd)) {
            vm.getHsInfo(true);
        } else if ("dumpSymbolInfo".equals(cmd)) {
            vm.getSymbolInfo(true, 0);
        } else if ("printMallocStatistic".equals(cmd)) {
            result = vm.getMallocStatistic(false);
        } else if ("printMallocStatisticInternals".equals(cmd)) {
            result = vm.getMallocStatisticInternals(false);
        } else if ("printMemoryHistory".equals(cmd)) {
            result = vm.getMemoryHistory(false);
        } else if ("startMallocStatistic".equals(cmd)) {
            vm.startMallocStatistic();
        } else if ("stopMallocStatistic".equals(cmd)) {
            vm.stopMallocStatistic();
        } else if ("resetMallocStatistic".equals(cmd)) {
            vm.resetMallocStatistic();
        } else if ("stopProfiling".equals(cmd)) {
            vm.stopCommandLineProfiling();
        } else if ("setCoreSizeToHardLimit".equals(cmd)) {
            vm.setCoreSizeLimitToMax();
        }
        if (result != null && result.data != null) {
            this.vmPrintOutputPanel.print(result.data);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if ("refresh".equals(cmd)) {
            this.vmPanel.refreshData();
        } else if ("exit".equals(cmd)) {
            System.exit(0);
        } else if ("about".equals(cmd)) {
            AboutDialog.show(this);
        } else if ("exitVM".equals(cmd)) {
            if (JOptionPane.showConfirmDialog(this, Resources.getText("Do you really want to exit the VM(s)?", new Object[0]), Resources.getText("Confirmation", new Object[0]), 0) != 0) {
                return;
            }
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    if (JvmMon.isNew()) {
                        vm.exitVm(1, ConnectableVm.ExitType.JAVA);
                        continue;
                    }
                    vm.getVmOld().exit(1);
                }
                catch (InvalidVmException | IOException ex) {
                    Trace.get(this.getClass()).error(ex);
                }
            }
        } else if ("dumpStackTrace".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().printStackDump();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("dumpStackTraceWithInfo".equals(cmd)) {
            if (this.vmListPanel.getSelectedRows().size() > 0) {
                StackTraceDialog.showDialog(this, Resources.getText("Dump stack trace with information...", new Object[0]), this.vmListPanel.getSelectedRows());
            }
        } else if ("setTraceFlags".equals(cmd)) {
            if (this.vmListPanel.getSelectedRows().size() > 0) {
                TraceFlagsDialog.showDialog(this, Resources.getText("Set trace flags...", new Object[0]), this.vmListPanel.getSelectedRows());
            }
            this.vmPanel.getVmDetailPanel().refresh();
        } else if ("dumpHeap".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpHeap();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("dumpHeapWithInfo".equals(cmd)) {
            if (this.vmListPanel.getSelectedRows().size() > 0) {
                HeapDumpDialog.showDialog(this, Resources.getText("Dump heap with information...", new Object[0]), this.vmListPanel.getSelectedRows());
            }
        } else if ("dumpDllInfo".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpDllInformation();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("forceGc".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().forceGc();
                }
                catch (InvalidVmException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("forceMaxGc".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().forceMaxGc();
                }
                catch (InvalidVmException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("retrieveGcHistory".equals(cmd)) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(Resources.getText("Save complete GC history as...", new Object[0]));
            chooser.setMultiSelectionEnabled(false);
            chooser.setSelectedFile(new File("sapjvm_gc.prf"));
            chooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return Resources.getText("GC History file", new Object[0]);
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".prf");
                }
            });
            if (chooser.showSaveDialog(this) != 0) {
                this.setStatusBarText(Resources.getText("Canceled command", new Object[0]) + " " + cmd);
            } else {
                String fileName = chooser.getSelectedFile().getPath();
                for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                    try {
                        int result;
                        String gcFileName;
                        byte[] gcHistory;
                        byte[] byArray = gcHistory = JvmMon.isNew() ? vm.retrieveGcHistory() : vm.getVmOld().retrieveCompleteGcHistory();
                        if (gcHistory == null || gcHistory.length == 0) {
                            JOptionPane.showMessageDialog(this, Resources.getText("The selected VMs does not have a GC history.", new Object[0]), Resources.getText("No GC History found", new Object[0]), 1);
                            continue;
                        }
                        if (this.vmListPanel.getSelectedRows().size() > 1) {
                            StringBuilder sb = new StringBuilder(fileName);
                            int pid = vm.getPid();
                            int suffixPos = fileName.lastIndexOf(46);
                            if (suffixPos >= 0 && suffixPos < sb.length()) {
                                sb.insert(suffixPos, "_" + pid);
                            } else {
                                sb.append("_" + pid);
                            }
                            gcFileName = sb.toString();
                        } else {
                            gcFileName = fileName;
                        }
                        if (new File(gcFileName).exists() && (result = JOptionPane.showConfirmDialog(this, Resources.getText("File {0} already exists. Do you want to overwrite the existing file?", gcFileName), Resources.getText("Confirm Overwrite", new Object[0]), 0, 3)) != 0) continue;
                        FileOutputStream fos = new FileOutputStream(gcFileName);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        bos.write(gcHistory);
                        bos.close();
                    }
                    catch (InvalidVmException | IOException ex) {
                        Trace.get(this.getClass()).error(ex);
                    }
                }
            }
        } else if ("dumpGcHistory".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpGcHistory();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("dumpClassStatistic".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpClassStatistic();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("dumpDetailedClassStatistic".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpDetailedClassStatistic();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("dumpCodeblobs".equals(cmd)) {
            if (CodeblobDumpDialog.showDialog(this, Resources.getText("Dump Codeblobs Parameter", new Object[0]))) {
                for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                    try {
                        if (JvmMon.isNew()) {
                            vm.getCodeBlobs(true, CodeblobDumpDialog.getMethodName(), CodeblobDumpDialog.getDetailFlag());
                            continue;
                        }
                        vm.getVmOld().dumpCodeblobs(CodeblobDumpDialog.getMethodName(), CodeblobDumpDialog.getDetailFlag());
                    }
                    catch (IOException ex) {
                        Trace.get(this.getClass()).error((Throwable)ex);
                    }
                }
            }
        } else if ("dumpHsErrorInfo".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpHsErrorInfo();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("dumpSymbolInfo".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpSymbolInfo();
                }
                catch (IOException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("dumpSafepointState".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    vm.getVmOld().dumpSafepointState();
                }
                catch (InvalidVmException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
            }
        } else if ("stopProfiling".equals(cmd)) {
            int vms = 0;
            int remoteVms = 0;
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                if (!vm.getController().isLocal()) {
                    ++remoteVms;
                }
                ++vms;
            }
            if (remoteVms > 0) {
                JOptionPane.showMessageDialog(this, Resources.getText("This operation is not supported for VMs running on a remote host", new Object[0]), Resources.getText("Not supported operation", new Object[0]), 2);
            }
            if (vms - remoteVms == 0) {
                return;
            }
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                if (!vm.getController().isLocal()) continue;
                try {
                    ClusterImpl.getVm((int)vm.getPid()).stopCommandLineProfiling();
                }
                catch (InvalidVmException e) {
                    Trace.get(this.getClass()).error((Throwable)e);
                }
            }
        } else if ("setCoreSizeToHardLimit".equals(cmd)) {
            int vms = 0;
            int remoteVms = 0;
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                if (!vm.getController().isLocal()) {
                    ++remoteVms;
                }
                ++vms;
            }
            if (remoteVms > 0) {
                JOptionPane.showMessageDialog(this, Resources.getText("This operation is not supported for VMs running on a remote host", new Object[0]), Resources.getText("Not supported operation", new Object[0]), 2);
            }
            if (vms - remoteVms == 0) {
                return;
            }
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                if (!vm.getController().isLocal()) continue;
                try {
                    ClusterImpl.getVm((int)vm.getPid()).setCoreSizeToMax();
                }
                catch (InvalidVmException e) {
                    Trace.get(this.getClass()).error((Throwable)e);
                }
            }
        } else if ("changeCmdFlags".equals(cmd)) {
            int supportedVms = 0;
            int unsupportedVms = 0;
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                if (vm.getController().isOldJvmmond()) {
                    ++unsupportedVms;
                    continue;
                }
                ++supportedVms;
            }
            if (unsupportedVms > 0) {
                JOptionPane.showMessageDialog(this, Resources.getText("This operation is not supported for remote VMs via legacy RMI jvmmond.", new Object[0]), Resources.getText("Not supported operation", new Object[0]), 2);
            }
            if (supportedVms == 0) {
                return;
            }
            if (this.vmListPanel.getSelectedRows().size() > 0) {
                CommandLineFlagsDialog.showDialog(this, Resources.getText("Change command line flags...", new Object[0]), this.vmListPanel.getSelectedRows());
                this.vmPanel.getVmDetailPanel().refresh();
            }
        } else if ("setDebuggingPortRange".equals(cmd)) {
            if (this.vmListPanel.getSelectedRows().size() > 0) {
                DebuggingPortRangeDialog.showDialog(this, Resources.getText("Set debugging port range...", new Object[0]), this.vmListPanel.getSelectedRows());
                this.vmPanel.getVmDetailPanel().refresh();
            }
        } else if ("startDebugging".equals(cmd) || "startLocalDebugging".equals(cmd)) {
            ArrayList<MonitoredVm> vms = new ArrayList<MonitoredVm>();
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                if (vm.getBoard().getDebugPort() != -1) continue;
                vms.add(vm);
            }
            if (vms.size() == 0) {
                return;
            }
            boolean localDebug = !"startDebugging".equals(cmd);
            DebuggingDialog.showDialog(this, Resources.getText(localDebug ? "Start local debugging..." : "Start debugging...", new Object[0]), vms, localDebug);
            this.vmPanel.getVmDetailPanel().refresh();
        } else if ("stopDebugging".equals(cmd)) {
            for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                try {
                    if (JvmMon.isNew()) {
                        vm.closeDebugPort();
                        continue;
                    }
                    vm.getVmOld().stopDebug();
                }
                catch (InvalidVmException | IOException ex) {
                    Trace.get(this.getClass()).error(ex);
                }
            }
            this.vmPanel.getVmDetailPanel().refresh();
        } else if ("addCluster".equals(cmd)) {
            AddClusterDialog.showDialog(this, Resources.getText("Add cluster...", new Object[0]), this.connectionList);
            this.vmPanel.refreshData();
        } else if ("saveOutputAs".equals(cmd)) {
            int returnVal;
            JFileChooser fc = new JFileChooser();
            if (this.currentSaveDirectory != null) {
                fc.setCurrentDirectory(this.currentSaveDirectory);
            }
            if ((returnVal = fc.showSaveDialog(this)) == 0) {
                File file = fc.getSelectedFile();
                this.vmPrintOutputPanel.write(file);
                this.currentSaveDirectory = fc.getCurrentDirectory();
            }
        } else if ("clearOutput".equals(cmd)) {
            this.vmPrintOutputPanel.clear();
            this.updatePrevNextButtons();
            this.searchPatternEdit.setText("");
        } else if ("prevMatch".equals(cmd)) {
            if (this.vmPrintOutputPanel.hasPreviousSearchPos()) {
                this.vmPrintOutputPanel.previousSearchPos();
                this.updatePrevNextButtons();
            }
        } else if ("nextMatch".equals(cmd)) {
            if (this.vmPrintOutputPanel.hasNextSearchPos()) {
                this.vmPrintOutputPanel.nextSearchPos();
                this.updatePrevNextButtons();
            }
        } else if (cmd.equals(MonitorOperation.GET_CLASS_STATISTIC.toString() + "Detailed")) {
            this.performPrintCommand(new String[]{"true"}, MonitorOperation.GET_CLASS_STATISTIC);
        } else {
            boolean wasPrint = false;
            for (MonitorOperation op : MonitorOperation.values()) {
                if (!op.toString().equals(cmd)) continue;
                wasPrint = true;
                ArrayList<String> args = new ArrayList<String>();
                if (this.fillArguments(args, op)) break;
                String[] stringArguments = new String[args.size()];
                args.toArray(stringArguments);
                this.performPrintCommand(stringArguments, op);
                break;
            }
            if (!wasPrint) {
                for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
                    try {
                        this.performSimpleCommand(cmd, vm);
                    }
                    catch (IOException ex) {
                        Trace.get(this.getClass()).error((Throwable)ex);
                    }
                }
            }
        }
        this.setStatusBarText(Resources.getText("Triggered command", new Object[0]) + " " + cmd);
    }

    private boolean fillArguments(List<String> args, MonitorOperation op) {
        boolean cancelled = false;
        if (op == MonitorOperation.GET_STACK_TRACE) {
            args.add("-l");
        } else if (op == MonitorOperation.GET_SYSTEM_INFORMATION) {
            args.add("full");
        } else if (op == MonitorOperation.GET_CODE_BLOBS) {
            if (CodeblobDumpDialog.showDialog(this, Resources.getText("Print Codeblobs Parameter", new Object[0]))) {
                args.add(CodeblobDumpDialog.getMethodName());
                args.add(CodeblobDumpDialog.getDetailFlag() ? "true" : "false");
            } else {
                cancelled = true;
            }
        } else if (op == MonitorOperation.GET_FLIGHT_RECORDER) {
            String numberValue = JOptionPane.showInputDialog(this, Resources.getText("Please enter number of last flightrecorder events", new Object[0]), String.valueOf(this.lastFlightRecoderNum));
            cancelled = true;
            if (numberValue != null) {
                try {
                    int number = Integer.parseInt(numberValue);
                    if (number <= 0) {
                        throw new NumberFormatException();
                    }
                    args.add(numberValue);
                    this.lastFlightRecoderNum = number;
                    cancelled = false;
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, Resources.getText("Only Integers > 0 are allowed.", new Object[0]), Resources.getText("Error", new Object[0]), 2);
                }
            }
        } else if (op == MonitorOperation.GET_SYMBOL_INFO) {
            String numberValue = JOptionPane.showInputDialog(this, Resources.getText("Please enter number of symbols", new Object[0]), String.valueOf(this.lastSymbolInfoNum));
            cancelled = true;
            if (numberValue != null) {
                try {
                    int number = Integer.parseInt(numberValue);
                    if (number <= 0) {
                        throw new NumberFormatException();
                    }
                    args.add(numberValue);
                    this.lastSymbolInfoNum = number;
                    cancelled = false;
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, Resources.getText("Only Integers > 0 are allowed.", new Object[0]), Resources.getText("Error", new Object[0]), 2);
                }
            }
        }
        return cancelled;
    }

    private void performPrintCommand(String[] stringArguments, MonitorOperation op) {
        for (MonitoredVm vm : this.vmListPanel.getSelectedRows()) {
            int i;
            StackTraceElement[] st;
            StringBuffer sb;
            if (JvmMon.isNew()) {
                try {
                    sb = new StringBuffer();
                    ConnectableVm.LegacyMonitorOperationResult result = vm.performLegacyMonitorOperation(op, stringArguments);
                    sb.append("\n");
                    sb.append(">>> Performed operation " + op.getOperationFunction() + " on VM with Pid " + vm.getBoard().getPid() + ":\n\n");
                    if (result.errorMessage != null) {
                        sb.append("Got the following error: " + result.errorMessage);
                    } else {
                        sb.append(result.data);
                    }
                    this.vmPrintOutputPanel.print(sb.toString());
                    continue;
                }
                catch (IOException e) {
                    this.vmPrintOutputPanel.print("Error occured:");
                    this.vmPrintOutputPanel.print(e.getMessage());
                    st = e.getStackTrace();
                    for (i = 0; i < st.length; ++i) {
                        this.vmPrintOutputPanel.print(st[i].toString());
                    }
                    continue;
                }
            }
            try {
                sb = new StringBuffer();
                List lines = vm.getVmOld().performOperation(op, stringArguments);
                sb.append("\n");
                sb.append(">>> Performed operation " + op.getOperationFunction() + " on VM with Pid " + vm.getPid() + ":\n\n");
                for (String line : lines) {
                    sb.append(line);
                    sb.append("\n");
                }
                this.vmPrintOutputPanel.print(sb.toString());
            }
            catch (IOException e) {
                this.vmPrintOutputPanel.print("Error occured:");
                this.vmPrintOutputPanel.print(e.getMessage());
                st = e.getStackTrace();
                for (i = 0; i < st.length; ++i) {
                    this.vmPrintOutputPanel.print(st[i].toString());
                }
            }
        }
        this.updatePrevNextButtons();
    }

    @Override
    public void notify(MonitoredVm vmDescription) {
        this.updateControls();
    }

    private void setStatusBarText(String text) {
        this.statusBarTimer.cancel();
        this.statusBar.setText(text);
        this.statusBarTimer = new Timer();
        this.statusBarTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                JvmMonGui.this.clearStatusBar();
            }
        }, 5000L, 5000L);
    }

    private void clearStatusBar() {
        this.statusBar.setText("");
    }

    private void updatePrevNextButtons() {
        if (this.vmPrintOutputPanel != null) {
            if (this.prevButton != null) {
                this.prevButton.setEnabled(this.vmPrintOutputPanel.hasPreviousSearchPos());
            }
            if (this.nextButton != null) {
                this.nextButton.setEnabled(this.vmPrintOutputPanel.hasNextSearchPos());
            }
            if (this.prevMenuItem != null) {
                this.prevMenuItem.setEnabled(this.vmPrintOutputPanel.hasPreviousSearchPos());
            }
            if (this.nextMenuItem != null) {
                this.nextMenuItem.setEnabled(this.vmPrintOutputPanel.hasNextSearchPos());
            }
        }
    }

    private void updateControls() {
        List<MonitoredVm> rows = this.vmListPanel.getSelectedRows();
        boolean vmAvailable = rows.size() > 0;
        int numMenus = this.menuBar.getMenuCount();
        for (int i = 0; i < numMenus; ++i) {
            JMenu menu = this.menuBar.getMenu(i);
            int menuItems = menu.getItemCount();
            for (int j = 0; j < menuItems; ++j) {
                JMenuItem menuItem = menu.getItem(j);
                if (menuItem == null) continue;
                boolean alwaysActive = Arrays.binarySearch(actionsAlwaysAvailable, menuItem.getActionCommand()) >= 0;
                menuItem.setEnabled(alwaysActive || vmAvailable);
            }
        }
        int numButtons = this.toolBar.getComponentCount();
        for (int i = 0; i < numButtons; ++i) {
            Component c = this.toolBar.getComponentAtIndex(i);
            if (c == null || !(c instanceof JButton)) continue;
            JButton toolBarButton = (JButton)c;
            boolean alwaysActive = Arrays.binarySearch(actionsAlwaysAvailable, toolBarButton.getActionCommand()) >= 0;
            toolBarButton.setEnabled(alwaysActive || vmAvailable);
        }
        for (MonitorOperation op : MonitorOperation.values()) {
            JButton button;
            boolean opAvailable = true;
            JMenuItem menuItem = this.getMenuItemWithActionCommand(op.toString());
            if (menuItem != null) {
                menuItem.setEnabled(opAvailable);
            }
            if ((button = this.getToolBarButtonWithActionCommand(op.toString())) == null) continue;
            button.setEnabled(opAvailable);
        }
        JMenuItem classStatisticMI = this.getMenuItemWithActionCommand(MonitorOperation.GET_CLASS_STATISTIC.toString());
        JMenuItem detailedClassStatisticMI = this.getMenuItemWithActionCommand(MonitorOperation.GET_CLASS_STATISTIC.toString() + "Detailed");
        if (detailedClassStatisticMI != null && classStatisticMI != null) {
            detailedClassStatisticMI.setEnabled(classStatisticMI.isEnabled());
        }
        this.updatePrevNextButtons();
    }

    private JMenuItem getMenuItemWithActionCommand(String actionCommand) {
        JMenuItem result = null;
        int numMenus = this.menuBar.getMenuCount();
        for (int i = 0; i < numMenus && result == null; ++i) {
            JMenu menu = this.menuBar.getMenu(i);
            int menuItems = menu.getItemCount();
            for (int j = 0; j < menuItems && result == null; ++j) {
                JMenuItem menuItem = menu.getItem(j);
                if (menuItem == null || !menuItem.getActionCommand().equals(actionCommand)) continue;
                result = menuItem;
            }
        }
        return result;
    }

    private JButton getToolBarButtonWithActionCommand(String actionCommand) {
        JButton result = null;
        int numButtons = this.toolBar.getComponentCount();
        for (int i = 0; i < numButtons && result == null; ++i) {
            JButton toolBarButton;
            Component c = this.toolBar.getComponentAtIndex(i);
            if (c == null || !(c instanceof JButton) || !(toolBarButton = (JButton)c).getActionCommand().equals(actionCommand)) continue;
            result = toolBarButton;
        }
        return result;
    }

    public static void flattenSplitPane(JSplitPane splitPane) {
        splitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){
                    private static final long serialVersionUID = -5474779557165643556L;

                    @Override
                    public void setBorder(Border b) {
                    }
                };
            }
        });
        splitPane.setBorder(null);
    }

    static {
        Arrays.sort(actionsAlwaysAvailable);
    }

    private abstract class InternalOperationActionListener
    implements ActionListener {
        private InternalOperationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MonitoredVm vm : JvmMonGui.this.vmListPanel.getSelectedRows()) {
                StringBuffer sb = new StringBuffer();
                List<String> lines = this.getOutput(vm);
                sb.append("\n");
                sb.append(this.getTitle(vm));
                for (String line : lines) {
                    sb.append(line);
                    sb.append("\n");
                }
                JvmMonGui.this.vmPrintOutputPanel.print(sb.toString());
                JvmMonGui.this.updatePrevNextButtons();
            }
        }

        public abstract String getTitle(MonitoredVm var1);

        public abstract List<String> getOutput(MonitoredVm var1);
    }
}

