/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.tools.monitor.jvmmon.Formatter;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmListEventListener;
import com.sap.jvm.tracing.Trace;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SharedMemoryConfigurationPanel
extends JPanel
implements VmListEventListener,
ActionListener {
    private static final long serialVersionUID = 5665962532380378580L;
    private static final int PREFERRED_HORIZONAL_PANEL_SIZE = 170;
    private static final int PREFERRED_VERTICAL_PANEL_SIZE = 150;
    private SharedMemoryConfigurationTableModel configTableModel;
    private JTable configTable;
    private static final int SIZE_UNIT_BYTES = 1;
    private static final int SIZE_UNIT_KB = 2;
    private static final int SIZE_UNIT_MB = 3;
    private static final int SIZE_UNIT_GB = 4;
    private int sizeUnit = 3;
    private SizeRenderer sizeRenderer = new SizeRenderer();

    public SharedMemoryConfigurationPanel() {
        super(new GridLayout(1, 0));
        this.configTableModel = new SharedMemoryConfigurationTableModel();
        this.configTable = new JTable(this.configTableModel){
            private static final long serialVersionUID = 7984262667050547302L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                if (realColumnIndex == 1) {
                    return Formatter.formatMemSimple(SharedMemoryConfigurationPanel.this.configTableModel.getSize(rowIndex));
                }
                return null;
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column > 0) {
                    return SharedMemoryConfigurationPanel.this.sizeRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.configTable.setPreferredScrollableViewportSize(new Dimension(170, 150));
        this.createContextMenu();
        JScrollPane scrollPane = new JScrollPane(this.configTable);
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        TitledBorder title = BorderFactory.createTitledBorder(loweredbevel, Resources.getText("Shared Memory Configuration", new Object[0]));
        title.setTitlePosition(1);
        scrollPane.setBorder(title);
        this.add(scrollPane);
    }

    @Override
    public void notify(MonitoredVm vm) {
        this.configTableModel.fillData(vm);
        this.configTableModel.fireTableDataChanged();
    }

    public void setSelectedRow(int index) {
        if (index > this.configTable.getRowCount() - 1) {
            return;
        }
        ListSelectionModel listSelectionModel = this.configTable.getSelectionModel();
        listSelectionModel.setSelectionInterval(index, index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("setSizeBytes".equals(e.getActionCommand())) {
            if (this.sizeUnit != 1) {
                this.sizeUnit = 1;
                this.configTableModel.fireTableDataChanged();
            }
        } else if ("setSizeKB".equals(e.getActionCommand())) {
            if (this.sizeUnit != 2) {
                this.sizeUnit = 2;
                this.configTableModel.fireTableDataChanged();
            }
        } else if ("setSizeMB".equals(e.getActionCommand())) {
            if (this.sizeUnit != 3) {
                this.sizeUnit = 3;
                this.configTableModel.fireTableDataChanged();
            }
        } else if ("setSizeGB".equals(e.getActionCommand()) && this.sizeUnit != 4) {
            this.sizeUnit = 4;
            this.configTableModel.fireTableDataChanged();
        }
    }

    private void createContextMenu() {
        JPopupMenu popup = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in Bytes", new Object[0]));
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeBytes");
        rbMenuItem.setMnemonic(66);
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in KB", new Object[0]));
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeKB");
        rbMenuItem.setMnemonic(75);
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in MB", new Object[0]));
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(77);
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeMB");
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in GB", new Object[0]));
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(77);
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeGB");
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        PopupListener popupListener = new PopupListener(popup);
        this.configTable.addMouseListener(popupListener);
        this.addMouseListener(popupListener);
    }

    class SharedMemoryConfigurationTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5569932422429082358L;
        private String[] columnNames = new String[]{Resources.getText("Memory Area", new Object[0]), Resources.getText("Size", new Object[0])};
        private List<SharedMemoryConfigurationTableRow> configData;

        public SharedMemoryConfigurationTableModel() {
            this.fillData(null);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.configData.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            SharedMemoryConfigurationTableRow rowData = this.configData.get(row);
            switch (col) {
                case 0: {
                    return rowData.name;
                }
                case 1: {
                    return rowData.size;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public long getSize(int row) {
            SharedMemoryConfigurationTableRow rowData = this.configData.get(row);
            return rowData.size;
        }

        public void fillData(MonitoredVm vm) {
            VmMemoryInfo memoryInfo;
            this.configData = new ArrayList<SharedMemoryConfigurationTableRow>();
            if (vm == null || !vm.getController().isConnected() || vm.getController().isDisabled()) {
                return;
            }
            try {
                memoryInfo = vm.getVmOld().getMemoryInfo();
            }
            catch (InvalidVmException ex) {
                Trace.get(this.getClass()).error((Throwable)ex);
                return;
            }
            SharedMemoryConfigurationTableRow row = new SharedMemoryConfigurationTableRow();
            row.name = Resources.getText("Pool Size", new Object[0]);
            row.size = memoryInfo.getSharedPoolSize();
            this.configData.add(row);
        }
    }

    class SharedMemoryConfigurationTableRow {
        public String name;
        public long size;

        SharedMemoryConfigurationTableRow() {
        }
    }

    class SizeRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -2957433529661944757L;

        public SizeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Long) {
                long size = (Long)value;
                if (size == -1L) {
                    this.setText(Resources.getText("<undefined>", new Object[0]));
                    return;
                }
                switch (SharedMemoryConfigurationPanel.this.sizeUnit) {
                    case 1: {
                        this.setText(Formatter.formatMemBytes(size));
                        break;
                    }
                    case 2: {
                        this.setText(Formatter.formatMemKB(size));
                        break;
                    }
                    case 3: {
                        this.setText(Formatter.formatMemMB(size));
                        break;
                    }
                    case 4: {
                        this.setText(Formatter.formatMemGB(size));
                    }
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

