/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.tools.monitor.jvmmon.Formatter;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tools.monitor.jvmmon.gui.TableSorter;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmListEventListener;
import com.sap.jvm.tracing.Trace;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SharedMemoryStatePanel
extends JPanel
implements VmListEventListener,
ActionListener {
    private static final long serialVersionUID = -3680121974189354027L;
    private static final int PREFERRED_HORIZONAL_SPLIT_PANE_SIZE = 400;
    private static final int PREFERRED_VERTICAL_SPLIT_PANE_SIZE = 200;
    private static final int SIZE_UNIT_BYTES = 1;
    private static final int SIZE_UNIT_KB = 2;
    private static final int SIZE_UNIT_MB = 3;
    private static final int SIZE_UNIT_GB = 4;
    private int sizeUnit = 3;
    private SizeRenderer sizeRenderer = new SizeRenderer();
    private SharedMemoryStateTableModel tableModel = new SharedMemoryStateTableModel();
    private JTable table;

    public SharedMemoryStatePanel() {
        super(new GridLayout(1, 0));
        TableSorter tableSorter = new TableSorter(this.tableModel);
        this.table = new JTable(tableSorter){
            private static final long serialVersionUID = 215646090761016943L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                if (realColumnIndex == 1 || realColumnIndex == 3 || realColumnIndex == 5) {
                    return Formatter.formatMemSimple(SharedMemoryStatePanel.this.tableModel.getSizeAt(rowIndex, realColumnIndex));
                }
                return null;
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column > 0) {
                    return SharedMemoryStatePanel.this.sizeRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        };
        tableSorter.setTableHeader(this.table.getTableHeader());
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 200));
        JScrollPane scrollPane = new JScrollPane(this.table);
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        TitledBorder title = BorderFactory.createTitledBorder(loweredbevel, Resources.getText("Shared Memory State", new Object[0]));
        title.setTitlePosition(1);
        scrollPane.setBorder(title);
        this.createContextMenu();
        this.add(scrollPane);
    }

    @Override
    public void notify(MonitoredVm vm) {
        this.tableModel.fillData(vm);
        this.tableModel.fireTableDataChanged();
    }

    private void createContextMenu() {
        JPopupMenu popup = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in Bytes", new Object[0]));
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeBytes");
        rbMenuItem.setMnemonic(66);
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in KB", new Object[0]));
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeKB");
        rbMenuItem.setMnemonic(75);
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in MB", new Object[0]));
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(77);
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeMB");
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in GB", new Object[0]));
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(77);
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeGB");
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        PopupListener popupListener = new PopupListener(popup);
        this.table.addMouseListener(popupListener);
        this.addMouseListener(popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("setSizeBytes".equals(e.getActionCommand())) {
            if (this.sizeUnit != 1) {
                this.sizeUnit = 1;
                this.tableModel.fireTableDataChanged();
            }
        } else if ("setSizeKB".equals(e.getActionCommand())) {
            if (this.sizeUnit != 2) {
                this.sizeUnit = 2;
                this.tableModel.fireTableDataChanged();
            }
        } else if ("setSizeMB".equals(e.getActionCommand())) {
            if (this.sizeUnit != 3) {
                this.sizeUnit = 3;
                this.tableModel.fireTableDataChanged();
            }
        } else if ("setSizeGB".equals(e.getActionCommand()) && this.sizeUnit != 4) {
            this.sizeUnit = 4;
            this.tableModel.fireTableDataChanged();
        }
    }

    class SharedMemoryStateTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4640295950080357226L;
        private String[] columnNames = new String[]{Resources.getText("Memory Area", new Object[0]), Resources.getText("Size", new Object[0]), Resources.getText("Size (%)", new Object[0]), Resources.getText("Peak Size", new Object[0]), Resources.getText("Peak Size (%)", new Object[0]), Resources.getText("Allocated Size", new Object[0]), Resources.getText("Allocated Size (%)", new Object[0])};
        private List<SharedMemoryStateTableRow> stateData;

        public SharedMemoryStateTableModel() {
            this.fillData(null);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.stateData.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            SharedMemoryStateTableRow rowData = this.stateData.get(row);
            switch (col) {
                case 0: {
                    return rowData.name;
                }
                case 1: {
                    return rowData.size;
                }
                case 2: {
                    return rowData.sizePerCent;
                }
                case 3: {
                    return rowData.sizePeak;
                }
                case 4: {
                    return rowData.sizePeakPerCent;
                }
                case 5: {
                    return rowData.sizeAlloc;
                }
                case 6: {
                    return rowData.sizeAllocPerCent;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public long getSizeAt(int row, int col) {
            SharedMemoryStateTableRow rowData = this.stateData.get(row);
            switch (col) {
                case 1: {
                    return rowData.size;
                }
                case 3: {
                    return rowData.sizePeak;
                }
                case 5: {
                    return rowData.sizeAlloc;
                }
            }
            return -1L;
        }

        public void fillData(MonitoredVm vm) {
            VmMemoryInfo memoryInfo;
            this.stateData = new ArrayList<SharedMemoryStateTableRow>();
            if (vm == null || !vm.getController().isConnected() || vm.getController().isDisabled()) {
                return;
            }
            try {
                memoryInfo = vm.getVmOld().getMemoryInfo();
            }
            catch (InvalidVmException ex) {
                Trace.get(this.getClass()).error((Throwable)ex);
                return;
            }
            long poolSize = memoryInfo.getSharedPoolSize();
            SharedMemoryStateTableRow row = new SharedMemoryStateTableRow();
            row.name = Resources.getText("Shared Data", new Object[0]);
            row.size = memoryInfo.getSharedDataMemoryConsumption();
            row.sizeAlloc = memoryInfo.getSharedDataMemoryAllocation();
            row.sizePeak = memoryInfo.getSharedDataPeakMemoryConsumption();
            row.sizePerCent = poolSize == 0L ? 0.0 : (double)row.size / (double)poolSize * 100.0;
            row.sizeAllocPerCent = poolSize == 0L ? 0.0 : (double)row.sizeAlloc / (double)poolSize * 100.0;
            row.sizePeakPerCent = poolSize == 0L ? 0.0 : (double)row.sizePeak / (double)poolSize * 100.0;
            this.stateData.add(row);
        }
    }

    class SharedMemoryStateTableRow {
        public String name;
        public long size;
        public double sizePerCent;
        public long sizePeak;
        public double sizePeakPerCent;
        public long sizeAlloc;
        public double sizeAllocPerCent;

        SharedMemoryStateTableRow() {
        }
    }

    class SizeRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4508305582797580761L;

        public SizeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Long) {
                switch (SharedMemoryStatePanel.this.sizeUnit) {
                    case 1: {
                        this.setText(Formatter.formatMemBytes((Long)value));
                        break;
                    }
                    case 2: {
                        this.setText(Formatter.formatMemKB((Long)value));
                        break;
                    }
                    case 3: {
                        this.setText(Formatter.formatMemMB((Long)value));
                        break;
                    }
                    case 4: {
                        this.setText(Formatter.formatMemGB((Long)value));
                    }
                }
            }
            if (value instanceof Double) {
                this.setText(Formatter.formatDouble((Double)value));
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

