/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.ConnectableVm;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import com.sap.jvm.tools.monitor.jvmmon.JvmMon;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tools.monitor.jvmmon.gui.IconManager;
import com.sap.jvm.tracing.Trace;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TraceFlagsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6760894666268469022L;
    private static TraceFlagsDialog dialog;
    private TraceFlagsPanel applyPanel;
    private TraceFlagsPanel chooseFromPanel;
    private List<MonitoredVm> vms;

    public static void showDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        dialog = new TraceFlagsDialog(frame, title, vms);
        dialog.setVisible(true);
    }

    private TraceFlagsDialog(JFrame frame, String title, List<MonitoredVm> vms) {
        super(frame, title, true);
        this.vms = vms;
        ArrayList<ConnectableVm.TraceFlagSpec> disabledFlags = new ArrayList<ConnectableVm.TraceFlagSpec>();
        ArrayList<ConnectableVm.TraceFlagSpec> enabledFlags = new ArrayList<ConnectableVm.TraceFlagSpec>();
        ArrayList<VmTraceFlag> allFlags = new ArrayList<VmTraceFlag>();
        ArrayList<VmTraceFlag> appliedFlags = new ArrayList<VmTraceFlag>();
        if (JvmMon.isNew()) {
            Object theFlags;
            try {
                theFlags = vms.get(0).getTraceFlags();
            }
            catch (IOException e) {
                theFlags = new ConnectableVm.TraceFlagSpec[]{};
            }
            for (VmTraceFlag flag : theFlags) {
                if (flag.enabled) {
                    enabledFlags.add((ConnectableVm.TraceFlagSpec)flag);
                    continue;
                }
                disabledFlags.add((ConnectableVm.TraceFlagSpec)flag);
            }
        } else {
            for (VmTraceFlag flag : VmTraceFlag.values()) {
                allFlags.add(flag);
            }
            for (MonitoredVm vm : vms) {
                VmTraceFlagsSet traceFlagsSet = null;
                try {
                    traceFlagsSet = vm.getVmOld().getTraceFlags();
                }
                catch (InvalidVmException ex) {
                    Trace.get(this.getClass()).error((Throwable)ex);
                }
                if (traceFlagsSet == null || traceFlagsSet.getNrOfFlagsSet() <= 0) continue;
                for (VmTraceFlag flag : VmTraceFlag.values()) {
                    if (!traceFlagsSet.isSet(flag)) continue;
                    appliedFlags.add(flag);
                }
            }
            allFlags.removeAll(appliedFlags);
        }
        JPanel tracePanel = new JPanel(new GridBagLayout());
        tracePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.chooseFromPanel = new TraceFlagsPanel(Resources.getText("Choose from...", new Object[0]), disabledFlags, allFlags);
        tracePanel.add((Component)this.chooseFromPanel, c);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        panel.add(Box.createGlue());
        JButton toButton = new JButton(IconManager.RightArrow);
        toButton.setActionCommand("to");
        toButton.addActionListener(this);
        toButton.setAlignmentX(0.5f);
        panel.add(toButton);
        toButton.setAlignmentY(0.5f);
        Box.Filler hFill = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(0, 20));
        panel.add(hFill);
        JButton fromButton = new JButton(IconManager.LeftArrow);
        fromButton.setAlignmentX(0.5f);
        fromButton.setActionCommand("from");
        fromButton.addActionListener(this);
        panel.add(fromButton);
        panel.add(Box.createGlue());
        c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        tracePanel.add((Component)panel, c);
        c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.applyPanel = new TraceFlagsPanel(Resources.getText("Apply...", new Object[0]), enabledFlags, appliedFlags);
        tracePanel.add((Component)this.applyPanel, c);
        JButton okButton = new JButton(Resources.getText("Ok", new Object[0]));
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        JButton applyButton = new JButton(Resources.getText("Apply", new Object[0]));
        applyButton.addActionListener(this);
        applyButton.setActionCommand("Apply");
        JButton cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(okButton);
        buttonPanel.add(applyButton);
        buttonPanel.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)tracePanel, "Center");
        contentPane.add((Component)buttonPanel, "Last");
        this.setLocationRelativeTo(frame);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block20: {
            block21: {
                block19: {
                    if (!"Cancel".equals(e.getActionCommand())) break block19;
                    dialog.setVisible(false);
                    break block20;
                }
                if (!"Ok".equals(e.getActionCommand()) && !"Apply".equals(e.getActionCommand())) break block21;
                if (JvmMon.isNew()) {
                    int[] ids = new int[this.applyPanel.listModel.getSize()];
                    for (int i = 0; i < this.applyPanel.listModel.getSize(); ++i) {
                        ConnectableVm.TraceFlagSpec flag = ((TraceFlagsPanel.TraceElement)((TraceFlagsPanel)this.applyPanel).listModel.getElementAt((int)i)).newTf;
                        ids[i] = flag.id;
                    }
                    for (MonitoredVm vm : this.vms) {
                        try {
                            vm.setTraceFlags(ids);
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    VmTraceFlagsSet traceFlagsSet = new VmTraceFlagsSet();
                    for (int i = 0; i < this.applyPanel.listModel.getSize(); ++i) {
                        VmTraceFlag flagDescription = ((TraceFlagsPanel.TraceElement)((TraceFlagsPanel)this.applyPanel).listModel.getElementAt((int)i)).oldTf;
                        traceFlagsSet.setFlag(flagDescription);
                    }
                    for (MonitoredVm vm : this.vms) {
                        try {
                            vm.getController().getVmOld(vm.getPid()).setTraceFlags(traceFlagsSet);
                        }
                        catch (InvalidVmException ex) {
                            Trace.get(this.getClass()).error((Throwable)ex);
                        }
                    }
                }
                if (!"Ok".equals(e.getActionCommand())) break block20;
                dialog.setVisible(false);
                break block20;
            }
            if ("to".equals(e.getActionCommand())) {
                int i;
                int[] indices = this.chooseFromPanel.getSelectedIndices();
                for (i = 0; i < indices.length; ++i) {
                    this.applyPanel.listModel.add(this.chooseFromPanel.listModel.getElementAt(indices[i]));
                }
                for (i = 0; i < this.applyPanel.listModel.getSize(); ++i) {
                    this.chooseFromPanel.listModel.removeElement(this.applyPanel.listModel.getElementAt(i));
                }
                int newSize = this.chooseFromPanel.listModel.getSize();
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    if (indices[i2] < newSize) continue;
                    this.chooseFromPanel.list.getSelectionModel().removeIndexInterval(indices[i2], indices[i2]);
                }
            } else if ("from".equals(e.getActionCommand())) {
                int i;
                int[] indices = this.applyPanel.getSelectedIndices();
                for (i = 0; i < indices.length; ++i) {
                    this.chooseFromPanel.listModel.add(this.applyPanel.listModel.getElementAt(indices[i]));
                }
                for (i = 0; i < this.chooseFromPanel.listModel.getSize(); ++i) {
                    this.applyPanel.listModel.removeElement(this.chooseFromPanel.listModel.getElementAt(i));
                }
                int newSize = this.applyPanel.listModel.getSize();
                for (int i3 = 0; i3 < indices.length; ++i3) {
                    if (indices[i3] < newSize) continue;
                    this.applyPanel.list.getSelectionModel().removeIndexInterval(indices[i3], indices[i3]);
                }
            }
        }
    }

    public class TraceFlagsPanel
    extends JPanel {
        private static final long serialVersionUID = -2453946184176848008L;
        private static final int PREFERRED_HORIZONTAL_SIZE = 210;
        private static final int PREFERRED_VERTICAL_SIZE = 200;
        private JList<TraceElement> list;
        private SortedListModel<TraceElement> listModel;

        public TraceFlagsPanel(String title, List<ConnectableVm.TraceFlagSpec> data, List<VmTraceFlag> dataOld) {
            super(new GridLayout(1, 0));
            this.listModel = new SortedListModel((o1, o2) -> o1.newTf == null ? o1.oldTf.name().compareTo(o2.oldTf.name()) : o1.newTf.name.compareTo(o2.newTf.name));
            if (JvmMon.isNew()) {
                for (ConnectableVm.TraceFlagSpec spec : data) {
                    this.listModel.add(new TraceElement(spec, null));
                }
            } else {
                for (VmTraceFlag flag : dataOld) {
                    this.listModel.add(new TraceElement(null, flag));
                }
            }
            this.list = new JList<TraceElement>(this.listModel){
                private static final long serialVersionUID = 6553318316690580778L;

                @Override
                public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                    int row;
                    if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
                        Rectangle r = this.getCellBounds(row, row);
                        if (r.y == visibleRect.y && row != 0) {
                            Point loc = r.getLocation();
                            --loc.y;
                            int prevIndex = this.locationToIndex(loc);
                            Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                            if (prevR == null || prevR.y >= r.y) {
                                return 0;
                            }
                            return prevR.height;
                        }
                    }
                    return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
                }

                @Override
                public String getToolTipText(MouseEvent e) {
                    int index = this.locationToIndex(e.getPoint());
                    if (index > -1) {
                        return JvmMon.isNew() ? ((TraceElement)this.getModel().getElementAt((int)index)).newTf.description : ((TraceElement)this.getModel().getElementAt((int)index)).oldTf.getDescription();
                    }
                    return null;
                }
            };
            this.list.setSelectionMode(2);
            this.list.setLayoutOrientation(0);
            this.list.setVisibleRowCount(-1);
            JScrollPane listScroller = new JScrollPane(this.list);
            listScroller.setPreferredSize(new Dimension(210, 200));
            listScroller.setAlignmentX(0.0f);
            this.setLayout(new BoxLayout(this, 3));
            JLabel label = new JLabel(title);
            label.setLabelFor(this.list);
            this.add(label);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(listScroller);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        public int[] getSelectedIndices() {
            return this.list.isSelectionEmpty() ? new int[]{} : this.list.getSelectedIndices();
        }

        class TraceElement {
            ConnectableVm.TraceFlagSpec newTf;
            VmTraceFlag oldTf;

            TraceElement(ConnectableVm.TraceFlagSpec newTf, VmTraceFlag oldTf) {
                this.newTf = newTf;
                this.oldTf = oldTf;
            }
        }
    }

    public class SortedListModel<T>
    extends AbstractListModel<T> {
        private static final long serialVersionUID = -3876982200167103702L;
        TreeSet<T> model;

        public SortedListModel(Comparator<T> comp) {
            this.model = new TreeSet<T>(comp);
        }

        @Override
        public int getSize() {
            return this.model.size();
        }

        @Override
        public T getElementAt(int index) {
            int i;
            Iterator<T> it = this.model.iterator();
            T current = null;
            for (i = 0; it.hasNext() && i < index; ++i) {
                current = it.next();
            }
            return i == index ? current : null;
        }

        public void add(T element) {
            if (this.model.add(element)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(T[] elements) {
            List<T> c = Arrays.asList(elements);
            this.model.addAll(c);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            this.model.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(Object element) {
            return this.model.contains(element);
        }

        public Object firstElement() {
            return this.model.first();
        }

        public Iterator<T> iterator() {
            return this.model.iterator();
        }

        public Object lastElement() {
            return this.model.last();
        }

        public boolean removeElement(Object element) {
            boolean removed = this.model.remove(element);
            if (removed) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return removed;
        }
    }
}

