/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.ConnectableVm;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.Formatter;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tools.monitor.jvmmon.gui.IconManager;
import com.sap.jvm.tools.monitor.jvmmon.gui.SoftSunkenBorder;
import com.sap.jvm.tools.monitor.jvmmon.gui.TableSorter;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmListEventListener;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.pair.IntPair;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class VmDetailPanel
extends JPanel
implements VmListEventListener,
ActionListener {
    private static final long serialVersionUID = 1586284594292581873L;
    private static final int PREFERRED_COLUMN_WIDTH_TRACE_FLAGS = 100;
    private static final int PREFERRED_COLUMN_WIDTH_TRACE_FLAGS_DESCRIPTION = 200;
    private static final int SIZE_UNIT_BYTES = 1;
    private static final int SIZE_UNIT_KB = 2;
    private static final int SIZE_UNIT_MB = 3;
    private static final int SIZE_UNIT_GB = 4;
    private int sizeUnit = 3;
    private LocalVmMemoryModel localVmMemoryTableModel;
    private LocalVmDebuggingModel localVmDebuggingTableModel;
    private LocalVmPerformanceModel localVmPerformanceTableModel;
    private LocalVmTraceFlagsModel localVmTraceFlagsTableModel;
    private TableSorter traceFlagsSorter;
    private MonitoredVm vm;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode vmVersionNode;
    private DefaultMutableTreeNode workingDirectoryNode;
    private DefaultMutableTreeNode vmFlagsNode;
    private DefaultMutableTreeNode javaArgumentsNode;
    private DefaultMutableTreeNode vmArgumentsNode;
    private SizeRenderer sizeRenderer = new SizeRenderer();
    private TimeRenderer timeRenderer = new TimeRenderer();
    private JTable localMemoryTable;
    private JTable localDebuggingTable;
    private JTable localPerformanceTable;

    public VmDetailPanel() {
        super(new GridLayout(1, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        JComponent panelVmInfo = this.createVmInfoPanel();
        tabbedPane.addTab(Resources.getText("VM Information", new Object[0]), IconManager.Info, panelVmInfo, Resources.getText("Displays the local VM information", new Object[0]));
        tabbedPane.setMnemonicAt(0, 49);
        JComponent panelMemory = this.createLocalMemoryPanel();
        tabbedPane.addTab(Resources.getText("Memory", new Object[0]), IconManager.Memory, panelMemory, Resources.getText("Displays the local VM memory settings", new Object[0]));
        tabbedPane.setMnemonicAt(0, 50);
        JComponent panelPerformance = this.createLocalPerformancePanel();
        tabbedPane.addTab(Resources.getText("Performance", new Object[0]), IconManager.Performance, panelPerformance, Resources.getText("Displays the local VM performance settings", new Object[0]));
        tabbedPane.setMnemonicAt(0, 51);
        JComponent panelDebugging = this.createLocalDebuggingPanel();
        tabbedPane.addTab(Resources.getText("Debugging", new Object[0]), IconManager.Debugging, panelDebugging, Resources.getText("Displays the local VM debugging settings", new Object[0]));
        tabbedPane.setMnemonicAt(0, 52);
        JComponent panelTraceFlags = this.createTraceFlagsPanel();
        tabbedPane.addTab(Resources.getText("Trace Flags", new Object[0]), IconManager.Flags, panelTraceFlags, Resources.getText("Displays the local VM trace flags settings", new Object[0]));
        tabbedPane.setMnemonicAt(0, 53);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        TitledBorder title = BorderFactory.createTitledBorder(emptyBorder, Resources.getText("VM Detail", new Object[0]));
        title.setTitlePosition(1);
        tabbedPane.setBorder(title);
        this.add(tabbedPane);
        this.setBorder(new SoftSunkenBorder(false));
    }

    @Override
    public void notify(MonitoredVm vm) {
        this.localVmMemoryTableModel.fillData(vm);
        this.localVmMemoryTableModel.fireTableDataChanged();
        this.localVmDebuggingTableModel.fillData(vm);
        this.localVmDebuggingTableModel.fireTableDataChanged();
        this.localVmPerformanceTableModel.fillData(vm);
        this.localVmPerformanceTableModel.fireTableDataChanged();
        this.localVmTraceFlagsTableModel.fillData(vm);
        this.localVmTraceFlagsTableModel.fireTableDataChanged();
        this.traceFlagsSorter.setSortingStatus(0, 1);
        this.vm = vm;
        this.fillVmInfoData(vm);
        this.treeModel.reload();
    }

    public MonitoredVm getVm() {
        return this.vm;
    }

    public void refresh() {
        this.localVmMemoryTableModel.fillData(this.vm);
        this.localVmMemoryTableModel.fireTableDataChanged();
        this.localVmDebuggingTableModel.fillData(this.vm);
        this.localVmDebuggingTableModel.fireTableDataChanged();
        this.localVmPerformanceTableModel.fillData(this.vm);
        this.localVmPerformanceTableModel.fireTableDataChanged();
        this.localVmPerformanceTableModel.fillData(this.vm);
        this.localVmPerformanceTableModel.fireTableDataChanged();
        this.traceFlagsSorter.setSortingStatus(0, 1);
        this.localVmTraceFlagsTableModel.fillData(this.vm);
        this.localVmTraceFlagsTableModel.fireTableDataChanged();
        this.fillVmInfoData(this.vm);
        this.treeModel.reload();
    }

    protected JComponent createLocalMemoryPanel() {
        this.localVmMemoryTableModel = new LocalVmMemoryModel();
        this.localMemoryTable = new JTable(this.localVmMemoryTableModel){
            private static final long serialVersionUID = -4210676629395191513L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                if (realColumnIndex == 1) {
                    return Formatter.formatMemSimple(VmDetailPanel.this.localVmMemoryTableModel.getSize(rowIndex));
                }
                return null;
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column > 0) {
                    return VmDetailPanel.this.sizeRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.localMemoryTable.setPreferredScrollableViewportSize(new Dimension(60, 50));
        JScrollPane panel = new JScrollPane(this.localMemoryTable);
        Border empty = BorderFactory.createEmptyBorder();
        panel.setBorder(empty);
        this.createContextMenu();
        return panel;
    }

    protected JComponent createLocalDebuggingPanel() {
        this.localVmDebuggingTableModel = new LocalVmDebuggingModel();
        this.localDebuggingTable = new JTable(this.localVmDebuggingTableModel);
        this.localDebuggingTable.setPreferredScrollableViewportSize(new Dimension(60, 50));
        JScrollPane panel = new JScrollPane(this.localDebuggingTable);
        Border empty = BorderFactory.createEmptyBorder();
        panel.setBorder(empty);
        return panel;
    }

    protected JComponent createLocalPerformancePanel() {
        this.localVmPerformanceTableModel = new LocalVmPerformanceModel();
        this.localPerformanceTable = new JTable(this.localVmPerformanceTableModel){
            private static final long serialVersionUID = -3423106599594860299L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                if (rowIndex == 0 && realColumnIndex == 1) {
                    return String.valueOf(VmDetailPanel.this.localVmPerformanceTableModel.getValue(rowIndex)) + " ms";
                }
                return null;
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 1 && (row == 0 || row == 1)) {
                    return VmDetailPanel.this.timeRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.localPerformanceTable.setPreferredScrollableViewportSize(new Dimension(60, 50));
        JScrollPane panel = new JScrollPane(this.localPerformanceTable);
        Border empty = BorderFactory.createEmptyBorder();
        panel.setBorder(empty);
        return panel;
    }

    protected JComponent createTraceFlagsPanel() {
        this.localVmTraceFlagsTableModel = new LocalVmTraceFlagsModel();
        this.traceFlagsSorter = new TableSorter(this.localVmTraceFlagsTableModel);
        JTable table = new JTable(this.traceFlagsSorter);
        this.traceFlagsSorter.setTableHeader(table.getTableHeader());
        table.setPreferredScrollableViewportSize(new Dimension(60, 50));
        TableColumn column = null;
        for (int i = 0; i < this.localVmTraceFlagsTableModel.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            if (i == 2) {
                column.setPreferredWidth(200);
                continue;
            }
            column.setPreferredWidth(100);
        }
        JScrollPane panel = new JScrollPane(table);
        Border empty = BorderFactory.createEmptyBorder();
        panel.setBorder(empty);
        return panel;
    }

    protected JComponent createVmInfoPanel() {
        this.treeModel = new DefaultTreeModel(null);
        this.initVmInfoTree();
        JTree tree = new JTree(this.treeModel);
        tree.setRootVisible(false);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(IconManager.Arguments);
        tree.setCellRenderer(renderer);
        JScrollPane panel = new JScrollPane(tree);
        Border empty = BorderFactory.createEmptyBorder();
        panel.setBorder(empty);
        return panel;
    }

    private void createContextMenu() {
        JPopupMenu popup = new JPopupMenu();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in Bytes", new Object[0]));
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeBytes");
        rbMenuItem.setMnemonic(66);
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in KB", new Object[0]));
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeKB");
        rbMenuItem.setMnemonic(75);
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in MB", new Object[0]));
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(77);
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeMB");
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(Resources.getText("Size in GB", new Object[0]));
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(77);
        rbMenuItem.addActionListener(this);
        rbMenuItem.setActionCommand("setSizeGB");
        group.add(rbMenuItem);
        popup.add(rbMenuItem);
        PopupListener popupListener = new PopupListener(popup);
        this.localMemoryTable.addMouseListener(popupListener);
    }

    private void initVmInfoTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("");
        this.vmVersionNode = new DefaultMutableTreeNode(Resources.getText("VM Version", new Object[0]));
        rootNode.add(this.vmVersionNode);
        this.workingDirectoryNode = new DefaultMutableTreeNode(Resources.getText("Working Directory", new Object[0]));
        rootNode.add(this.workingDirectoryNode);
        this.vmFlagsNode = new DefaultMutableTreeNode(Resources.getText("VM Flags", new Object[0]));
        rootNode.add(this.vmFlagsNode);
        this.vmArgumentsNode = new DefaultMutableTreeNode(Resources.getText("VM Arguments", new Object[0]));
        rootNode.add(this.vmArgumentsNode);
        this.javaArgumentsNode = new DefaultMutableTreeNode(Resources.getText("Java Arguments", new Object[0]));
        rootNode.add(this.javaArgumentsNode);
        this.treeModel.setRoot(rootNode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("setSizeBytes".equals(e.getActionCommand())) {
            if (this.sizeUnit != 1) {
                this.sizeUnit = 1;
                this.localVmMemoryTableModel.fireTableDataChanged();
            }
        } else if ("setSizeKB".equals(e.getActionCommand())) {
            if (this.sizeUnit != 2) {
                this.sizeUnit = 2;
                this.localVmMemoryTableModel.fireTableDataChanged();
            }
        } else if ("setSizeMB".equals(e.getActionCommand())) {
            if (this.sizeUnit != 3) {
                this.sizeUnit = 3;
                this.localVmMemoryTableModel.fireTableDataChanged();
            }
        } else if ("setSizeGB".equals(e.getActionCommand()) && this.sizeUnit != 4) {
            this.sizeUnit = 4;
            this.localVmMemoryTableModel.fireTableDataChanged();
        }
    }

    private void fillVmInfoData(MonitoredVm vm) {
        this.vmVersionNode.removeAllChildren();
        this.workingDirectoryNode.removeAllChildren();
        this.vmFlagsNode.removeAllChildren();
        this.vmArgumentsNode.removeAllChildren();
        this.javaArgumentsNode.removeAllChildren();
        if (vm == null) {
            this.treeModel.setRoot(null);
            return;
        }
        if (!vm.isAlive()) {
            return;
        }
        if (this.treeModel.getRoot() == null) {
            this.initVmInfoTree();
        }
        BoardWrapper board = vm.getBoard();
        String vmVersion = board.getVmVersion();
        String workingDir = board.getWorkingDirectory();
        String[] vmFlags = board.getVmFlags();
        String[] vmArgs = board.getVmArguments();
        String mainClass = board.getMainClass();
        String[] javaArgs = board.getJavaArguments();
        if (vmVersion == null) {
            vmVersion = Resources.getText("<undefined>", new Object[0]);
        }
        DefaultMutableTreeNode vmNode = new DefaultMutableTreeNode(vmVersion);
        this.vmVersionNode.add(vmNode);
        if (workingDir == null) {
            workingDir = Resources.getText("<undefined>", new Object[0]);
        }
        DefaultMutableTreeNode workingDirNode = new DefaultMutableTreeNode(workingDir);
        this.workingDirectoryNode.add(workingDirNode);
        if (vmFlags != null && vmFlags.length > 0) {
            for (String flag : vmFlags) {
                DefaultMutableTreeNode flagNode = new DefaultMutableTreeNode(flag);
                this.vmFlagsNode.add(flagNode);
            }
        } else {
            String[] flagNode = new DefaultMutableTreeNode(Resources.getText("<not specified>", new Object[0]));
            this.vmFlagsNode.add((MutableTreeNode)flagNode);
        }
        if (vmArgs != null && vmArgs.length > 0) {
            for (String arg : vmArgs) {
                DefaultMutableTreeNode vmArgNode = new DefaultMutableTreeNode(arg);
                this.vmArgumentsNode.add(vmArgNode);
            }
        } else {
            DefaultMutableTreeNode vmArgNode = new DefaultMutableTreeNode(Resources.getText("<not specified>", new Object[0]));
            this.vmArgumentsNode.add(vmArgNode);
        }
        if (mainClass == null) {
            mainClass = Resources.getText("<undefined>", new Object[0]);
        }
        if (vm.getBoard().getJarFileName() != null) {
            mainClass = mainClass + " [from " + vm.getBoard().getJarFileName() + "]";
        }
        DefaultMutableTreeNode javaArgNode = new DefaultMutableTreeNode(mainClass);
        this.javaArgumentsNode.add(javaArgNode);
        if (javaArgs != null) {
            for (String arg : javaArgs) {
                javaArgNode = new DefaultMutableTreeNode(arg);
                this.javaArgumentsNode.add(javaArgNode);
            }
        }
    }

    class LocalVmTraceFlagsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6855224791362707308L;
        private String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Description", new Object[0])};
        private List<LocalVmTraceFlagsRow> localVmTraceFlagsData = new ArrayList<LocalVmTraceFlagsRow>();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.localVmTraceFlagsData.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            LocalVmTraceFlagsRow rowData = this.localVmTraceFlagsData.get(row);
            switch (col) {
                case 0: {
                    return rowData.flagName;
                }
                case 1: {
                    return rowData.flagDescription;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public void fillData(MonitoredVm vm) {
            this.localVmTraceFlagsData = new ArrayList<LocalVmTraceFlagsRow>();
            if (vm == null || !vm.isAlive()) {
                return;
            }
            try {
                ConnectableVm.TraceFlagSpec[] flags;
                for (ConnectableVm.TraceFlagSpec flag : flags = vm.getTraceFlags()) {
                    if (!flag.enabled) continue;
                    LocalVmTraceFlagsRow row = new LocalVmTraceFlagsRow();
                    row.id = flag.id;
                    row.flagName = flag.name;
                    row.flagDescription = flag.description;
                    this.localVmTraceFlagsData.add(row);
                }
            }
            catch (IOException ex) {
                Trace.get(this.getClass()).error((Throwable)ex);
            }
            if (this.localVmTraceFlagsData.isEmpty()) {
                LocalVmTraceFlagsRow row = new LocalVmTraceFlagsRow();
                row.id = -1;
                row.flagName = "";
                row.flagDescription = Resources.getText("No trace flags set.", new Object[0]);
                this.localVmTraceFlagsData.add(row);
            }
        }
    }

    class LocalVmTraceFlagsRow {
        public int id;
        public String flagName;
        public String flagDescription;

        LocalVmTraceFlagsRow() {
        }
    }

    class LocalVmPerformanceModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3165382072941240573L;
        private String[] columnNames = new String[]{Resources.getText("Parameter", new Object[0]), Resources.getText("Value", new Object[0])};
        private List<LocalVmPerformanceRow> localVmPerformanceData = new ArrayList<LocalVmPerformanceRow>();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.localVmPerformanceData.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            LocalVmPerformanceRow rowData = this.localVmPerformanceData.get(row);
            switch (col) {
                case 0: {
                    return rowData.parameter;
                }
                case 1: {
                    return rowData.value;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 1) {
                return Integer.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        public long getValue(int row) {
            return this.localVmPerformanceData.get((int)row).value;
        }

        public void fillData(MonitoredVm vm) {
            this.localVmPerformanceData = new ArrayList<LocalVmPerformanceRow>();
            if (vm == null || !vm.isAlive()) {
                return;
            }
            BoardWrapper board = vm.getBoard();
            LocalVmPerformanceRow row = new LocalVmPerformanceRow();
            row.parameter = Resources.getText("CPU time", new Object[0]);
            row.value = board.getCpuTime() / 1000L;
            this.localVmPerformanceData.add(row);
            row = new LocalVmPerformanceRow();
            row.parameter = Resources.getText("Elapsed time", new Object[0]);
            row.value = board.getElapsedTime() / 1000L;
            this.localVmPerformanceData.add(row);
            row = new LocalVmPerformanceRow();
            row.parameter = Resources.getText("Number of GCs", new Object[0]);
            row.value = board.getNrOfGcs();
            this.localVmPerformanceData.add(row);
            row = new LocalVmPerformanceRow();
            row.parameter = Resources.getText("Number of full GCs", new Object[0]);
            row.value = board.getNrOfFullGcs();
            this.localVmPerformanceData.add(row);
        }
    }

    class LocalVmPerformanceRow {
        public String parameter;
        public long value;

        LocalVmPerformanceRow() {
        }
    }

    class TimeRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -6903025377955613643L;

        public TimeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Long) {
                long timeInMs = (Long)value;
                if (timeInMs == -1L) {
                    this.setText(Resources.getText("<undefined>", new Object[0]));
                    return;
                }
                this.setText(Formatter.formatTimeMsInElements(timeInMs));
            }
        }
    }

    class LocalVmDebuggingModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7688873725607549134L;
        private String[] columnNames = new String[]{Resources.getText("Parameter", new Object[0]), Resources.getText("Value", new Object[0])};
        private List<LocalVmDebuggingRow> localVmDebuggingData = new ArrayList<LocalVmDebuggingRow>();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.localVmDebuggingData.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            LocalVmDebuggingRow rowData = this.localVmDebuggingData.get(row);
            switch (col) {
                case 0: {
                    return rowData.parameter;
                }
                case 1: {
                    return rowData.value;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 1) {
                return Integer.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        public void fillData(MonitoredVm vm) {
            this.localVmDebuggingData = new ArrayList<LocalVmDebuggingRow>();
            if (vm == null || !vm.isAlive()) {
                return;
            }
            BoardWrapper board = vm.getBoard();
            LocalVmDebuggingRow row = new LocalVmDebuggingRow();
            row.parameter = Resources.getText("Debugging on demand support", new Object[0]);
            row.value = board.isDebuggingOnDemandEnabled() ? Resources.getText("enabled", new Object[0]) : Resources.getText("disabled", new Object[0]);
            this.localVmDebuggingData.add(row);
            row = new LocalVmDebuggingRow();
            row.parameter = Resources.getText("Default debugging port range", new Object[0]);
            IntPair portRange = board.getDefaultDebuggingPortRange();
            row.value = portRange.getFirst() == -1 ? Resources.getText("<undefined>", new Object[0]) : "[" + portRange.getFirst() + "-" + portRange.getSecond() + "]";
            this.localVmDebuggingData.add(row);
            row = new LocalVmDebuggingRow();
            row.parameter = Resources.getText("Debugging state", new Object[0]);
            row.value = board.getDebugOnDemandState().getDescription();
            this.localVmDebuggingData.add(row);
            row = new LocalVmDebuggingRow();
            row.parameter = Resources.getText("Current debugging port", new Object[0]);
            row.value = board.getDebugPort() > 0 ? "" + board.getDebugPort() : Resources.getText("<not started>", new Object[0]);
            this.localVmDebuggingData.add(row);
            row = new LocalVmDebuggingRow();
            row.parameter = Resources.getText("Debugging Client", new Object[0]);
            row.value = board.getDebugClient();
            this.localVmDebuggingData.add(row);
            row = new LocalVmDebuggingRow();
            row.parameter = Resources.getText("Debugging Accessibility", new Object[0]);
            row.value = board.isDebugLocalOnly() ? Resources.getText("Only locally", new Object[0]) : Resources.getText("Globally", new Object[0]);
            this.localVmDebuggingData.add(row);
        }
    }

    class LocalVmDebuggingRow {
        public String parameter;
        public String value;

        LocalVmDebuggingRow() {
        }
    }

    class LocalVmMemoryModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8765320449120067370L;
        private String[] columnNames = new String[]{Resources.getText("Memory Area", new Object[0]), Resources.getText("Size", new Object[0])};
        private List<LocalVmMemoryRow> localVmMemoryData = new ArrayList<LocalVmMemoryRow>();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.localVmMemoryData.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            LocalVmMemoryRow rowData = this.localVmMemoryData.get(row);
            switch (col) {
                case 0: {
                    return rowData.memoryArea;
                }
                case 1: {
                    return rowData.size;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 1) {
                return Integer.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        public long getSize(int row) {
            return this.localVmMemoryData.get((int)row).size;
        }

        public void fillData(MonitoredVm vm) {
            this.localVmMemoryData = new ArrayList<LocalVmMemoryRow>();
            if (vm == null || !vm.isAlive()) {
                return;
            }
            BoardWrapper board = vm.getBoard();
            boolean hasMetaspace = board.getBoolean("USES_METASPACE", false);
            LocalVmMemoryRow row = new LocalVmMemoryRow();
            row.memoryArea = Resources.getText("Committed Java Heap", new Object[0]);
            row.size = board.getCommittedHeapSizeAfterLastGc();
            this.localVmMemoryData.add(row);
            row = new LocalVmMemoryRow();
            row.memoryArea = Resources.getText(hasMetaspace ? "Committed Metaspace" : "Committed Class Pool", new Object[0]);
            row.size = board.getCommittedPermSizeAfterLastGc();
            this.localVmMemoryData.add(row);
            row = new LocalVmMemoryRow();
            row.memoryArea = Resources.getText("Committed Code Cache", new Object[0]);
            row.size = board.getCommittedCodeCacheSize();
            this.localVmMemoryData.add(row);
            boolean hasCompressedClassPointers = board.getBoolean("USES_COMPRESSED_CLASS_POINTERS", false);
            if (hasMetaspace && hasCompressedClassPointers) {
                row = new LocalVmMemoryRow();
                row.memoryArea = Resources.getText("Compressed class space maximum size", new Object[0]);
                row.size = board.getCompressedClassSpaceSize();
                this.localVmMemoryData.add(row);
                row = new LocalVmMemoryRow();
                row.memoryArea = Resources.getText("Compressed class space committed size", new Object[0]);
                row.size = board.getCompressedClassSpaceCommitted();
                this.localVmMemoryData.add(row);
                row = new LocalVmMemoryRow();
                row.memoryArea = Resources.getText("Compressed class space used size", new Object[0]);
                row.size = board.getCompressedClassSpaceUsed();
                this.localVmMemoryData.add(row);
            }
        }
    }

    class LocalVmMemoryRow {
        public String memoryArea;
        public long size;

        LocalVmMemoryRow() {
        }
    }

    class SizeRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -860949190232893726L;

        public SizeRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Long) {
                long size = (Long)value;
                if (size == -1L) {
                    this.setText(Resources.getText("<undefined>", new Object[0]));
                    return;
                }
                switch (VmDetailPanel.this.sizeUnit) {
                    case 1: {
                        this.setText(Formatter.formatMemBytes(size));
                        break;
                    }
                    case 2: {
                        this.setText(Formatter.formatMemKB(size));
                        break;
                    }
                    case 3: {
                        this.setText(Formatter.formatMemMB(size));
                        break;
                    }
                    case 4: {
                        this.setText(Formatter.formatMemGB(size));
                    }
                }
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

