/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.internals.VmInternals;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tools.monitor.jvmmon.gui.SoftSunkenBorder;
import com.sap.jvm.tools.monitor.jvmmon.gui.TableSorter;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmListEventListener;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class VmListPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_INITIAL_SIZE = 150;
    private static final int VERTICAL_INITIAL_SIZE = 400;
    private int myProcessId;
    private List<VmListEventListener> listeners;
    private VmListTableModel tableModel;
    private JTable table;
    private TableSorter tableSorter;
    private List<MonitoringController> connectionList;

    public VmListPanel(List<MonitoringController> connectionList) {
        super(new GridLayout(1, 0));
        this.connectionList = connectionList;
        this.listeners = new ArrayList<VmListEventListener>();
        this.myProcessId = InspectorInfo.getOwnProcessId();
        this.tableModel = new VmListTableModel();
        this.tableSorter = new TableSorter(this.tableModel);
        this.table = new JTable(this.tableSorter);
        this.tableSorter.setTableHeader(this.table.getTableHeader());
        this.table.setPreferredScrollableViewportSize(new Dimension(150, 400));
        this.tableSorter.setSortingStatus(0, 1);
        this.tableSorter.setSortingStatus(1, 1);
        for (int col = 0; col < this.tableModel.getColumnCount(); ++col) {
            TableColumn column = this.table.getColumnModel().getColumn(col);
            column.setPreferredWidth(this.tableModel.getColumnSize(col));
            TableCellRenderer cellRenderer = this.tableSorter.createCellRenderer(this.table.getCellRenderer(0, col));
            column.setCellRenderer(cellRenderer);
        }
        JScrollPane tablePanel = new JScrollPane(this.table);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(this);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        TitledBorder title = BorderFactory.createTitledBorder(emptyBorder, Resources.getText("VM List", new Object[0]));
        title.setTitlePosition(1);
        tablePanel.setBorder(title);
        this.add(tablePanel);
        this.setBorder(new SoftSunkenBorder(true));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            return;
        }
        int selectedRow = lsm.getMinSelectionIndex();
        int modelIndex = this.tableSorter.modelIndex(selectedRow);
        MonitoredVm rowData = this.tableModel.getRowData(modelIndex);
        for (VmListEventListener listener : this.listeners) {
            listener.notify(rowData);
        }
    }

    public void setSelectedRow(int index) {
        if (index > this.table.getRowCount() - 1) {
            for (VmListEventListener listener : this.listeners) {
                listener.notify(null);
            }
            return;
        }
        this.table.getSelectionModel().setSelectionInterval(index, index);
    }

    public synchronized void refreshData(MonitoredVm vmToRefresh, boolean force) {
        if (!force && this.tableModel.equals(new VmListTableModel())) {
            return;
        }
        List<MonitoredVm> vms = this.getSelectedRows();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.clearSelection();
        this.tableModel.fillData();
        this.tableModel.fireTableDataChanged();
        int modelRowIndex = this.tableModel.getRowIndexForVm(vmToRefresh);
        int rowIndex = modelRowIndex == -1 ? 0 : this.getRowIndex(vmToRefresh);
        this.setSelectedRow(rowIndex);
        if (vms == null) {
            return;
        }
        for (MonitoredVm vm : vms) {
            if (vm.equals((Object)vmToRefresh) || (rowIndex = this.getRowIndex(vm)) == -1) continue;
            selectionModel.addSelectionInterval(rowIndex, rowIndex);
        }
    }

    public List<MonitoredVm> getSelectedRows() {
        ArrayList<MonitoredVm> retValue = new ArrayList<MonitoredVm>();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int minIndex = listSelectionModel.getMinSelectionIndex();
        int maxIndex = listSelectionModel.getMaxSelectionIndex();
        for (int i = minIndex; i <= maxIndex; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            retValue.add(this.tableModel.getRowData(this.tableSorter.modelIndex(i)));
        }
        return retValue;
    }

    public void addVmListEventListener(VmListEventListener listener) {
        this.listeners.add(listener);
    }

    private int getRowIndex(MonitoredVm vmDescription) {
        int rowCount = this.tableSorter.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int modelIndex = this.tableSorter.modelIndex(i);
            MonitoredVm description = this.tableModel.getRowData(modelIndex);
            if (!description.equals((Object)vmDescription)) continue;
            return i;
        }
        return -1;
    }

    class VmListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8185872857842963903L;
        private String[] columnNames = new String[]{Resources.getText("Hostname", new Object[0]), Resources.getText("Instance", new Object[0]), Resources.getText("VmID", new Object[0]), Resources.getText("PID", new Object[0]), Resources.getText("CPU[ms]", new Object[0]), Resources.getText("VmTag", new Object[0]), Resources.getText("Java Arguments", new Object[0]), Resources.getText("Working Directory", new Object[0])};
        private int[] columnSizes = new int[]{90, 90, 60, 50, 70, 100, 200, 200};
        private List<MonitoredVm> vms;

        public VmListTableModel() {
            this.fillData();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.vms.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnSize(int col) {
            return this.columnSizes[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            MonitoredVm vm = this.vms.get(row);
            if (!vm.isAlive()) {
                return null;
            }
            BoardWrapper board = vm.getBoard();
            int instanceNr = board.getInstanceNr();
            switch (col) {
                case 0: {
                    return vm.getHost();
                }
                case 1: {
                    if (instanceNr == -1) {
                        return "";
                    }
                    return instanceNr;
                }
                case 2: {
                    if (instanceNr == -1) {
                        return "";
                    }
                    return board.getClusterIndex();
                }
                case 3: {
                    return board.getPid();
                }
                case 4: {
                    return board.getCpuTime() / 1000L;
                }
                case 5: {
                    return board.getVmTag();
                }
                case 6: {
                    String jarFileName = board.getJarFileName();
                    if (jarFileName == null) {
                        return board.getJavaArgumentLine();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("-jar ");
                    sb.append(board.getJarFileName());
                    sb.append("[main class: ");
                    sb.append(board.getMainClass());
                    sb.append("]");
                    for (String arg : board.getJavaArguments()) {
                        sb.append(" ");
                        sb.append(arg);
                    }
                    return sb.toString();
                }
                case 7: {
                    return board.getWorkingDirectory();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 5: 
                case 6: {
                    return String.class;
                }
                case 7: {
                    return String.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return Integer.class;
                }
            }
            return Integer.class;
        }

        public MonitoredVm getRowData(int row) {
            if (this.vms == null) {
                return null;
            }
            return this.vms.get(row);
        }

        public int getRowIndexForVm(MonitoredVm vmDescription) {
            if (this.vms == null || vmDescription == null) {
                return -1;
            }
            int rowIndex = -1;
            for (MonitoredVm vm : this.vms) {
                ++rowIndex;
                if (!vm.equals((Object)vmDescription)) continue;
                return rowIndex;
            }
            return -1;
        }

        public synchronized void fillData() {
            ArrayList<MonitoredVm> newVmListData = new ArrayList<MonitoredVm>();
            HashSet<VmId> vmIdSet = new HashSet<VmId>();
            if (this.vms != null) {
                for (MonitoredVm vm : this.vms) {
                    if (!vm.isAlive()) continue;
                    newVmListData.add(vm);
                    vmIdSet.add(new VmId(vm));
                }
            }
            for (MonitoringController controller : VmListPanel.this.connectionList) {
                for (MonitoredVm vm : controller.getAllMonitoredVms(true)) {
                    VmId vmId = new VmId(vm);
                    if (vmIdSet.contains(vmId) || controller.isLocal() && vm.getBoard().getPid() == VmListPanel.this.myProcessId) continue;
                    newVmListData.add(vm);
                    vmIdSet.add(vmId);
                }
            }
            for (MonitoredVm vm : new ArrayList(newVmListData)) {
                if (vm.isAlive()) continue;
                newVmListData.remove(vm);
                vmIdSet.remove(new VmId(vm));
            }
            this.vms = newVmListData;
        }

        private Collection<VmId> getVMIds() {
            HashSet<VmId> result = null;
            if (this.vms != null) {
                result = new HashSet<VmId>();
                for (MonitoredVm vmDesc : this.vms) {
                    result.add(new VmId(vmDesc));
                }
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            VmListTableModel objTableModel = (VmListTableModel)obj;
            if (objTableModel.getRowCount() == this.getRowCount()) {
                return this.getVMIds().containsAll(objTableModel.getVMIds());
            }
            return false;
        }

        public int hashCode() {
            return this.getRowCount() ^ this.getVMIds().hashCode();
        }

        class VmInternal_EMPTY
        implements VmInternals {
            private Properties props = new Properties();

            VmInternal_EMPTY() {
            }

            public Properties getVirtualizationInfo() {
                return this.props;
            }
        }

        class VmId {
            public String hostname;
            public int pid;

            public VmId(MonitoredVm vm) {
                this.hostname = vm.getHost();
                this.pid = vm.getBoard().getPid();
            }

            public VmId(String hostname, int pid) {
                this.hostname = hostname;
                this.pid = pid;
            }

            public int hashCode() {
                return this.pid;
            }

            public boolean equals(Object obj) {
                if (obj == null || !obj.getClass().equals(this.getClass())) {
                    return false;
                }
                VmId tmp = (VmId)obj;
                if (this.pid != tmp.pid) {
                    return false;
                }
                return this.hostname == null ? tmp.hostname == null : this.hostname.equals(tmp.hostname);
            }
        }
    }
}

