/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.tools.monitor.jvmmon.gui.JvmMonGui;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmDetailPanel;
import com.sap.jvm.tools.monitor.jvmmon.gui.VmListPanel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class VmPanel
extends JPanel {
    private static final long serialVersionUID = -2180461809740683633L;
    private static final int DIVIDER_LOCATION = 570;
    private static final int DIVIDER_SIZE = 10;
    private JSplitPane splitPane;
    private VmListPanel vmListPanel;
    private VmDetailPanel vmDetailPanel;

    public VmPanel(List<MonitoringController> connectionList) {
        super(new GridLayout(1, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.vmListPanel = new VmListPanel(connectionList);
        this.vmDetailPanel = new VmDetailPanel();
        this.vmListPanel.addVmListEventListener(this.vmDetailPanel);
        this.splitPane = new JSplitPane(1, this.vmListPanel, this.vmDetailPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(570);
        this.splitPane.setDividerSize(10);
        JvmMonGui.flattenSplitPane(this.splitPane);
        Dimension minimumSize = new Dimension(100, 50);
        this.vmListPanel.setMinimumSize(minimumSize);
        this.vmDetailPanel.setMinimumSize(minimumSize);
        this.splitPane.setPreferredSize(new Dimension(400, 200));
        this.add(this.splitPane);
    }

    public void refreshData() {
        this.vmListPanel.refreshData(this.vmDetailPanel.getVm(), true);
    }

    public void refreshDataIfNecessary() {
        this.vmListPanel.refreshData(this.vmDetailPanel.getVm(), false);
    }

    public VmListPanel getVmListPanel() {
        return this.vmListPanel;
    }

    public VmDetailPanel getVmDetailPanel() {
        return this.vmDetailPanel;
    }
}

