/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.tools.monitor.jvmmon.Resources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class VmPrintOutputPanel
extends JPanel {
    private static final long serialVersionUID = -1749783612880590626L;
    private static final String COM_SAP_JVMMONGUI_MAXTEXTSIZE = "com.sap.jvmmongui.maximumtextsize";
    private static final int MAX_TEXT_LEN = Integer.getInteger("com.sap.jvmmongui.maximumtextsize", 3000000);
    private static final String JVMMON_OUTPUT_TRUNCATED_FORMAT = "jvmmon: output of %d bytes truncated to %d ....\n        could be extended using -Dcom.sap.jvmmongui.maximumtextsize=<new size>\n\n";
    private static final Document BLANK = new DefaultStyledDocument();
    private JToolBar outputToolBar;
    private JTextPane textOutput;
    private String searchPattern = null;
    private int currentSearchIndex = -1;
    private List<TextPart> searchPositions = new ArrayList<TextPart>();
    private SimpleAttributeSet highlightAttr = new SimpleAttributeSet();

    public VmPrintOutputPanel(JToolBar toolbar) {
        super(new BorderLayout());
        this.setLocale(Locale.US);
        this.outputToolBar = toolbar;
        this.textOutput = new JTextPane();
        this.textOutput.setPreferredSize(new Dimension(100, 100));
        this.textOutput.setEditable(false);
        this.textOutput.setCaretPosition(0);
        this.textOutput.setMargin(new Insets(5, 5, 5, 5));
        this.textOutput.getCaret().setSelectionVisible(true);
        this.textOutput.getCaret().setVisible(true);
        this.textOutput.setFont(new Font("Monospaced", this.textOutput.getFont().getStyle(), this.textOutput.getFont().getSize()));
        this.textOutput.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane paneScrollPane = new JScrollPane(this.textOutput);
        paneScrollPane.setVerticalScrollBarPolicy(20);
        paneScrollPane.setHorizontalScrollBarPolicy(30);
        paneScrollPane.setMinimumSize(new Dimension(10, 10));
        this.add((Component)this.outputToolBar, "North");
        this.add(paneScrollPane);
        StyleConstants.setBold(this.highlightAttr, true);
        StyleConstants.setForeground(this.highlightAttr, Color.red);
        StyleConstants.setBackground(this.highlightAttr, Color.yellow);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String outText) {
        boolean truncated = false;
        String text = outText;
        int length = text.length();
        if (MAX_TEXT_LEN > 0 && length > MAX_TEXT_LEN) {
            text = outText.substring(length - MAX_TEXT_LEN, length);
            truncated = true;
        }
        Document doc = this.textOutput.getDocument();
        this.textOutput.setDocument(BLANK);
        try {
            if (this.searchPattern == null) {
                doc.insertString(doc.getLength(), text + "\n", null);
            } else {
                List<TextPart> textSearchParts = this.calculateSearchParts(text, Pattern.quote(this.searchPattern));
                int docPosOffset = doc.getLength();
                int lastEndPos = 0;
                for (TextPart part : textSearchParts) {
                    int start = part.startPos;
                    int end = part.endPos;
                    if (start > lastEndPos) {
                        String regularPart = text.substring(lastEndPos, start);
                        doc.insertString(doc.getLength(), regularPart, null);
                    }
                    if (end > start) {
                        String matchPart = text.substring(start, end);
                        doc.insertString(doc.getLength(), matchPart, this.highlightAttr);
                        this.searchPositions.add(new TextPart(start + docPosOffset, end + docPosOffset));
                    }
                    lastEndPos = end;
                }
                if (lastEndPos < text.length()) {
                    String regularPart = text.substring(lastEndPos);
                    doc.insertString(doc.getLength(), regularPart, null);
                }
                if (this.currentSearchIndex < 0 && !textSearchParts.isEmpty()) {
                    this.currentSearchIndex = 0;
                }
            }
            if (MAX_TEXT_LEN > 0 && doc.getLength() > MAX_TEXT_LEN) {
                int oversize = doc.getLength() - MAX_TEXT_LEN;
                doc.remove(0, oversize);
                truncated = true;
            }
            if (truncated) {
                doc.insertString(0, String.format(JVMMON_OUTPUT_TRUNCATED_FORMAT, length, MAX_TEXT_LEN), null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            this.textOutput.setDocument(doc);
            this.textOutput.select(doc.getLength(), doc.getLength());
            this.textOutput.getCaret().setVisible(true);
            this.textOutput.requestFocus();
        }
    }

    private List<TextPart> calculateSearchParts(String text, String patternStr) {
        Pattern pattern;
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        try {
            pattern = Pattern.compile(patternStr, 2);
        }
        catch (Exception e) {
            return parts;
        }
        Matcher matcher = pattern.matcher(text);
        int lastMatchEnd = 0;
        while (matcher.find(lastMatchEnd)) {
            int currentMatch = matcher.start();
            if (currentMatch < lastMatchEnd) continue;
            lastMatchEnd = matcher.end();
            parts.add(new TextPart(currentMatch, lastMatchEnd));
        }
        return parts;
    }

    public void clear() {
        Document doc = this.textOutput.getDocument();
        try {
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.currentSearchIndex = -1;
        this.searchPattern = null;
        this.searchPositions.clear();
    }

    public void setSearchPattern(String searchPattern) {
        boolean updateNeeded = searchPattern == null && this.searchPattern != null;
        updateNeeded = updateNeeded || this.searchPattern == null;
        boolean bl = updateNeeded = updateNeeded || !searchPattern.equals(this.searchPattern);
        if (updateNeeded) {
            Document doc = this.textOutput.getDocument();
            try {
                String oldText = doc.getText(0, doc.getLength());
                this.clear();
                this.searchPattern = searchPattern;
                this.print(oldText);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.focusCurrentSearchPos();
    }

    public boolean hasSearchPos() {
        return this.currentSearchIndex >= 0;
    }

    public void focusCurrentSearchPos() {
        if (this.currentSearchIndex == -1) {
            this.textOutput.getCaret().setSelectionVisible(false);
            this.textOutput.getCaret().setVisible(false);
            return;
        }
        TextPart currentMatch = this.searchPositions.get(this.currentSearchIndex);
        try {
            this.textOutput.getCaret().setSelectionVisible(true);
            this.textOutput.getCaret().setVisible(true);
            this.textOutput.select(currentMatch.startPos, currentMatch.endPos);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public boolean hasNextSearchPos() {
        return this.hasSearchPos() && this.currentSearchIndex + 1 < this.searchPositions.size();
    }

    public void nextSearchPos() {
        if (this.hasNextSearchPos()) {
            ++this.currentSearchIndex;
            this.focusCurrentSearchPos();
        }
    }

    public boolean hasPreviousSearchPos() {
        return this.currentSearchIndex > 0;
    }

    public void previousSearchPos() {
        if (this.hasPreviousSearchPos()) {
            --this.currentSearchIndex;
            this.focusCurrentSearchPos();
        }
    }

    public void write(File file) {
        boolean append = false;
        if (file.exists()) {
            int result = JOptionPane.showConfirmDialog(this, "File " + file.getName() + " " + Resources.getText("is already existing. Should the file be appended?", new Object[0]), Resources.getText("Question", new Object[0]), 1);
            if (result == 0) {
                append = true;
            } else if (result == 2) {
                return;
            }
        }
        try {
            FileWriter fw = new FileWriter(file, append);
            this.textOutput.write(fw);
            fw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Resources.getText("Saving print output failed for following reason:", new Object[0]) + " " + e.getMessage(), Resources.getText("Not saved", new Object[0]), 2);
        }
    }

    public JTextPane getTextOutput() {
        return this.textOutput;
    }

    private final class TextPart {
        int startPos = 0;
        int endPos = -1;

        TextPart(int start, int end) {
            this.startPos = start;
            this.endPos = end;
        }
    }
}

