/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmond;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.monitor.vm.ErrorQueue;
import com.sap.jvm.monitor.vm.ErrorQueueEntry;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.tools.monitor.jvmmond.NewServer;
import com.sap.jvm.tools.monitor.jvmmond.RMIServer;
import com.sap.jvm.util.misc.ToolsHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.concurrent.CountDownLatch;

public class JvmMonD {
    private static final int NUM_XOR_CHARS = 32;
    private static CountDownLatch stopSignal = new CountDownLatch(1);
    private static volatile int rc = 0;

    private static void notifyStop(int ret) {
        rc = ret;
        stopSignal.countDown();
    }

    private static void awaitStop() {
        boolean isStopped = false;
        while (!isStopped) {
            try {
                stopSignal.await();
                isStopped = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void startConsoleReader() {
        System.out.println("Press 'q' + enter to stop server.");
        new Thread(() -> {
            int c;
            Thread.currentThread().setName("ConsoleReader");
            do {
                try {
                    c = System.in.read();
                }
                catch (IOException e) {
                    System.err.println("Caught IOException while reading from console" + e.getMessage());
                    c = -1;
                }
                if (c != 113) continue;
                JvmMonD.notifyStop(0);
                break;
            } while (c != -1);
        }).start();
    }

    private static void startErrorQueueReader() {
        new Thread(() -> {
            Thread.currentThread().setName("ErrorQueueReader");
            ErrorQueue eq = ErrorQueue.getErrorQueue();
            while (true) {
                try {
                    while (true) {
                        ErrorQueueEntry entry;
                        if ((entry = eq.remove()) == null) {
                            continue;
                        }
                        Throwable t = entry.getError();
                        if (t != null) {
                            System.err.println("jvmmond exiting with exception: " + t.getMessage());
                            t.printStackTrace();
                            JvmMonD.notifyStop(2);
                        }
                        System.err.println("jvmmond exiting with error queue entry " + entry);
                        JvmMonD.notifyStop(3);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }).start();
    }

    private static boolean isStrongPassword(String password) {
        boolean isStrong = false;
        if (password.length() >= 8) {
            boolean containsUpperCase = false;
            boolean containsLowerCase = false;
            boolean containsDigit = false;
            for (int i = 0; i < password.length() && !isStrong; ++i) {
                char c = password.charAt(i);
                isStrong = (containsDigit |= Character.isDigit(c)) & (containsUpperCase |= Character.isUpperCase(c)) & (containsLowerCase |= Character.isLowerCase(c));
            }
        }
        return isStrong;
    }

    private static String usage() {
        return "Usage: jvmmond [options]\n\n where options include:\n    --help|-h|-?\n            Print this help text.\n    --port|-p port\n            The port on which the jvmmond service listens. The default is 1099.\n    --port-range|-r <fromPort>[-<toPort>]\n            The port range in which the RMI server will open ports.\n            If you set this option and don't specify a server port with -p,\n            then the server port will be within that range. It will be logged to stdout.\n    --protocol <rmi|jvmmond|mixed>\n            The mode in which jvmmond is run. The current default is \"mixed\", which means\n            an RMI server is started (for old type connectivity) and a server handling the\n            new packet based monitoring protocol is active. Specifying \"rmi\" will activate\n            RMI only, \"jvmmond\" will activate the packet based protocol.\n    --password:<stdin/stdout>\n            This option activates password protection. If you use 'stdout', a password\n            is generated and printed to stdout in Hex representation. 'stdin' will give\n            you the possibility to type an own password.\n    --verbose\n            Enables verbose tracing of jvmmond operation.\n    --trace-file <trace file>\n            Directs tracing of jvmmond operation to trace file.\n";
    }

    public static void main(String[] args) {
        int port = 0;
        boolean useJvmmondProtocol = true;
        boolean useRMI = true;
        String password = null;
        boolean passwordStdOut = false;
        boolean passwordStdIn = false;
        boolean verbose = false;
        String portRangeStr = null;
        String traceFileName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("-?") || args[i].equals("--help")) {
                System.out.println(JvmMonD.usage());
                System.exit(0);
                continue;
            }
            if (args[i].equals("-p") || args[i].equals("--port") || args[i].equals("-port")) {
                if (i + 1 < args.length) {
                    try {
                        port = Integer.parseInt(args[++i]);
                        if (port >= 0) continue;
                        System.err.println("jvmmond: server port must not be negative (value given is " + port + ").");
                        System.exit(1);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("jvmmond: port '" + args[i] + "' is not a number.");
                        System.exit(1);
                    }
                    continue;
                }
                System.err.println("jvmmond: port option requires an argument.");
                System.exit(1);
                continue;
            }
            if (args[i].equals("-r") || args[i].equals("--port-range")) {
                if (i + 1 < args.length) {
                    portRangeStr = args[++i];
                    continue;
                }
                System.err.println("jvmmond: port range option requires an argument.");
                System.exit(1);
                continue;
            }
            if (args[i].equals("--protocol")) {
                if (i + 1 < args.length) {
                    String protVal;
                    if ((protVal = args[++i]).equals("rmi")) {
                        useJvmmondProtocol = false;
                        continue;
                    }
                    if (protVal.equals("jvmmond")) {
                        useRMI = false;
                        continue;
                    }
                    if (protVal.equals("mixed")) continue;
                    System.err.println("jvmmond: value '" + protVal + "' for protocol is unknown.\n\n" + JvmMonD.usage());
                    System.exit(1);
                    continue;
                }
                System.err.println("jvmmond: protocol option requires an argument.");
                System.exit(1);
                continue;
            }
            if (args[i].equals("--password:stdin") || args[i].equals("-password:stdin")) {
                passwordStdIn = true;
                continue;
            }
            if (args[i].equals("--password:stdout") || args[i].equals("-password:stdout")) {
                passwordStdOut = true;
                continue;
            }
            if (args[i].equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("--trace-file")) {
                if (i + 1 < args.length) {
                    traceFileName = args[++i];
                    continue;
                }
                System.err.println("jvmmond: trace file option requires an argument.");
                System.exit(1);
                continue;
            }
            System.err.println("Unknown option \"" + args[i] + "\".\n\n" + JvmMonD.usage());
            System.exit(1);
        }
        if (InspectorInfo.couldElevate()) {
            System.err.println("WARNING: current process is not run as administrator. Access to SAP JVMs might be limited.");
        }
        if (passwordStdIn) {
            System.out.print("Enter Password:");
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader br = new BufferedReader(isr);
            try {
                password = br.readLine();
            }
            catch (IOException e) {
                System.err.println("jvmmond: Caught Exception reading password: " + e.getMessage());
                if (verbose) {
                    e.printStackTrace(System.err);
                }
                System.exit(1);
            }
            if (!JvmMonD.isStrongPassword(password)) {
                System.err.println("jvmmond: Password doesn't meet criteria.\nMinimum 8 characters, at least one upper case character,\nat least one lower case character, at least one digit.");
                System.exit(1);
            }
        } else if (passwordStdOut) {
            char[] passwordChars = new char[32];
            SecureRandom rand = new SecureRandom();
            for (int i = 0; i < passwordChars.length; ++i) {
                passwordChars[i] = (char)rand.nextInt(65536);
            }
            password = new String(passwordChars);
        }
        ToolsHelper.setToolsTracingLevel((boolean)verbose, traceFileName);
        if (portRangeStr == null) {
            portRangeStr = System.getProperty("com.sap.jvm.tools.portRange");
        }
        PortRange pr = null;
        if (portRangeStr != null) {
            try {
                pr = new PortRange(portRangeStr);
            }
            catch (IllegalArgumentException e) {
                System.err.println("jvmmond: Could not parse port range \"" + portRangeStr + "\": " + e.getMessage());
                if (verbose) {
                    e.printStackTrace(System.err);
                }
                System.exit(1);
            }
        }
        if (port == 0 && pr == null) {
            port = 1099;
        }
        if (useRMI) {
            try {
                port = RMIServer.start(port, password, useJvmmondProtocol, pr);
            }
            catch (IOException e) {
                System.err.println("Couldn't start jvmmond:\n" + e.getMessage());
                System.exit(1);
            }
        } else {
            try {
                NewServer.start(port, password);
            }
            catch (IOException e) {
                System.err.println("Couldn't start jvmmond:\n" + e.getMessage());
                System.exit(1);
            }
        }
        System.out.println("jvmmond " + (useRMI ? (useJvmmondProtocol ? "(mixed) " : "(rmi) ") : "") + "listening on port:" + port);
        if (passwordStdOut) {
            System.out.print("Password:");
            for (int i = 0; i < password.length(); ++i) {
                String hexChar = String.format("%X", password.charAt(i));
                for (int j = 0; j < 4 - hexChar.length(); ++j) {
                    System.out.print("0");
                }
                System.out.print(hexChar);
            }
            System.out.println(".");
        }
        JvmMonD.startErrorQueueReader();
        JvmMonD.startConsoleReader();
        JvmMonD.awaitStop();
        System.exit(rc);
    }
}

