/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmond;

import com.sap.jvm.impl.internals.InternalsProviderImpl;
import com.sap.jvm.impl.monitor.transport.JvmmondSocketTools;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.filesocket.FileSocketConnection;
import com.sap.jvm.inspector.jvmmon.BoardChanges;
import com.sap.jvm.inspector.jvmmon.ControllerFallbacks;
import com.sap.jvm.inspector.jvmmon.JvmmondUtils;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.inspector.jvmmon.SimplePacketReader;
import com.sap.jvm.inspector.jvmmon.SimplePacketWriter;
import com.sap.jvm.internals.VmInternals;
import com.sap.jvm.monitor.cluster.Cluster;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class NewServer {
    private static final Tracer trc = Trace.get(NewServer.class);
    private static final int authenticationRequestThrottleMs = 100;
    private static final Semaphore authenticationRequestSemaphore = new Semaphore(10);
    private final String password;
    private byte[] salt;
    private byte[] expectedResponse;
    private Socket socket;
    private boolean authenticated;
    private SimplePacketReader reader;
    private SimplePacketWriter writer;
    private final long initialTime;
    private final long maxAuthenticationTime;
    private final MonitoringController controller;

    public NewServer(String password, Socket socket) throws IOException {
        this.socket = socket;
        this.password = password;
        this.initialTime = System.currentTimeMillis();
        this.maxAuthenticationTime = 30000L;
        this.salt = new byte[16];
        this.controller = new MonitoringController();
    }

    void handlerLoop() {
        Thread.currentThread().setName("Jvmmond-ProtocolHandler-" + this.socket.getInetAddress() + ":" + this.socket.getPort());
        try {
            this.reader = new SimplePacketReader(this.socket.getInputStream());
            this.writer = new SimplePacketWriter(this.socket.getOutputStream());
            if (!this.preAuthentificationLoop()) {
                this.socket.close();
                return;
            }
            if (this.postAuthentificationLoop()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            trc.error((Throwable)e);
        }
    }

    void runHandlerWithHandshake() {
        if (!JvmmondSocketTools.newProtocolHandshake((Socket)this.socket)) {
            System.out.println("Jvmmond protocol handshake from " + this.socket.getInetAddress() + ":" + this.socket.getPort() + " failed.");
            try {
                this.socket.close();
            }
            catch (IOException e) {
                trc.warn((Throwable)e);
            }
            return;
        }
        this.handlerLoop();
    }

    public static void start(int port, final String password) throws IOException {
        final ServerSocket ss = new ServerSocket(port);
        Thread acceptorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            while (true) {
                                NewServer ns = new NewServer(password, ss.accept());
                                new Thread(() -> ns.runHandlerWithHandshake()).start();
                            }
                        }
                        catch (IOException e) {
                            Trace.get(NewServer.class).warn((Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ss.close();
                    }
                    catch (IOException e) {
                        Trace.get(NewServer.class).warn((Throwable)e);
                    }
                    throw throwable;
                }
            }
        }, "Jvmmond-ServerSocket-Handler");
        acceptorThread.setDaemon(true);
        acceptorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean preAuthentificationLoop() throws IOException {
        this.authenticated = this.password == null;
        boolean isFirstTry = false;
        while (!this.authenticated) {
            int tag = this.reader.getPacket();
            long elapsed = System.currentTimeMillis() - this.initialTime;
            if (elapsed >= this.maxAuthenticationTime) {
                trc.debug(() -> "Authentication timeout (elapsed " + elapsed + ", max  " + this.maxAuthenticationTime);
                return false;
            }
            trc.debug(() -> "Handling in pre auth loop " + tag);
            if (tag == 101) {
                this.handleAuthenticationInfoRequest();
                continue;
            }
            if (tag == 103) {
                boolean authenticationSuccess = false;
                try {
                    authenticationRequestSemaphore.acquire();
                    Thread.sleep(100L);
                    authenticationSuccess = this.handleAuthenticationRequest();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    authenticationRequestSemaphore.release();
                }
                if (authenticationSuccess) continue;
                if (isFirstTry) {
                    isFirstTry = false;
                    continue;
                }
                trc.debug(() -> "Authentication failure");
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean postAuthentificationLoop() throws IOException {
        block9: while (true) {
            int tag;
            try {
                tag = this.reader.getPacket();
            }
            catch (IOException e) {
                trc.debug((Throwable)e, "Caught exception reading the next packet. Connection probably closed by client.");
                return true;
            }
            trc.debug(() -> "Handling " + tag);
            switch (tag) {
                case 105: {
                    if (!this.handleDirectProfilingRequest()) continue block9;
                    return false;
                }
                case 112: {
                    if (!this.handleDirectMonitoringRequest()) continue block9;
                    return false;
                }
                case 110: {
                    if (!this.handleDirectDebuggingRequest()) continue block9;
                    return false;
                }
                case 107: {
                    this.handleAllBoardsQuery();
                    continue block9;
                }
                case 101: {
                    this.handleAuthenticationInfoRequest();
                    continue block9;
                }
            }
            trc.error(() -> "Unknown tag " + tag);
            this.reader.finishPacket();
        }
    }

    private void handleAuthenticationInfoRequest() throws IOException {
        this.reader.finishPacket();
        this.writer.startPacket(102);
        this.writer.writeInt32(0);
        this.writer.writeBoolean(this.password != null);
        if (this.password != null) {
            try {
                SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
                sr.nextBytes(this.salt);
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(this.salt);
                this.expectedResponse = md.digest(this.password.getBytes(StandardCharsets.UTF_8));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Could not instantiate crypto algorithm for Authentication", e);
            }
            this.writer.writeInt32(this.salt.length);
            this.writer.writeBytes(this.salt);
        }
        this.writer.endPacket(102);
    }

    private boolean handleAuthenticationRequest() throws IOException {
        if (this.expectedResponse == null) {
            return false;
        }
        byte[] response = new byte[this.expectedResponse.length];
        this.reader.readBytes(response);
        int cmp = 0;
        for (int i = 0; i < response.length; ++i) {
            cmp |= response[i] ^ this.expectedResponse[i];
        }
        this.expectedResponse = null;
        this.salt = null;
        this.reader.finishPacket();
        if (cmp == 0) {
            this.authenticated = true;
        }
        this.writer.startPacket(104);
        this.writer.writeBoolean(this.authenticated);
        this.writer.endPacket(104);
        return this.authenticated;
    }

    private boolean handleDirectProfilingRequest() throws IOException {
        int pid = this.reader.readInt32();
        this.reader.finishPacket();
        SocketAdapter adapter = null;
        IOException exc = null;
        boolean success = false;
        try {
            adapter = FileSocketConnection.connectToPid((int)pid, (int)10000);
            success = true;
        }
        catch (IOException e) {
            exc = e;
        }
        this.writer.startPacket(106);
        this.writer.writeBoolean(success);
        this.writer.writeInt32(pid);
        this.writer.writeBoolean(adapter != null);
        this.writer.writeException((Throwable)exc);
        if (exc != null) {
            this.writer.writeString(exc.getMessage());
        }
        this.writer.endPacket(106);
        if (success) {
            this.reader.detach();
            this.writer.detach();
            JvmmondUtils.connect((InputStream)adapter.getInputStream(), (OutputStream)adapter.getOutputStream(), (InputStream)this.socket.getInputStream(), (OutputStream)this.socket.getOutputStream());
        }
        return success;
    }

    private boolean handleDirectMonitoringRequest() throws IOException {
        MonitoredVm vm;
        int pid = this.reader.readInt32();
        this.reader.finishPacket();
        try (MonitoringController tmpCtrl = new MonitoringController();){
            vm = tmpCtrl.getVmForPid(pid, true);
            trc.debug(() -> "Got VM for pid " + pid + " from MonitoringController: " + vm);
        }
        Vm legacyVm = null;
        VmInternals vmInternals = null;
        SocketAdapter adapter = null;
        boolean success = false;
        if (vm != null && !vm.getBoard().getBoolean("PROFILING_SERVER_SUPPORTS_LEGACY_MONITORING_OPERATIONS", false)) {
            trc.debug(() -> "Trying to get the legacy VM object for pid " + pid);
            legacyVm = Cluster.getVm((int)pid);
            success = legacyVm != null;
            vmInternals = InternalsProviderImpl.get().getVmInternalsByProcessId(pid);
            trc.debug(() -> "Got the legacy VM object for pid " + pid);
        }
        if (legacyVm == null) {
            trc.debug(() -> "Trying to get the file socket for a monitoring connection for pid " + pid);
            try {
                adapter = FileSocketConnection.connectToPid((int)pid, (int)10000);
                success = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writer.startPacket(113);
        this.writer.writeBoolean(success);
        this.writer.writeInt32(pid);
        this.writer.endPacket(113);
        if (legacyVm != null) {
            this.reader.detach();
            this.writer.detach();
            adapter = SocketAdapterFactory.getForSocket((Socket)this.socket);
            ControllerFallbacks.simulateProfilingServerForMonitoring((SocketAdapter)adapter, (Vm)legacyVm, (VmInternals)vmInternals);
        } else if (adapter != null) {
            this.reader.detach();
            this.writer.detach();
            JvmmondUtils.connect((InputStream)adapter.getInputStream(), (OutputStream)adapter.getOutputStream(), (InputStream)this.socket.getInputStream(), (OutputStream)this.socket.getOutputStream());
        }
        return success;
    }

    private boolean handleDirectDebuggingRequest() throws IOException {
        int pid = this.reader.readInt32();
        SuspendPolicy sp = this.reader.hasMoreData() ? SuspendPolicy.getByIndex((int)this.reader.readInt8()) : SuspendPolicy.SUSPEND_ALL;
        this.reader.finishPacket();
        SocketAdapter adapter = null;
        IOException exc = null;
        boolean success = false;
        try {
            adapter = FileSocketConnection.connectToPid((int)pid, (int)10000);
            adapter.getOutputStream().write(JvmmondUtils.getChangeToDebuggingCommand((SuspendPolicy)sp));
            success = true;
        }
        catch (IOException e) {
            exc = e;
        }
        this.writer.startPacket(111);
        this.writer.writeBoolean(success);
        this.writer.writeInt32(pid);
        this.writer.writeBoolean(adapter != null);
        this.writer.writeException((Throwable)exc);
        if (exc != null) {
            this.writer.writeString(exc.getMessage());
        }
        this.writer.endPacket(111);
        if (success) {
            this.reader.detach();
            this.writer.detach();
            JvmmondUtils.connect((InputStream)adapter.getInputStream(), (OutputStream)adapter.getOutputStream(), (InputStream)this.socket.getInputStream(), (OutputStream)this.socket.getOutputStream());
        }
        return success;
    }

    private void writeBoard(BoardWrapper board) throws IOException {
        byte[] data = board.getBoardData();
        int len = board.getBoardSize();
        this.writer.writeInt8((byte)0);
        this.writer.writeInt32(len);
        this.writer.writeBytes(data, 0, len);
    }

    private void handleAllBoardsQuery() throws IOException {
        this.reader.finishPacket();
        BoardChanges changes = this.controller.getChanges();
        trc.debug(() -> "Handling all boards query");
        this.writer.startPacket(108);
        this.writer.writeInt32(changes.newBoards.size());
        for (Map.Entry entry : changes.newBoards.entrySet()) {
            trc.debug(() -> "Found new board with pid " + entry.getKey());
            BoardWrapper board = (BoardWrapper)entry.getValue();
            board.makeValid();
            this.writeBoard(board);
        }
        this.writer.writeInt32(changes.changedBoards.size());
        for (Map.Entry entry : changes.changedBoards.entrySet()) {
            int pid = (Integer)entry.getKey();
            trc.debug(() -> "Found changed board with pid " + pid);
            BoardWrapper board = (BoardWrapper)entry.getValue();
            board.makeValid();
            this.writer.writeInt32(pid);
            this.writeBoard(board);
        }
        this.writer.writeInt32(changes.deletedBoards.size());
        for (Map.Entry entry : changes.deletedBoards.entrySet()) {
            trc.debug(() -> "Found deleted board with pid " + entry.getKey());
            BoardWrapper board = (BoardWrapper)entry.getValue();
            board.makeValid();
            this.writeBoard(board);
        }
        this.writer.endPacket(108);
    }
}

