/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmond;

import com.sap.jvm.impl.RemoteDebuggingBackendProviderImpl;
import com.sap.jvm.impl.RemoteFileSocketConnectionImpl;
import com.sap.jvm.impl.internals.RemoteInternalsProviderImpl;
import com.sap.jvm.impl.monitor.remoteCluster.RemoteClusterImpl;
import com.sap.jvm.impl.monitor.transport.JvmmondClientSocketFactory;
import com.sap.jvm.impl.monitor.transport.JvmmondServerSocketFactory;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardProviderImpl;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.tools.monitor.jvmmond.NewServer;
import java.io.IOException;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public class RMIServer {
    public static int start(int port, final String password, boolean startNewServer, PortRange pr) throws IOException {
        JvmmondClientSocketFactory csf;
        boolean enforceLocal = password != null;
        JvmmondServerSocketFactory.NewProtocolHandlerStarter nphs = startNewServer ? new JvmmondServerSocketFactory.NewProtocolHandlerStarter(){

            public void start(Socket socket) throws IOException {
                NewServer ns = new NewServer(password, socket);
                new Thread(() -> ns.handlerLoop()).start();
            }
        } : null;
        JvmmondServerSocketFactory regFac = enforceLocal || startNewServer || port == 0 ? new JvmmondServerSocketFactory(null, enforceLocal, nphs, pr) : null;
        Registry registry = LocateRegistry.createRegistry(port, null, (RMIServerSocketFactory)regFac);
        if (port == 0) {
            port = regFac.getLastPort();
        }
        JvmmondClientSocketFactory jvmmondClientSocketFactory = csf = enforceLocal ? new JvmmondClientSocketFactory(port) : null;
        JvmmondServerSocketFactory ssf = enforceLocal || pr != null ? new JvmmondServerSocketFactory(password, password != null, null, pr) : null;
        RemoteBoardProviderImpl boardProviderEx = new RemoteBoardProviderImpl((RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        registry.rebind("RemoteBoardProvider", (Remote)boardProviderEx);
        registry.rebind("RemoteBoardProviderEx", (Remote)boardProviderEx);
        RemoteClusterImpl cluster = new RemoteClusterImpl((RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        registry.rebind("RemoteCluster", (Remote)cluster);
        RemoteInternalsProviderImpl internals = new RemoteInternalsProviderImpl((RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        registry.rebind("RemoteInternalsProvider", (Remote)internals);
        RemoteFileSocketConnectionImpl fileSocketConnection = new RemoteFileSocketConnectionImpl((RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        registry.rebind("RemoteProfilingConnection", (Remote)fileSocketConnection);
        RemoteDebuggingBackendProviderImpl debuggingProvider = new RemoteDebuggingBackendProviderImpl((RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        registry.rebind("RemoteDebuggingProvider", (Remote)debuggingProvider);
        return port;
    }
}

