/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.psvm;

import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.FlagWithOptionList;
import com.sap.jvm.tools.monitor.psvm.OutputColumn;
import com.sap.jvm.tools.monitor.psvm.SortSpec;
import java.util.ArrayList;

public final class FlagSort
extends FlagWithOptionList {
    SortSpec[] sortOrder;
    static final String description = "Specify sorting order. Sorting syntax is [+|-]key[,[+|-]key[,...]]. Key is one of the output column specifiers (see \"-o\" option). Example: psvm -ef --sort=-hpsz,pid";

    public FlagSort() {
        super(null, "sort", description, "[+|-]key");
    }

    @Override
    protected void postParse() throws ArgumentException {
        super.postParse();
        if (this.isSet()) {
            String[] cmdLineValues = this.getOptionValues();
            ArrayList<SortSpec> tmp = new ArrayList<SortSpec>();
            for (int i = 0; i < cmdLineValues.length; ++i) {
                String v = cmdLineValues[i];
                boolean ascending = true;
                if (v.startsWith("+")) {
                    v = v.substring(1);
                } else if (v.startsWith("-")) {
                    ascending = false;
                    v = v.substring(1);
                }
                OutputColumn oc = OutputColumn.getByOptionName(v);
                if (oc == null) {
                    throw new ArgumentException("invalid sort key '" + v + "' for --sort");
                }
                tmp.add(new SortSpec(oc, ascending));
            }
            this.sortOrder = tmp.toArray(new SortSpec[tmp.size()]);
        }
    }

    public final SortSpec[] getSortOrder() {
        return this.sortOrder;
    }
}

