/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.psvm;

import com.sap.jvm.tools.monitor.psvm.OutputColumn;
import com.sap.jvm.tools.monitor.psvm.OutputLine;
import com.sap.jvm.tools.monitor.psvm.OutputLineComparator;
import com.sap.jvm.tools.monitor.psvm.SortSpec;
import com.sap.jvm.tools.monitor.psvm.cells.Cell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Output {
    private static final int GAP_BETWEEN_COLUMNS = 2;
    private final OutputColumn[] header;
    private final List<OutputLine> lines;

    public Output(OutputColumn[] header) {
        this.header = header;
        this.lines = new ArrayList<OutputLine>();
    }

    public void add(OutputLine line) {
        if (line.values.length != this.header.length) {
            throw new IllegalArgumentException("line does not match header.");
        }
        this.lines.add(line);
    }

    private static void printPad(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
    }

    private static void printPaddedString(String s, int padlen) {
        System.out.print(s);
        int l = padlen - s.length();
        if (l > 0) {
            Output.printPad(l);
        }
    }

    public final void printOutput(boolean printHeaderLine, SortSpec[] sortorder) {
        OutputLineComparator comparator = new OutputLineComparator(sortorder, this.header);
        OutputLine[] sorted = this.lines.toArray(new OutputLine[this.lines.size()]);
        Arrays.sort(sorted, comparator);
        int[] widths = new int[this.header.length];
        for (int colno = 0; colno < this.header.length; ++colno) {
            widths[colno] = this.header[colno].header.length();
        }
        for (OutputLine ol : sorted) {
            for (int colno = 0; colno < this.header.length; ++colno) {
                String v = ol.values[colno].toString();
                if (v.length() <= widths[colno]) continue;
                widths[colno] = v.length();
            }
        }
        if (printHeaderLine) {
            for (int colno = 0; colno < this.header.length; ++colno) {
                if (colno < this.header.length - 1) {
                    Output.printPaddedString(this.header[colno].header, widths[colno] + 2);
                    continue;
                }
                System.out.print(this.header[colno].header);
            }
        }
        System.out.println();
        for (OutputLine ol : sorted) {
            for (int colno = 0; colno < this.header.length; ++colno) {
                Cell<?> cell = ol.values[colno];
                String s = cell.toString();
                if (colno < this.header.length - 1) {
                    Output.printPaddedString(s, widths[colno] + 2);
                    continue;
                }
                System.out.print(s);
            }
            System.out.println();
            if (ol.attributes == null) continue;
            for (Map.Entry<String, String> entry : ol.attributes.entrySet()) {
                System.out.println(entry.getKey() + "=" + entry.getValue());
            }
            System.out.println("-----------------");
        }
    }
}

