/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.psvm;

enum OutputColumn {
    USER("UID", "user", "Process user name or id."),
    EUID("EUID", "euid", "Effective user Id (Unix/Linux only)"),
    PID("PID", "pid", "Process ID"),
    PPID("PPID", "ppid", "Parent process Id"),
    HEAP_SIZE("HPSZ", "hpsz", "Java heap size"),
    START_TIME("START", "start", "Start time of this process."),
    VMTAG("VMTAG", "vmtag", "The VM tag, if one is given"),
    JAVAHOME("JAVAHOME", "javahome", "JAVA_HOME of this VM."),
    BUILD_INFO("BLDINFO", "buildinfo", "Build information (version, code line, ...)"),
    BUILD_DATE("BLDDATE", "builddate", "Build date"),
    BUILD_USER("BLDUSER", "builduser", "Build user"),
    BUILD_P4CL("P4CL", "p4cl", "P4 Change List (LASTCHANGE)"),
    ARCHITECTURE("ARCH", "arch", "Build architecture."),
    VERSION("VER", "version", "SAP JVM version information"),
    SIZE_ARENAS("ASZ", "asz", "Current size of all Arenas"),
    SIZE_ARENAS_JIT("ASZJIT", "aszjit", "Current size of all JIT-related arenas"),
    SIZE_ARENAS_JIT_PERCENT("ASZJITP", "aszjitp", "Percentage JIT takes on current size of all Arenas"),
    PEAK_SIZE_ARENAS("ASZMAX", "aszmax", "Peak size of all Arenas"),
    PEAK_SIZE_ARENAS_JIT("ASZMAXJIT", "aszmaxjit", "Size of all JIT-related arenas at the time of the last global peak"),
    PEAK_SIZE_ARENAS_JIT_PERCENT("ASZMAXJITP", "aszmaxjitp", "Percentage JIT at the time of the last global peak"),
    PROCESS_SPAWNS("PSPWN", "pspwn", "Number of times the VM spawned a process"),
    PROCESS_SPAWN_ERRORS("PSPWNE", "pspwne", "Number of times the VM attempted to spawn a process but failed"),
    ORIGIN("ORIGIN", "origin", "'M' for a monitoring board, 'C' for control area"),
    VMARGS("VMARGS", "vmargs", "VM Arguments"),
    CMD("CMD", "cmd", "Command: Java or jar main class"),
    JAVA_ARGS("JARGS", "jargs", "Java program arguments"),
    CLASSPATH("CLASSPATH", "classpath", "Java Classpath"),
    CWD("CWD", "cwd", "Current working directory");

    final String header;
    final String optionName;
    final String description;

    public final String getHeader() {
        return this.header;
    }

    public final String getOptionName() {
        return this.optionName;
    }

    public final String getDescription() {
        return this.description;
    }

    private OutputColumn(String header, String optionName, String description) {
        this.header = header;
        this.optionName = optionName;
        this.description = description;
    }

    static OutputColumn getByOptionName(String name) {
        for (OutputColumn oc : OutputColumn.values()) {
            if (!oc.optionName.equals(name)) continue;
            return oc;
        }
        return null;
    }
}

