/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.psvm;

import com.sap.jvm.tools.monitor.psvm.OutputColumn;

enum OutputColumnGroup {
    DEFAULT(null, OutputColumn.PID, OutputColumn.USER, OutputColumn.BUILD_INFO, OutputColumn.HEAP_SIZE, OutputColumn.START_TIME, OutputColumn.CMD),
    FULL(null, OutputColumn.PID, OutputColumn.USER, OutputColumn.EUID, OutputColumn.BUILD_INFO, OutputColumn.BUILD_DATE, OutputColumn.BUILD_DATE, OutputColumn.HEAP_SIZE, OutputColumn.START_TIME, OutputColumn.CMD),
    VERY_FULL(null, OutputColumn.PID, OutputColumn.USER, OutputColumn.EUID, OutputColumn.BUILD_INFO, OutputColumn.BUILD_DATE, OutputColumn.ARCHITECTURE, OutputColumn.VERSION, OutputColumn.HEAP_SIZE, OutputColumn.CLASSPATH, OutputColumn.VMARGS, OutputColumn.CMD),
    ARENA("arena", OutputColumn.SIZE_ARENAS, OutputColumn.PEAK_SIZE_ARENAS, OutputColumn.SIZE_ARENAS_JIT, OutputColumn.SIZE_ARENAS_JIT_PERCENT, OutputColumn.PEAK_SIZE_ARENAS_JIT, OutputColumn.PEAK_SIZE_ARENAS_JIT_PERCENT),
    HEAP("heap", OutputColumn.HEAP_SIZE),
    PSPWN("pspwn", OutputColumn.PROCESS_SPAWNS, OutputColumn.PROCESS_SPAWN_ERRORS),
    BUILD("build", OutputColumn.BUILD_INFO, OutputColumn.BUILD_USER, OutputColumn.BUILD_DATE, OutputColumn.BUILD_P4CL);

    private final String dash_o_option;
    private final OutputColumn[] columns;

    private OutputColumnGroup(String dash_o_option, OutputColumn ... columns) {
        this.dash_o_option = dash_o_option;
        this.columns = columns;
    }

    public final String getDash_o_option() {
        return this.dash_o_option;
    }

    public static OutputColumnGroup getGroupByName(String name) {
        for (OutputColumnGroup ocg : OutputColumnGroup.values()) {
            if (ocg.dash_o_option == null || !ocg.dash_o_option.equals(name)) continue;
            return ocg;
        }
        return null;
    }

    public final OutputColumn[] getColumns() {
        return this.columns;
    }
}

