/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.psvm;

import com.sap.jvm.tools.monitor.psvm.OutputColumn;
import com.sap.jvm.tools.monitor.psvm.OutputLine;
import com.sap.jvm.tools.monitor.psvm.SortSpec;
import com.sap.jvm.tools.monitor.psvm.cells.Cell;
import java.util.ArrayList;
import java.util.Comparator;

public class OutputLineComparator
implements Comparator<OutputLine> {
    final PreparedSortSpec[] preparedSortOrder;

    public OutputLineComparator(SortSpec[] sortorder, OutputColumn[] headerColumns) {
        ArrayList<PreparedSortSpec> tmp = new ArrayList<PreparedSortSpec>();
        for (int sortColno = 0; sortColno < sortorder.length; ++sortColno) {
            OutputColumn oc = sortorder[sortColno].column;
            int colno = -1;
            for (int i = 0; i < headerColumns.length; ++i) {
                if (headerColumns[i] != oc) continue;
                colno = i;
            }
            if (colno == -1) continue;
            boolean ascending = sortorder[sortColno].ascending;
            PreparedSortSpec pss = new PreparedSortSpec(colno, ascending);
            tmp.add(pss);
        }
        this.preparedSortOrder = tmp.toArray(new PreparedSortSpec[tmp.size()]);
    }

    @Override
    public int compare(OutputLine arg0, OutputLine arg1) {
        for (PreparedSortSpec pss : this.preparedSortOrder) {
            Cell<?> a = arg0.values[pss.colno];
            Cell<?> b = arg1.values[pss.colno];
            boolean ascending = pss.ascending;
            int cmp = a.compareTo(b, ascending);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static class PreparedSortSpec {
        public final int colno;
        public final boolean ascending;

        private PreparedSortSpec(int colno, boolean ascending) {
            this.colno = colno;
            this.ascending = ascending;
        }
    }
}

