/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.psvm;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.Board;
import com.sap.jvm.inspector.board.BoardHelpers;
import com.sap.jvm.inspector.board.BoardManager;
import com.sap.jvm.inspector.board.KnownAttribute;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.ArgumentParser;
import com.sap.jvm.internal.util.cmdline.Flag;
import com.sap.jvm.internal.util.cmdline.FlagWithBooleanOption;
import com.sap.jvm.internal.util.cmdline.FlagWithIntegerOptionList;
import com.sap.jvm.internal.util.cmdline.FlagWithOption;
import com.sap.jvm.internal.util.cmdline.FlagWithOptionList;
import com.sap.jvm.internal.util.cmdline.FlagWithRegexOption;
import com.sap.jvm.tools.monitor.psvm.FlagOutputFormat_capital_o;
import com.sap.jvm.tools.monitor.psvm.FlagOutputFormat_o;
import com.sap.jvm.tools.monitor.psvm.FlagSort;
import com.sap.jvm.tools.monitor.psvm.Output;
import com.sap.jvm.tools.monitor.psvm.OutputColumn;
import com.sap.jvm.tools.monitor.psvm.OutputColumnGroup;
import com.sap.jvm.tools.monitor.psvm.OutputLine;
import com.sap.jvm.tools.monitor.psvm.SortSpec;
import com.sap.jvm.tools.monitor.psvm.cells.Cell;
import com.sap.jvm.tools.monitor.psvm.cells.DataSizeCell;
import com.sap.jvm.tools.monitor.psvm.cells.DecimalNumberCell;
import com.sap.jvm.tools.monitor.psvm.cells.PercentageCell;
import com.sap.jvm.tools.monitor.psvm.cells.StringCell;
import com.sap.jvm.tools.monitor.psvm.cells.TimestampCell;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PsVm {
    private static String toolName = "psvm";
    private static String toolDescription = "psvm displays a list of running SAP JVM processes (similar to ps).";
    private static Flag flag_help = Flag.createHelpFlag();
    private static Flag flag_A = new Flag('A', null, "This selects all processes (same as -e).");
    private static Flag flag_e = new Flag('e', null, "This selects all processes (same as -A).");
    private static FlagWithIntegerOptionList flag_p = new FlagWithIntegerOptionList('p', "pid", "This selects the processes whose process ID numbers appear in pidlist.", "pidlist");
    private static FlagWithOptionList flag_u = new FlagWithOptionList(Character.valueOf('u'), "user", "This selects the processes whose user name or uid appear in userlist.", "userlist");
    private static FlagWithOptionList flag_U = new FlagWithOptionList(Character.valueOf('U'), "euid", "This selects the processes whose user name or euid (effective user id) appear in userlist.", "userlist");
    private static FlagWithOption flag_C = new FlagWithOption('C', "cmd", "Select by Java program name (Main class or jar main class). Option may contain trailing wildcards - all processes will be selected whose main class match the given prefix, e.g. <em>psvm -C 'com.sap*'</em>:", "mainclass");
    private static FlagWithOptionList flag_vmtag = new FlagWithOptionList(null, "vmtag", "This selects the processes whose vm tag appear in the vm-tag list.", "vmtag");
    private static FlagWithOptionList flag_exe = new FlagWithOptionList(null, "exe", "This selects the processes whose executable name appears in the list.", "exe");
    private static FlagOutputFormat_o flag_o = new FlagOutputFormat_o();
    private static FlagOutputFormat_capital_o flag_O = new FlagOutputFormat_capital_o();
    private static Flag flag_f = new Flag('f', null, "full-format listing. This option can be combined with many other options to add additional columns. It also causes both VM- and java program arguments to be printed.");
    private static Flag flag_F = new Flag('F', null, "extra-full-format listing. Like -f, with even more columns.");
    private static FlagSort flag_sort = new FlagSort();
    private static FlagWithOption flag_raw_mode = new FlagWithOption('r', "raw-mode", "Display all attributes for each listed process. Attributes are listed in <key>=<value> pairs one below the other. The optional argument \"filter\" allows to list only those attributes whose keys contain the filter (e.g. \"-r HEAP\" to show all attributes named \"bla..HEAP..bla\".\nFor more sophisticated filtering see \"--filter-attribute\".", "filter", null);
    private static FlagWithRegexOption flag_filter_attribute = new FlagWithRegexOption(null, "filter-attribute", "When '-r' or '--raw-mode' is given, specifies a regular expressions to filter attributes by. Only attributes whose names match the regular expressions are printed out. Example: psvm -A --filter-attribute 'JAVA.*' prints out all attributes starting with JAVA.", "pattern");
    private static Flag flag_h = new Flag('h', "no-header", "Surpress the header line in the output.");
    private static FlagWithBooleanOption flag_include_controlarea = new FlagWithBooleanOption(null, "include-controlarea", "Include information from the control area");

    private static Double getPercentValueOfTwoLongAttributes(Board board, KnownAttribute partAttr, KnownAttribute totalAttr) {
        Long lpart = BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)partAttr);
        Long ltotal = BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)totalAttr);
        if (lpart != null && ltotal != null) {
            double dtotal = ltotal.doubleValue();
            return 100.0 * (lpart.doubleValue() / dtotal);
        }
        return null;
    }

    private static Cell<?> getInformationFromBoard(Board board, OutputColumn oc) {
        Cell result = null;
        try {
            switch (oc) {
                case ARCHITECTURE: {
                    String s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.ARCHITECTURE);
                    result = new StringCell(s);
                    break;
                }
                case BUILD_DATE: {
                    String s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.BUILD_DATE);
                    result = new StringCell(s);
                    break;
                }
                case BUILD_INFO: {
                    String hotspot_version;
                    String release = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JDK_VERSION);
                    if (release != null) {
                        if (release.startsWith("1.4")) {
                            release = "4";
                        } else {
                            Pattern pat = Pattern.compile("^\\d.*");
                            if (pat.matcher(release).matches()) {
                                release = release.substring(0, 1);
                            }
                        }
                    }
                    String codeline = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.CODELINE);
                    String type = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.SAPJVM_TYPE);
                    if (type == null && (hotspot_version = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.BUILDTARGET)) != null) {
                        if (hotspot_version.equals("debug")) {
                            type = "dbg";
                        } else if (hotspot_version.equals("product")) {
                            type = "opt";
                        }
                    }
                    String s = (release != null ? release : "??") + "-" + (codeline != null ? codeline : "??") + "-" + (type != null ? type : "??");
                    result = new StringCell(s);
                    break;
                }
                case BUILD_P4CL: {
                    result = new DecimalNumberCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.LASTCHANGE));
                    break;
                }
                case BUILD_USER: {
                    result = new StringCell(BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.BUILDUSER));
                    break;
                }
                case CLASSPATH: {
                    result = new StringCell(BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.CLASSPATH));
                    break;
                }
                case CMD: {
                    String javaargs;
                    String s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JAVA_MAINCLASS);
                    if (s == null || s.length() == 0) {
                        s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JAVA_JAR_MAINCLASS);
                    }
                    if (flag_f.isSet() && (javaargs = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JAVA_ARGUMENTS)) != null) {
                        s = s + " " + javaargs;
                    }
                    result = new StringCell(s);
                    break;
                }
                case CWD: {
                    result = new StringCell(BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.WORKINGDIR));
                    break;
                }
                case EUID: {
                    result = new DecimalNumberCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.EUID));
                    break;
                }
                case HEAP_SIZE: {
                    Long l = BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.JAVA_HEAP_RESERVED);
                    result = new DataSizeCell(l);
                    break;
                }
                case JAVA_ARGS: {
                    result = new StringCell(BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JAVA_ARGUMENTS));
                    break;
                }
                case JAVAHOME: {
                    String s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JAVA_HOME);
                    result = new StringCell(s);
                    break;
                }
                case PID: {
                    result = new DecimalNumberCell(Long.valueOf(board.getPid()));
                    break;
                }
                case START_TIME: {
                    result = new TimestampCell(board.getStartingTimeStamp());
                    break;
                }
                case VERSION: {
                    String s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JDK_VERSION);
                    result = new StringCell(s);
                    break;
                }
                case VMTAG: {
                    result = new StringCell(BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JVM_TAG));
                    break;
                }
                case USER: {
                    String s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.USER_NAME);
                    if (s == null) {
                        s = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.UID);
                    }
                    result = new StringCell(s);
                    break;
                }
                case VMARGS: {
                    String key;
                    Attribute attr;
                    StringBuilder bld = new StringBuilder();
                    int i = 0;
                    while ((attr = board.get(key = "JVM_ARGUMENT" + i)) != null) {
                        bld.append(attr.getValue().getAsString());
                        bld.append(" ");
                        ++i;
                    }
                    result = new StringCell(bld.toString());
                    break;
                }
                case PPID: {
                    result = new DecimalNumberCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.PARENT_PID));
                    break;
                }
                case SIZE_ARENAS: {
                    result = new DataSizeCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.SIZE_ARENAS));
                    break;
                }
                case PEAK_SIZE_ARENAS: {
                    result = new DataSizeCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.PEAK_SIZE_ARENAS));
                    break;
                }
                case SIZE_ARENAS_JIT: {
                    result = new DataSizeCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.SIZE_ARENAS_JIT));
                    break;
                }
                case SIZE_ARENAS_JIT_PERCENT: {
                    result = new PercentageCell(PsVm.getPercentValueOfTwoLongAttributes(board, KnownAttribute.SIZE_ARENAS_JIT, KnownAttribute.SIZE_ARENAS));
                    break;
                }
                case PEAK_SIZE_ARENAS_JIT: {
                    result = new DataSizeCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.PEAK_SIZE_ARENAS_JIT));
                    break;
                }
                case PEAK_SIZE_ARENAS_JIT_PERCENT: {
                    result = new PercentageCell(PsVm.getPercentValueOfTwoLongAttributes(board, KnownAttribute.PEAK_SIZE_ARENAS_JIT, KnownAttribute.PEAK_SIZE_ARENAS));
                    break;
                }
                case ORIGIN: {
                    String s = "?";
                    s = board.isBoardBased() ? "M" : "C";
                    result = new StringCell(s);
                    break;
                }
                case PROCESS_SPAWNS: {
                    result = new DecimalNumberCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.CHILD_PROCESSES_CREATED));
                    break;
                }
                case PROCESS_SPAWN_ERRORS: {
                    result = new DecimalNumberCell(BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.CHILD_PROCESSES_FAILED));
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        if (result == null) {
            result = new StringCell("??");
        }
        return result;
    }

    private static void addColumnsToSet(Set<OutputColumn> set, OutputColumn[] cols) {
        for (OutputColumn col : cols) {
            set.add(col);
        }
    }

    private static boolean selectProcess(Board board) throws MonitorBoardFormatException {
        if (flag_A.isSet() || flag_e.isSet()) {
            return true;
        }
        int pid = board.getPid();
        if (flag_p.isSet()) {
            boolean selected = false;
            for (int selectPid : flag_p.getOptionValuesAsIntegers()) {
                if (pid != selectPid) continue;
                selected = true;
                break;
            }
            if (!selected) {
                return false;
            }
        }
        if (flag_u.isSet()) {
            int selectPid;
            String userName = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.USER_NAME);
            Long uid = BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.UID);
            boolean selected = false;
            String[] stringArray = flag_u.getOptionValues();
            selectPid = stringArray.length;
            for (int i = 0; i < selectPid; ++i) {
                String selectUser = stringArray[i];
                if (userName != null && userName.equalsIgnoreCase(selectUser)) {
                    selected = true;
                    break;
                }
                if (uid == null) continue;
                try {
                    if (uid != Long.parseLong(selectUser)) continue;
                    selected = true;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!selected) {
                return false;
            }
        }
        if (flag_U.isSet()) {
            Long euid = BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.EUID);
            boolean selected = false;
            if (euid != null) {
                for (String selectUser : flag_U.getOptionValues()) {
                    if (!euid.toString().equals(selectUser)) continue;
                    selected = true;
                    break;
                }
                if (!selected) {
                    return false;
                }
            }
        }
        if (flag_C.isSet()) {
            String mainClass = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JAVA_MAINCLASS);
            String jarMainClass = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JAVA_JAR_MAINCLASS);
            String selectMainClass = flag_C.getOptionValue();
            boolean selected = false;
            if (selectMainClass.endsWith("*")) {
                String prefix = selectMainClass.substring(0, selectMainClass.length() - 1);
                if (mainClass != null && mainClass.startsWith(prefix)) {
                    selected = true;
                } else if (jarMainClass != null && jarMainClass.startsWith(prefix)) {
                    selected = true;
                }
            } else if (mainClass != null && mainClass.equals(selectMainClass)) {
                selected = true;
            } else if (jarMainClass != null && jarMainClass.equals(selectMainClass)) {
                selected = true;
            }
            if (!selected) {
                return false;
            }
        }
        if (flag_vmtag.isSet()) {
            String vmtag = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.JVM_TAG);
            boolean found = false;
            for (String s : flag_vmtag.getOptionValues()) {
                if (!s.equals(vmtag)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (flag_exe.isSet()) {
            String exeName = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.EXECUTABLE);
            int lastPart = Math.max(exeName.lastIndexOf(92), exeName.lastIndexOf(47));
            exeName = exeName.substring(lastPart + 1);
            boolean found = false;
            for (String s : flag_exe.getOptionValues()) {
                if (!s.equals(exeName) && !s.equals(exeName + ".exe") && !(s + ".exe").equals(exeName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser();
        parser.setToolName(toolName);
        parser.setToolDescription(toolDescription);
        parser.addFlag(flag_A);
        parser.addFlag(flag_e);
        parser.addFlag(flag_C);
        parser.addFlag(flag_p);
        parser.addFlag(flag_u);
        parser.addFlag(flag_U);
        parser.addFlag(flag_vmtag);
        parser.addFlag(flag_exe);
        parser.addFlag(flag_o);
        parser.addFlag(flag_O);
        parser.addFlag(flag_sort);
        parser.addFlag(flag_f);
        parser.addFlag(flag_F);
        parser.addFlag(flag_h);
        parser.addFlag(flag_include_controlarea);
        parser.addFlag(flag_raw_mode);
        parser.addFlag(flag_filter_attribute);
        parser.addFlag(flag_help);
        try {
            parser.parseArguments(args);
        }
        catch (ArgumentException e) {
            System.err.println("Error " + e.getMessage());
            System.err.println(parser.getUsageString());
            System.exit(1);
        }
        if (flag_help.isSet()) {
            System.err.println(parser.getUsageString());
            System.exit(0);
        }
        if (InspectorInfo.couldElevate()) {
            System.err.println("WARNING: psvm is not run as administrator. This might limit the number of visible JVMs.");
        }
        OutputColumn[] columns = null;
        HashSet<OutputColumn> set = new HashSet<OutputColumn>();
        if (flag_f.isSet()) {
            PsVm.addColumnsToSet(set, OutputColumnGroup.FULL.getColumns());
        }
        if (flag_F.isSet()) {
            PsVm.addColumnsToSet(set, OutputColumnGroup.VERY_FULL.getColumns());
        }
        if (flag_o.isSet()) {
            PsVm.addColumnsToSet(set, flag_o.getOutputColumnValues());
        }
        if (flag_O.isSet()) {
            PsVm.addColumnsToSet(set, flag_O.getOutputColumnValues());
            PsVm.addColumnsToSet(set, OutputColumnGroup.DEFAULT.getColumns());
        }
        if (set.isEmpty()) {
            PsVm.addColumnsToSet(set, OutputColumnGroup.DEFAULT.getColumns());
        }
        columns = new OutputColumn[set.size()];
        int i = 0;
        for (OutputColumn col : OutputColumn.values()) {
            if (!set.contains((Object)col)) continue;
            columns[i] = col;
            ++i;
        }
        boolean include_control_areas = flag_include_controlarea.isSet() ? flag_include_controlarea.getOptionValueAsBoolean() : true;
        BoardManager man = BoardManager.createForLocal((boolean)include_control_areas);
        try {
            man.refresh();
        }
        catch (MonitorBoardFormatException e) {
            System.err.println("Error while reading board.");
            System.exit(-1);
        }
        Board myself = null;
        for (Board board : man) {
            if (!board.belongsToOwnProcess()) continue;
            myself = board;
            break;
        }
        Long my_euid = null;
        String my_username = null;
        if (myself != null) {
            my_euid = BoardHelpers.getBoardAttributeAsLong((Board)myself, (KnownAttribute)KnownAttribute.EUID);
            my_username = BoardHelpers.getBoardAttributeAsString((Board)myself, (KnownAttribute)KnownAttribute.USER_NAME);
        }
        Output output = new Output(columns);
        for (Board board : man) {
            boolean selected = true;
            if (!flag_e.isSet() && !flag_A.isSet()) {
                if (flag_C.isSet() || flag_p.isSet() || flag_u.isSet() || flag_U.isSet() || flag_vmtag.isSet() || flag_exe.isSet()) {
                    try {
                        selected = PsVm.selectProcess(board);
                    }
                    catch (MonitorBoardFormatException e1) {
                        System.err.println("Error while reading board belonging to pid " + board.getPid() + ".");
                        selected = false;
                    }
                } else {
                    selected = false;
                    if (my_euid != null) {
                        Long his_euid = BoardHelpers.getBoardAttributeAsLong((Board)board, (KnownAttribute)KnownAttribute.EUID);
                        if (his_euid != null && my_euid.longValue() == his_euid.longValue()) {
                            selected = true;
                        }
                    } else if (my_username != null) {
                        String his_username = BoardHelpers.getBoardAttributeAsString((Board)board, (KnownAttribute)KnownAttribute.USER_NAME);
                        if (his_username != null && my_username.equals(his_username)) {
                            selected = true;
                        }
                    } else {
                        System.err.println("psvm does not seem to run on a SAP JVM; some features may not work.");
                        selected = true;
                    }
                }
            }
            if (!selected) continue;
            Cell[] values = new Cell[columns.length];
            for (int colno = 0; colno < columns.length; ++colno) {
                OutputColumn oc = columns[colno];
                values[colno] = PsVm.getInformationFromBoard(board, oc);
            }
            TreeMap<String, String> attributes = null;
            if (flag_raw_mode.isSet()) {
                attributes = new TreeMap<String, String>();
                Iterator it = board.getAttributeIterator();
                while (it.hasNext()) {
                    Attribute attr = (Attribute)it.next();
                    String name = null;
                    String value = null;
                    try {
                        name = attr.getName();
                        value = attr.isArray() ? Arrays.toString(attr.getValues()) : attr.getValue().getAsString();
                    }
                    catch (MonitorBoardFormatException e) {
                        System.err.println("MonitorBoardFormatException while reading attribute " + (name == null ? "<null>" : name));
                    }
                    if (name == null) continue;
                    if (flag_raw_mode.getOptionValue() != null) {
                        if (!name.contains(flag_raw_mode.getOptionValue())) continue;
                        attributes.put(name, value);
                        continue;
                    }
                    if (flag_filter_attribute.isSet()) {
                        Matcher m = flag_filter_attribute.getValueAsPattern().matcher(name);
                        if (!m.matches()) continue;
                        attributes.put(name, value);
                        continue;
                    }
                    attributes.put(name, value);
                }
            }
            OutputLine line = new OutputLine(values, attributes);
            output.add(line);
        }
        boolean printHeaderLine = !flag_h.isSet();
        SortSpec[] sortOrder = null;
        sortOrder = flag_sort.isSet() ? flag_sort.getSortOrder() : SortSpec.defaultSortOrder();
        output.printOutput(printHeaderLine, sortOrder);
    }
}

