/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.psvm.cells;

import com.sap.jvm.tools.monitor.psvm.cells.Cell;
import com.sap.jvm.tools.util.HumanReadableHelpers;
import java.util.Date;
import java.util.GregorianCalendar;

public final class TimestampCell
extends Cell<Long> {
    public TimestampCell(Long v) {
        super(v);
    }

    @Override
    protected String getFormattedString(Long v) {
        long timestamp = v;
        String result = "";
        Date date = new Date(timestamp);
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(date);
        int year = cal1.get(1);
        int month = cal1.get(2);
        int day = cal1.get(5);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(new Date());
        if (cal2.get(1) != year) {
            result = Integer.toString(year);
        } else if (cal2.get(2) != month || cal2.get(5) != day) {
            result = HumanReadableHelpers.getThreeLetterMonthName(month + 1) + String.format("%02d", day);
        } else {
            int hour = cal1.get(11);
            int minute = cal1.get(12);
            result = String.format("%02d:%02d", hour, minute);
        }
        return result;
    }
}

