/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.util;

public class HumanReadableHelpers {
    public static String getDurationString(long duration) {
        int d = (int)duration;
        int factor = 86400000;
        int days = d / factor;
        d %= factor;
        int hours = d / (factor /= 24);
        d %= factor;
        int mins = d / (factor /= 60);
        d %= factor;
        int secs = d / (factor /= 60);
        String result = null;
        result = days > 0 ? String.format(" %dd %02d:%02d:%02d", days, hours, mins, secs) : String.format("%02d:%02d:%02d", hours, mins, secs);
        return result;
    }

    public static String getThreeLetterMonthName(int month) {
        switch (month) {
            case 1: {
                return "Jan";
            }
            case 2: {
                return "Feb";
            }
            case 3: {
                return "Mar";
            }
            case 4: {
                return "Apr";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "Jun";
            }
            case 7: {
                return "Jul";
            }
            case 8: {
                return "Aug";
            }
            case 9: {
                return "Sep";
            }
            case 10: {
                return "Oct";
            }
            case 11: {
                return "Nov";
            }
            case 12: {
                return "Dec";
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getHumanReadableDataSize(long size) {
        String result = null;
        long TB = 0x10000000000L;
        long GB = 0x40000000L;
        long MB = 0x100000L;
        long kB = 1024L;
        if (size > 0x10000000000L) {
            double d = (double)size / 1.099511627776E12;
            result = String.format("%.2fT", d);
        } else if (size >= 0x40000000L) {
            double d = (double)size / 1.073741824E9;
            result = String.format("%.2fG", d);
        } else if (size >= 0x100000L) {
            double d = (double)size / 1048576.0;
            result = String.format("%.2fM", d);
        } else if (size >= 1024L) {
            double d = (double)size / 1024.0;
            result = String.format("%.2fk", d);
        } else {
            result = "" + size;
        }
        return result;
    }
}

