/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.cloud;

import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.cloud.HttpClientWrapper;
import com.sap.jvm.util.http.Result;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public abstract class CloudService {
    public static final String PARAMETER_ACCOUNT_NAME = "account";
    public static final String PARAMETER_APPLICATION_NAME = "app";
    public static final String PARAMETER_COMPONENT_NAME = "component";
    public static final String PARAMETER_DATA_NAME = "debugdata";
    public static final String PARAMETER_MORE_DATA_NAME = "moredebugdata";
    public static final String PARAMETER_DATA_COUNTER_NAME = "debugdatacount";
    private HttpClientWrapper httpClientWrapper;
    private final String connectRequest;
    private final String refreshRequest;
    private final String disconnectRequest;
    private Map<String, String> theCookies;
    protected Map<String, String> theParameters;

    public CloudService(HttpClientWrapper httpClientWrapper, String account, String application, String component) {
        this.httpClientWrapper = httpClientWrapper;
        this.connectRequest = "connect";
        this.refreshRequest = "refresh";
        this.disconnectRequest = "disconnect";
        this.theParameters = new HashMap<String, String>();
        this.theParameters.put(PARAMETER_ACCOUNT_NAME, account);
        this.theParameters.put(PARAMETER_APPLICATION_NAME, application);
        this.theParameters.put(PARAMETER_COMPONENT_NAME, component);
        this.theCookies = new HashMap<String, String>();
    }

    @Deprecated
    public CloudService(HttpClientWrapper httpClientWrapper, String account, String application, String component, String connectRequest, String refreshRequest, String disconnectRequest) {
        this.httpClientWrapper = httpClientWrapper;
        this.connectRequest = connectRequest;
        this.refreshRequest = refreshRequest;
        this.disconnectRequest = disconnectRequest;
        this.theParameters = new HashMap<String, String>();
        this.theParameters.put(PARAMETER_ACCOUNT_NAME, account);
        this.theParameters.put(PARAMETER_APPLICATION_NAME, application);
        this.theParameters.put(PARAMETER_COMPONENT_NAME, component);
        this.theCookies = new HashMap<String, String>();
    }

    private synchronized void addCookies(Map<String, String> toBeAdded) {
        if (toBeAdded != null) {
            for (String key : toBeAdded.keySet()) {
                this.theCookies.put(key, toBeAdded.get(key));
            }
        }
    }

    private boolean isUsingDebuggingAccount() {
        return "wa89057c4".equals(this.theParameters.get(PARAMETER_ACCOUNT_NAME));
    }

    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.theParameters);
    }

    public Result start() throws IOException, URISyntaxException {
        Result ret = this.httpClientWrapper.callService("start", null, this.theParameters, this.theCookies);
        this.addCookies(ret.getCookies());
        return ret;
    }

    public Result connect() throws IOException, URISyntaxException {
        return this.connect(null);
    }

    public Result connect(Map<String, String> headers) throws IOException, URISyntaxException {
        Result ret = this.httpClientWrapper.callService(this.connectRequest, headers, this.theParameters, this.theCookies);
        this.addCookies(ret.getCookies());
        return ret;
    }

    public Result disconnect() throws IOException, URISyntaxException {
        return this.disconnect(null);
    }

    public Result disconnect(Map<String, String> headers) throws IOException, URISyntaxException {
        return this.httpClientWrapper.callService(this.disconnectRequest, headers, this.theParameters, this.theCookies);
    }

    public Result stop() throws IOException, URISyntaxException {
        return this.stop(null);
    }

    public Result stop(Map<String, String> headers) throws IOException, URISyntaxException {
        if (this.theCookies != null && this.isUsingDebuggingAccount()) {
            String bigIpCookieName = null;
            for (String name : this.theCookies.keySet()) {
                if (!name.startsWith("BIGipServer") || !name.endsWith("neo.ondemand.com")) continue;
                bigIpCookieName = name;
                break;
            }
            HashMap<String, String> cookiesToBeUsed = null;
            if (bigIpCookieName != null) {
                cookiesToBeUsed = new HashMap<String, String>(1);
                String bigIpCookie = (String)cookiesToBeUsed.get(bigIpCookieName);
                cookiesToBeUsed.put(bigIpCookieName, bigIpCookie);
            }
            return this.httpClientWrapper.callService("stop", headers, this.theParameters, cookiesToBeUsed);
        }
        return this.httpClientWrapper.callService("stop", headers, this.theParameters, this.theCookies);
    }

    public void getNextPackages(BlockingQueue<byte[]> input, Map<String, String> parameters, Tracer tracer, int pollPeriod) throws URISyntaxException, IOException {
        this.httpClientWrapper.getNextByteArray(input, parameters, this.refreshRequest, tracer, pollPeriod, this.theCookies);
    }

    public String encode(byte[] toEncode) throws UnsupportedEncodingException {
        return this.httpClientWrapper.encode(toEncode);
    }
}

