/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.cloud;

import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.http.Result;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public abstract class HttpClientWrapper {
    protected static final String CHARSET = "UTF-8";
    protected static final boolean USE_HTTP_GET_DEFAULT = Boolean.parseBoolean(System.getProperty("com.sap.jvm.debugging.impl.cloudhelper.usehttpget", "false"));
    protected boolean useHttpGet = USE_HTTP_GET_DEFAULT;
    protected Base64.Encoder base64Encoder = Base64.getEncoder();
    protected static Tracer tracer = Trace.get((String)"com.sap.jvm.util.cloud.HttpClientWrapper");
    protected String serviceHost;
    protected String userName;
    protected String pwd;
    protected Proxy proxy;

    public boolean isUseHttpGet() {
        return this.useHttpGet;
    }

    public void setUseHttpGet(boolean useHttpGet) {
        this.useHttpGet = useHttpGet;
    }

    protected static String concatUrlAndParameters(String urlString, Map<String, String> parameters) {
        return urlString + "?" + HttpClientWrapper.concatHttpParameters(parameters);
    }

    protected static String concatHttpParameters(Map<String, String> parameters) {
        StringBuilder url = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = parameters.entrySet().iterator();
        boolean firstArgument = true;
        while (iter.hasNext()) {
            if (firstArgument) {
                firstArgument = false;
            } else {
                url.append("&");
            }
            Map.Entry<String, String> elem = iter.next();
            url.append(elem.getKey());
            url.append("=");
            url.append(elem.getValue());
        }
        return url.toString();
    }

    protected static void parseAndAddCookie(String cookieString, Map<String, String> cookieList) {
        String cookie = cookieString.substring(0, cookieString.indexOf(";"));
        int posOfEqual = cookie.indexOf("=");
        if (posOfEqual > 0) {
            cookieList.put(cookie.substring(0, posOfEqual), cookie.substring(posOfEqual + 1, cookie.length()));
        }
    }

    protected static void dumpCookies(String Prefix, Map<String, String> cookieList) {
        if (tracer.getTraceLevel().debug()) {
            tracer.debug(() -> Prefix + " " + cookieList.size() + " cookies");
            for (String name : cookieList.keySet()) {
                tracer.debug(() -> "    Name=" + name + "    Value=" + (String)cookieList.get(name));
            }
        }
    }

    public HttpClientWrapper(String serviceHost, String userName, String pwd, Proxy proxy) {
        this.serviceHost = serviceHost;
        this.userName = userName;
        this.pwd = pwd;
        this.proxy = proxy;
    }

    public abstract Result callService(String var1, Map<String, String> var2, Map<String, String> var3, Map<String, String> var4) throws URISyntaxException, IOException;

    public abstract void getNextByteArray(BlockingQueue<byte[]> var1, Map<String, String> var2, String var3, Tracer var4, int var5, Map<String, String> var6) throws URISyntaxException, IOException;

    public abstract String encode(byte[] var1) throws UnsupportedEncodingException;
}

