/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.cloud;

import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.cloud.HttpClientWrapper;
import com.sap.jvm.util.http.Result;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public class HttpClientWrapperJDK
extends HttpClientWrapper {
    private static Map<String, String> getCookies(HttpURLConnection connection) {
        HashMap<String, String> cookieList = new HashMap<String, String>();
        String headerName = null;
        int i = 1;
        while ((headerName = connection.getHeaderFieldKey(i)) != null) {
            if (headerName.equals("Set-Cookie")) {
                HttpClientWrapperJDK.parseAndAddCookie(connection.getHeaderField(i), cookieList);
            }
            ++i;
        }
        HttpClientWrapperJDK.dumpCookies("  GOT  ", cookieList);
        return cookieList;
    }

    private static void addCookies(HttpURLConnection connection, Map<String, String> theCookies) {
        String cookieList = "";
        if (theCookies != null) {
            for (String entry : theCookies.keySet()) {
                cookieList = cookieList + entry + "=" + theCookies.get(entry) + " ; ";
            }
        }
        if (cookieList.length() > 0) {
            String cookieListForTrace = cookieList;
            tracer.debug(() -> "  Add cookie to request to   " + cookieListForTrace);
            connection.setRequestProperty("Cookie", cookieList);
        }
    }

    private static void setRequestProperties(Map<String, String> requestProperties, HttpURLConnection conn) {
        for (Map.Entry<String, String> elem : requestProperties.entrySet()) {
            conn.setRequestProperty(elem.getKey(), elem.getValue());
        }
    }

    public HttpClientWrapperJDK(String serviceHost, String userName, String pwd, Proxy proxy) {
        super(serviceHost, userName, pwd, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result callService(String service, Map<String, String> headers, Map<String, String> parameters, Map<String, String> cookies) throws URISyntaxException, IOException {
        HttpURLConnection conn;
        tracer.debug(() -> "Going to execute " + service);
        String serviceUrl = this.serviceHost.endsWith("/") ? this.serviceHost + service : this.serviceHost + "/" + service;
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        if (this.userName != null && this.pwd != null) {
            String loginData = this.userName + ":" + this.pwd;
            String encodedLogin = this.base64Encoder.encodeToString(loginData.getBytes());
            requestProperties.put("Authorization", "Basic " + encodedLogin);
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                requestProperties.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.useHttpGet) {
            conn = (HttpURLConnection)new URL(HttpClientWrapperJDK.concatUrlAndParameters(serviceUrl.toString(), parameters)).openConnection(this.proxy);
            HttpClientWrapperJDK.addCookies(conn, cookies);
            HttpClientWrapperJDK.setRequestProperties(requestProperties, conn);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        } else {
            conn = (HttpURLConnection)new URL(serviceUrl.toString()).openConnection(this.proxy);
            HttpClientWrapperJDK.addCookies(conn, cookies);
            conn.setRequestMethod("POST");
            HttpClientWrapperJDK.setRequestProperties(requestProperties, conn);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            String body = HttpClientWrapperJDK.concatHttpParameters(parameters);
            conn.setRequestProperty("Content-Length", String.valueOf(body.length()));
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(body);
            writer.flush();
            writer.close();
        }
        conn.connect();
        try {
            int httpReturnCode = conn.getResponseCode();
            if (httpReturnCode < 200 || httpReturnCode >= 300) {
                switch (httpReturnCode) {
                    case 401: {
                        throw new IOException("Server returned " + httpReturnCode + " (Unauthorized) for URL: " + conn.getURL() + "\n\nIt seems you don't have the neccessary permission to debug/profile in this account.");
                    }
                    case 404: {
                        throw new IOException("Server returned " + httpReturnCode + " (Not Found) for URL: " + conn.getURL() + "\n\nIt seems the account or application you are trying to connect to does not exist.");
                    }
                    case 409: {
                        throw new IOException("Server returned " + httpReturnCode + " (Conflict) for URL: " + conn.getURL() + "\n\nAnother debugging/profiling session to this application seems to be active.");
                    }
                }
                throw new IOException("Server returned " + httpReturnCode + " for URL: " + conn.getURL() + "\n\nIf this situation persists, contact your cloud operator.");
            }
            String majorVersion = conn.getHeaderField("Debugging-Backend-Major-Version");
            String minorVersion = conn.getHeaderField("Debugging-Backend-Minor-Version");
            int majorServerVersion = -1;
            int minorServerVersion = -1;
            if (majorVersion != null && minorVersion != null) {
                try {
                    majorServerVersion = Integer.parseInt(majorVersion);
                    minorServerVersion = Integer.parseInt(minorVersion);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Illegal version headers: major='" + majorVersion + "', minor='" + minorVersion + "'", e);
                }
            }
            Result result = new Result(majorServerVersion, minorServerVersion, HttpClientWrapperJDK.getCookies(conn));
            return result;
        }
        finally {
            conn.disconnect();
        }
    }

    @Override
    public void getNextByteArray(BlockingQueue<byte[]> input, Map<String, String> parameterMap, String service, Tracer tracer, int POLL_PERIOD_MS, Map<String, String> cookies) throws URISyntaxException, IOException {
        int count;
        HttpURLConnection connection;
        block6: {
            tracer.debug(() -> "Going to execute " + service);
            String loginData = this.userName + ":" + this.pwd;
            String encodedLogin = this.base64Encoder.encodeToString(loginData.getBytes());
            URL url = new URL(this.serviceHost + "/" + service);
            connection = null;
            int retries = 0;
            while (true) {
                if (this.useHttpGet) {
                    URL urlToOpen = new URL(HttpClientWrapperJDK.concatUrlAndParameters(url.toString(), parameterMap));
                    connection = (HttpURLConnection)urlToOpen.openConnection(this.proxy);
                    HttpClientWrapperJDK.addCookies(connection, cookies);
                    connection.setRequestProperty("Authorization", "Basic " + encodedLogin);
                    connection.setDoOutput(true);
                    connection.setUseCaches(false);
                    connection.setRequestProperty("Accept-Charset", "UTF-8");
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                } else {
                    connection = (HttpURLConnection)url.openConnection(this.proxy);
                    HttpClientWrapperJDK.addCookies(connection, cookies);
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Authorization", "Basic " + encodedLogin);
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    connection.setUseCaches(false);
                    connection.setRequestProperty("Accept-Charset", "UTF-8");
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                    String body = HttpClientWrapperJDK.concatHttpParameters(parameterMap);
                    connection.setRequestProperty("Content-Length", String.valueOf(body.length()));
                    OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
                    writer.write(body);
                    writer.flush();
                    writer.close();
                }
                connection.connect();
                ++retries;
                int responseCode = connection.getResponseCode();
                if (responseCode != 503) break block6;
                if (retries >= 10) break;
                tracer.debug("Debugging service unavailable => Retrying...");
                connection.disconnect();
                try {
                    Thread.sleep(POLL_PERIOD_MS);
                }
                catch (InterruptedException writer) {}
            }
            tracer.warn("Debugging service unavailable => Giving up...");
        }
        BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
        byte[] buffer = new byte[32768];
        while ((count = ((InputStream)inputStream).read(buffer)) != -1) {
            byte[] inputBytes = new byte[count];
            System.arraycopy(buffer, 0, inputBytes, 0, count);
            input.add(inputBytes);
        }
        HttpClientWrapperJDK.getCookies(connection);
        connection.disconnect();
    }

    @Override
    public String encode(byte[] toEncode) throws UnsupportedEncodingException {
        return URLEncoder.encode(this.base64Encoder.encodeToString(toEncode), "UTF-8");
    }
}

