/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PrefixedInputStream
extends FilterInputStream {
    private final byte[] prefix;
    private int offset = 0;

    public PrefixedInputStream(InputStream in, byte[] prefixToBeUsed) {
        super(in);
        this.prefix = prefixToBeUsed;
    }

    @Override
    public int read() throws IOException {
        if (this.offset < this.prefix.length) {
            return this.prefix[this.offset++];
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.offset < this.prefix.length) {
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            return 1;
        }
        return super.read(b, off, len);
    }
}

