/*
 * Decompiled with CFR 0.152.
 */
package com.sap.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterName;

public class PrintServices {
    private static final String SUN_PRINT_IPP_PRINTSERVICE = "sun.print.IPPPrintService";
    private static final String SUN_PRINT_RASTER_PRINTER_JOB = "sun.print.RasterPrinterJob";
    private static final String JAVAX_PRINT_DEFAULT_PRINTER = "javax.print.defaultPrinter";
    private static final String COM_SAP_PRINT_NULL_PRINT_SERVICE_LOOKUP = "com.sap.print.NullPrintServiceLookup";
    private static final String JAVAX_PRINT_PRINT_SERVICE_LOOKUP = "javax.print.PrintServiceLookup";
    private static final String SUN_PRINT_CUPSPRINTER = "sun.print.CUPSPrinter";
    private static final String SUN_PRINT_UNIX_PRINT_SERVICE_LOOKUP = "sun.print.UnixPrintServiceLookup";
    private static final String UNKNOWN = "unknown";
    private static final String UNDEFINED = "undefined";
    private static final String NOT_FOUND = "not found";
    private static final String PRINTING_NOT_SUPPORTED = "\nThis vm does not support printing!";
    private static final String USE_OPTION_F_TO_FORCE_DIAGNOSIS = "Use option -f to force diagnosis.";
    private static final String NOT_A_SAP_VM = "The virtual machine is not identified as a SAP Java(TM) virtual machine.";
    private static final String PRINT_SYSTEM_UNKNOWN = "unable to detect";
    private static final String PRINT_SYSTEM_SYSV = "SysV";
    private static final String PRINT_SYSTEM_BSD = "BSD";
    private static final String PRINT_SYSTEM_CUPS = "CUPS";
    private static final String SAP_PRINTING_TEST = "SAP Printing Test";
    private static final String SENDING_DOCUMENT = "Sending document to print service ";
    private static final String NO_PRINT_SERVICE_AVAILABLE = "Print service not available!";
    private static final String HEADER_PRINTING = "SAP Java(TM) Virtual Machine Printing Test";
    private static final String HEADER_DIAGNOSIS = "SAP Java(TM) Virtual Machine Printing Diagnosis:";
    private static final String OS = "OS";
    private static final String HOST = "Host";
    private static final String DATE_OF_TEST = "Date of test";
    private static final String USER = "User";
    private static final String PRINT_SERVICE = "Print service";
    private static final String DESCR_VM_VENDOR = "VM vendor";
    private static final String DESCR_VM_VERSION = "VM version";
    private static final String DESCR_VM_NAME = "VM name";
    private static final String COLON = ": ";
    private static final String REMARK_DEFAULT = " (default)";
    private static final String UNDERLINE = "-";
    private static final String NO_SERVICES_FOUND = "No services found!";
    private static final String DEFAULT_PRINTSERVICE = "Default: %1";
    private static final String LIST_OF_ALL_PRINTER_SERVICES = "List of all printer services: ";
    private static final String LOOKUP_CLASS = "Lookup class";
    private static final String PORT = "Port";
    private static final String SERVER = "Server";
    private static final String PRINTING_SYSTEM = "Printing system";
    private static final String DESC_HOSTNAME = "Hostname";
    private static final String USAGE = "Usage: printdiag [-options]\n\nwhere options include:";
    private static final String HELP_INTRO_1 = "printdiag is a support tool to identify the used printing system, all available printing";
    private static final String HELP_INTRO_2 = "services and the default printing service. It can create a test print job";
    private static final String HELP_INTRO_3 = "while tracing detailed technical information.";
    private static final String ILLEGAL_ARGUMENT_USE_H_FOR_HELP = "Illegal argument. Use -h for help.";
    private static final String DOCUMENT_COVERAGE = "This document spans a  %1  page printout of all available fonts.";
    private static final String FORCE = "-f";
    private static final String SHOW_HELP0 = "-?";
    private static final String SHOW_HELP1 = "-h";
    private static final String SHOW_HELP2 = "--help";
    private static final String VERBOSE = "-v";
    private static final String SHOW_DEFAULT_SERVICE = "-d";
    private static final String SHOW_PRINTING_SYSTEM = "-sys";
    private static final String LIST_ALL_SERVICES = "-srv";
    private static final String COMPLETE_REPORT = "-all";
    private static final String TEST_PRINT = "-p";
    private static final String NAME_OPTION = "-n";
    private static final String NAME_OPTION_EXAMPLE = "\"<print service name>\"";
    private static final String SERVICE_NAME = "-n\"<print service name>\"";
    private static final int WAITFOR_JOB_SECONDS = 10;
    private static final List<String> SUPPORTED_ARGS = new ArrayList<String>();
    private static final List<Option> SUPPORTED_OPTIONS = new ArrayList<Option>();
    private static String requestedPrintServive = null;
    private static final Option CMD_FORCE = new Option("-f", "run diagnosis, even if this is not a SAP Java(TM) virtual machine");
    private static final Option CMD_VERBOSE = new Option("-v", "show detailed trace information");
    private static final Option CMD_HELP0 = new Option("-?", "show help message");
    private static final Option CMD_HELP1 = new Option("-h", "show help message");
    private static final Option CMD_HELP2 = new Option("--help", "show help message");
    private static final Option CMD_DEFAULT = new Option("-d", "show the default print service");
    private static final Option CMD_SYSTEM = new Option("-sys", "show the printing system");
    private static final Option CMD_ALL_SERVICES = new Option("-srv", "show all print services");
    private static final Option CMD_COMPLETE_REPORT = new Option("-all", "show a complete diagnostic report (default)");
    private static final Option CMD_TEST_PRINT = new Option("-p", "send a test document to the default print service\n\t\tsee also option -n to specify a specific print service");
    private static final Option CMD_SERVICE_NAME = new Option("-n\"<print service name>\"", "use the named print service instead of the default");
    private static final String VM_USER;
    private static final String VM_NAME;
    private static final String VM_VENDOR;
    private static final String JAVA_VERSION;
    private static final String OSNAME;
    private static final String OSARCH;
    private static final String OSVERS;
    private static final String EXT_DEFAULT;

    public static void main(String[] args) throws Exception {
        PrintStream out = System.out;
        List<String> argList = PrintServices.preProcessArguments(args, out);
        if (argList.contains(SHOW_HELP0) || argList.contains(SHOW_HELP1) || argList.contains(SHOW_HELP2)) {
            PrintServices.printHelp(out);
            System.exit(0);
        }
        boolean isTraceEnabled = argList.contains(VERBOSE);
        PrintServices.setTracing(SUN_PRINT_UNIX_PRINT_SERVICE_LOOKUP, "isCommandTraceEnabled", isTraceEnabled);
        PrintServices.setTracing(SUN_PRINT_RASTER_PRINTER_JOB, "debugPrint", isTraceEnabled);
        PrintServices.setTracing(SUN_PRINT_IPP_PRINTSERVICE, "debugPrint", isTraceEnabled);
        if (VM_VENDOR.indexOf("SAP") != -1 || argList.contains(FORCE)) {
            if (PrintServices.getPrintServiceLookup().equals(COM_SAP_PRINT_NULL_PRINT_SERVICE_LOOKUP)) {
                PrintServices.printDiagnosticHeader(argList, out);
                out.println(PRINTING_NOT_SUPPORTED);
                System.exit(0);
            }
            if (argList.contains(COMPLETE_REPORT)) {
                PrintServices.genCompleteReport(argList, out);
                System.exit(0);
            }
            if (argList.contains(SHOW_PRINTING_SYSTEM)) {
                if (!PrintServices.isWindows()) {
                    out.println(PrintServices.getPrintingSystem());
                } else {
                    out.println("Windows");
                }
            }
            if (argList.contains(SHOW_DEFAULT_SERVICE)) {
                PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
                String pService = defaultPrintService == null ? UNKNOWN : defaultPrintService.getName();
                out.println(pService);
            }
            if (argList.contains(LIST_ALL_SERVICES)) {
                PrintService[] allServices = PrintServiceLookup.lookupPrintServices(null, null);
                if (allServices != null) {
                    for (int i = 0; i < allServices.length; ++i) {
                        out.println(allServices[i].getName());
                    }
                } else {
                    out.println("No print services found!");
                }
            }
            if (argList.contains(TEST_PRINT)) {
                PrintServices.setTracing(SUN_PRINT_RASTER_PRINTER_JOB, "debugPrint", true);
                new Print2DPrinterJob().testPrint(argList, out);
                out.println("Intentionally waiting for 10 seconds ...");
                Thread.sleep(10000L);
            }
        } else {
            out.println(NOT_A_SAP_VM);
            out.println(USE_OPTION_F_TO_FORCE_DIAGNOSIS);
        }
    }

    private static boolean isWindows() {
        return OSNAME.toLowerCase().indexOf("windows") != -1;
    }

    private static boolean setTracing(String className, String fieldName, boolean value) {
        boolean result = false;
        Class<?> clazz = PrintServices.classForName(className);
        if (clazz != null) {
            try {
                Field field = null;
                Field[] fields = clazz.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].getName().equals(fieldName)) continue;
                    field = fields[i];
                }
                if (field != null) {
                    field.setAccessible(true);
                    field.set(null, value);
                }
                result = true;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                result = false;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                result = false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    private static void genCompleteReport(List<String> argList, PrintStream ps) {
        PrintServices.printDiagnosticHeader(argList, ps);
        String pSystem = PrintServices.getPrintingSystem();
        ps.print("Printing system\t: ");
        if (!PrintServices.isWindows()) {
            ps.println(pSystem);
            CUPSDescriptor cups = PrintServices.getCups();
            if (!cups.cups.equals(PRINT_SYSTEM_UNKNOWN)) {
                ps.println("Server\t\t: " + cups.server);
                ps.println("Port\t\t: " + cups.port);
            }
        } else {
            ps.println("Windows");
        }
        String printServiceLookUp = PrintServices.getPrintServiceLookup();
        ps.println("Lookup class\t: " + printServiceLookUp);
        if (!UNDEFINED.equals(EXT_DEFAULT)) {
            ps.println("\njavax.print.defaultPrinter\t: " + EXT_DEFAULT);
        }
        PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService[] allServices = PrintServiceLookup.lookupPrintServices(null, null);
        ps.println();
        ps.println(LIST_OF_ALL_PRINTER_SERVICES);
        for (int i = 0; i < LIST_OF_ALL_PRINTER_SERVICES.length(); ++i) {
            ps.print(UNDERLINE);
        }
        ps.println();
        String pService = defaultPrintService == null ? NOT_FOUND : defaultPrintService.getName();
        ps.println();
        ps.println(DEFAULT_PRINTSERVICE.replaceFirst("%1", pService));
        ps.println();
        if (allServices != null) {
            for (int i = 0; i < allServices.length; ++i) {
                PrintServiceAttributeSet psa = allServices[i].getAttributes();
                String defString = pService.equals(allServices[i].getName()) ? REMARK_DEFAULT : "";
                ps.println(allServices[i].getName() + defString);
                Attribute[] attributes = psa.toArray();
                for (int j = 0; j < attributes.length; ++j) {
                    if (attributes[j].getCategory() == PrinterName.class) continue;
                    ps.println(attributes[j].getName() + COLON + psa.get(attributes[j].getCategory()));
                }
                ps.println();
            }
        } else {
            ps.println(NO_SERVICES_FOUND);
        }
    }

    private static void printDiagnosticHeader(List<String> argList, PrintStream ps) {
        String[] head = PrintServices.getDiagnosticHeader(argList, false);
        for (int i = 0; i < head.length; ++i) {
            ps.println(head[i]);
        }
    }

    private static String[] getDiagnosticHeader(List<String> argList, boolean shortForm) {
        ArrayList<String> ps = new ArrayList<String>();
        if (!shortForm) {
            ps.add("\nSAP Java(TM) Virtual Machine Printing Diagnosis:");
            String underline = "";
            for (int i = 0; i < HEADER_DIAGNOSIS.length(); ++i) {
                underline = underline + UNDERLINE;
            }
            ps.add(underline + "\n");
        }
        ps.add("VM name\t\t: " + VM_NAME);
        ps.add("VM version\t: " + JAVA_VERSION);
        if (argList.contains(FORCE)) {
            ps.add("VM vendor\t: " + VM_VENDOR);
        }
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (hostName != null) {
            ps.add("Hostname \t: " + hostName);
        }
        ps.add("OS \t\t: " + OSNAME + " " + OSVERS + " " + OSARCH);
        ps.add("User \t\t: " + VM_USER + "\n");
        return ps.toArray(new String[ps.size()]);
    }

    private static List<String> preProcessArguments(String[] args, PrintStream ps) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(SERVICE_NAME)) {
                args[i] = args[i].replaceFirst(NAME_OPTION_EXAMPLE, "");
            }
            if (!args[i].startsWith(NAME_OPTION)) continue;
            requestedPrintServive = args[i];
            requestedPrintServive = requestedPrintServive.replaceFirst(NAME_OPTION, "");
            args[i] = SERVICE_NAME;
            break;
        }
        ArrayList<String> argList = new ArrayList<String>();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                argList.add(args[i].toLowerCase());
            }
            if (!SUPPORTED_ARGS.containsAll(argList)) {
                ps.println(ILLEGAL_ARGUMENT_USE_H_FOR_HELP);
                System.exit(1);
            }
        }
        if (argList.contains(SHOW_HELP0)) {
            argList.clear();
            argList.add(SHOW_HELP0);
        } else if (argList.contains(SHOW_HELP1)) {
            argList.clear();
            argList.add(SHOW_HELP1);
        } else if (argList.contains(SHOW_HELP2)) {
            argList.clear();
            argList.add(SHOW_HELP2);
        } else {
            int optionCount = argList.size();
            if (argList.contains(FORCE)) {
                --optionCount;
            }
            if (argList.contains(VERBOSE)) {
                --optionCount;
            }
            if (argList.contains(SERVICE_NAME)) {
                if (!argList.contains(TEST_PRINT)) {
                    argList.add(TEST_PRINT);
                    --optionCount;
                }
                --optionCount;
            }
            if (optionCount == 0) {
                argList.add(COMPLETE_REPORT);
            }
        }
        return argList;
    }

    private static void printHelp(PrintStream ps) {
        ps.println(HELP_INTRO_1);
        ps.println(HELP_INTRO_2);
        ps.println(HELP_INTRO_3);
        ps.println();
        ps.println(USAGE);
        ps.println();
        for (Option option : SUPPORTED_OPTIONS) {
            ps.println("\t" + option.cmd + "\n\t\t" + option.description + "\n");
        }
    }

    private static CUPSDescriptor getCups() {
        Object returnValue;
        CUPSDescriptor result = new CUPSDescriptor();
        Method isCupsRunnning = null;
        Method getServer = null;
        Method getPort = null;
        try {
            isCupsRunnning = Class.forName(SUN_PRINT_CUPSPRINTER).getMethod("isCupsRunning", null);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (isCupsRunnning != null) {
            try {
                boolean isCupsRunning;
                returnValue = isCupsRunnning.invoke(null, (Object[])null);
                if (returnValue instanceof Boolean && (isCupsRunning = ((Boolean)returnValue).booleanValue())) {
                    result.cups = PRINT_SYSTEM_CUPS;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        try {
            getServer = Class.forName(SUN_PRINT_CUPSPRINTER).getMethod("getServer", null);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (getServer != null) {
            try {
                returnValue = getServer.invoke(null, (Object[])null);
                if (returnValue instanceof String) {
                    result.server = (String)returnValue;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        try {
            getPort = Class.forName(SUN_PRINT_CUPSPRINTER).getMethod("getPort", null);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (getPort != null) {
            try {
                returnValue = getPort.invoke(null, (Object[])null);
                if (returnValue instanceof Integer) {
                    result.port = (Integer)returnValue;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static String getPrintServiceLookup() {
        String result = UNKNOWN;
        Class<?> clazz = PrintServices.classForName(JAVAX_PRINT_PRINT_SERVICE_LOOKUP);
        if (clazz != null) {
            Method getAllLookupServices = null;
            Method[] allMethods = clazz.getDeclaredMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                if (!allMethods[i].getName().equals("getAllLookupServices")) continue;
                getAllLookupServices = allMethods[i];
                getAllLookupServices.setAccessible(true);
                break;
            }
            if (getAllLookupServices != null) {
                Object returnValue = null;
                try {
                    returnValue = getAllLookupServices.invoke(null, (Object[])null);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
                if (returnValue instanceof ArrayList) {
                    String allNames = "";
                    String separator = "";
                    ArrayList allLookUpServices = (ArrayList)returnValue;
                    Iterator psIterator = allLookUpServices.iterator();
                    while (psIterator.hasNext()) {
                        try {
                            PrintServiceLookup lus = (PrintServiceLookup)psIterator.next();
                            allNames = allNames + separator + lus.getClass().getName();
                            separator = ",";
                            PrintService service = lus.getDefaultPrintService();
                            if (service == null) continue;
                            result = lus.getClass().getName();
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                    if (result.equals(UNKNOWN)) {
                        result = allNames;
                    }
                }
            }
        }
        return result;
    }

    private static String getPrintingSystem() {
        Class<?> clazz;
        String result = PrintServices.getCups().cups;
        if (result.equals(PRINT_SYSTEM_UNKNOWN) && (clazz = PrintServices.classForName(SUN_PRINT_UNIX_PRINT_SERVICE_LOOKUP)) != null) {
            Method isSysVMethod = null;
            Method[] allMethods = clazz.getDeclaredMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                if (!allMethods[i].getName().equals("isSysV")) continue;
                isSysVMethod = allMethods[i];
                isSysVMethod.setAccessible(true);
                break;
            }
            if (isSysVMethod != null) {
                try {
                    Object returnValue = isSysVMethod.invoke(null, (Object[])null);
                    if (returnValue instanceof Boolean) {
                        boolean isSysV = (Boolean)returnValue;
                        result = isSysV ? PRINT_SYSTEM_SYSV : PRINT_SYSTEM_BSD;
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private static Class<?> classForName(String className) {
        Class<?> result = null;
        ClassLoader loader = PrintServices.class.getClassLoader();
        try {
            result = Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    static {
        SUPPORTED_OPTIONS.add(CMD_COMPLETE_REPORT);
        SUPPORTED_OPTIONS.add(CMD_VERBOSE);
        SUPPORTED_OPTIONS.add(CMD_FORCE);
        SUPPORTED_OPTIONS.add(CMD_HELP0);
        SUPPORTED_OPTIONS.add(CMD_HELP1);
        SUPPORTED_OPTIONS.add(CMD_HELP2);
        SUPPORTED_OPTIONS.add(CMD_SYSTEM);
        SUPPORTED_OPTIONS.add(CMD_DEFAULT);
        SUPPORTED_OPTIONS.add(CMD_ALL_SERVICES);
        SUPPORTED_OPTIONS.add(CMD_TEST_PRINT);
        SUPPORTED_OPTIONS.add(CMD_SERVICE_NAME);
        for (Option option : SUPPORTED_OPTIONS) {
            SUPPORTED_ARGS.add(option.cmd);
        }
        VM_USER = System.getProperties().getProperty("user.name", UNKNOWN);
        VM_NAME = System.getProperties().getProperty("java.vm.name", UNKNOWN);
        VM_VENDOR = System.getProperties().getProperty("java.vm.vendor", UNKNOWN);
        JAVA_VERSION = System.getProperties().getProperty("java.vm.version", UNKNOWN);
        OSNAME = System.getProperties().getProperty("os.name", UNKNOWN);
        OSARCH = System.getProperties().getProperty("os.arch", UNKNOWN);
        OSVERS = System.getProperties().getProperty("os.version", UNKNOWN);
        EXT_DEFAULT = System.getProperties().getProperty(JAVAX_PRINT_DEFAULT_PRINTER, UNDEFINED);
    }

    private static class Print2DPrinterJob
    implements Printable {
        private PrintService pService = null;
        int[] pageBreaks;
        String[] textLines;
        Font[] fonts;

        public void testPrint(List<String> argList, PrintStream ps) {
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            aset.add(OrientationRequested.PORTRAIT);
            aset.add(MediaSizeName.ISO_A4);
            aset.add(new Copies(1));
            aset.add(new JobName(PrintServices.SAP_PRINTING_TEST, null));
            aset.add(Finishings.STAPLE);
            if (argList.contains(PrintServices.SERVICE_NAME)) {
                PrintService[] pServices = PrintServiceLookup.lookupPrintServices(null, null);
                for (int i = 0; i < pServices.length; ++i) {
                    if (!pServices[i].getName().equals(requestedPrintServive)) continue;
                    this.pService = pServices[i];
                    break;
                }
            } else {
                this.pService = PrintServiceLookup.lookupDefaultPrintService();
            }
            if (this.pService != null) {
                ps.println(PrintServices.SENDING_DOCUMENT + this.pService.getName());
                try {
                    PrinterJob pj = PrinterJob.getPrinterJob();
                    pj.setPrintable(this);
                    pj.setPrintService(this.pService);
                    pj.print(aset);
                }
                catch (PrinterException pe) {
                    System.err.println(pe);
                }
            } else {
                ps.println(PrintServices.NO_PRINT_SERVICE_AVAILABLE);
            }
        }

        private void initTextLines() {
            if (this.textLines == null) {
                this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                int numLines = this.fonts.length;
                this.textLines = new String[numLines];
                for (int i = 0; i < this.fonts.length; ++i) {
                    this.textLines[i] = this.fonts[i].getFontName() + ", " + this.fonts[i].getFamily();
                }
            }
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            int cx = 10;
            Font readableFont = new Font("Lucida", 0, 10);
            FontMetrics readableMetrics = g.getFontMetrics(readableFont);
            int lineHeight = readableMetrics.getHeight();
            if (this.pageBreaks == null) {
                this.initFontListing(pf, lineHeight);
            }
            if (pageIndex == 0) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                g2d.setColor(Color.BLUE);
                int cy = 50;
                Font df = readableFont.deriveFont(1, 20.0f);
                g2d.setFont(df);
                g2d.drawString(PrintServices.HEADER_PRINTING, cx, cy);
                df = readableFont.deriveFont(0, 12.0f);
                g2d.setFont(df);
                g2d.setColor(Color.BLACK);
                int ctab = 100;
                readableMetrics = g.getFontMetrics(readableFont);
                lineHeight = readableMetrics.getHeight();
                g2d.drawString(PrintServices.DESCR_VM_NAME, cx, cy += 50);
                g2d.drawString(PrintServices.COLON + VM_NAME, ctab, cy);
                g2d.drawString(PrintServices.DESCR_VM_VERSION, cx, cy += lineHeight);
                g2d.drawString(PrintServices.COLON + JAVA_VERSION, ctab, cy);
                g2d.drawString(PrintServices.DESCR_VM_VENDOR, cx, cy += lineHeight);
                g2d.drawString(PrintServices.COLON + VM_VENDOR, ctab, cy);
                cy += lineHeight;
                String hostName = null;
                try {
                    hostName = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                g2d.drawString(PrintServices.OS, cx, cy);
                g2d.drawString(PrintServices.COLON + OSNAME + " " + OSVERS + " " + OSARCH, ctab, cy);
                g2d.drawString(PrintServices.HOST, cx, cy += lineHeight);
                g2d.drawString(PrintServices.COLON + hostName, ctab, cy);
                cy += lineHeight;
                if (this.pService != null) {
                    g2d.drawString(PrintServices.PRINT_SERVICE, cx, cy);
                    g2d.drawString(PrintServices.COLON + this.pService.getName(), ctab, cy);
                    cy += lineHeight;
                    cy += lineHeight;
                }
                g2d.drawString(PrintServices.USER, cx, cy);
                g2d.drawString(PrintServices.COLON + VM_USER, ctab, cy);
                g2d.drawString(PrintServices.DATE_OF_TEST, cx, cy += lineHeight);
                g2d.drawString(PrintServices.COLON + new Date().toString(), ctab, cy);
                g2d.drawString(PrintServices.DOCUMENT_COVERAGE.replaceFirst("%1", Integer.toString(this.pageBreaks.length + 1)), cx, cy += lineHeight * 8);
                return 0;
            }
            int fontPageIndex = pageIndex - 1;
            if (fontPageIndex > this.pageBreaks.length) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            int y = 10;
            int start = fontPageIndex == 0 ? 0 : this.pageBreaks[fontPageIndex - 1];
            int end = fontPageIndex == this.pageBreaks.length ? this.textLines.length : this.pageBreaks[fontPageIndex];
            y = this.printCentered(pf, readableFont, readableMetrics, lineHeight, g2d, y, PrintServices.HEADER_PRINTING);
            for (int line = start; line < end; ++line) {
                String logicalName = "\"" + this.fonts[line].getName() + "\": ";
                g2d.setFont(readableFont);
                g.drawString(logicalName, cx, y += lineHeight);
                Font f = this.fonts[line].deriveFont(0, 10.0f);
                g2d.setFont(f);
                g.drawString(this.textLines[line], cx + readableMetrics.stringWidth(logicalName) + 5, y);
            }
            this.printCentered(pf, readableFont, readableMetrics, lineHeight, g2d, (int)pf.getImageableHeight() - 10, "- " + (fontPageIndex + 1) + " -");
            return 0;
        }

        private int printCentered(PageFormat pf, Font readableFont, FontMetrics readableMetrics, int lineHeight, Graphics2D g2d, int y, String header) {
            int hStart = ((int)pf.getImageableWidth() - readableMetrics.stringWidth(header)) / 2;
            hStart = hStart < 0 ? 0 : hStart;
            g2d.setFont(readableFont);
            g2d.drawString(header, hStart, y);
            return y += lineHeight;
        }

        private void initFontListing(PageFormat pf, int lineHeight) {
            this.initTextLines();
            int linesPerPage = (int)(pf.getImageableHeight() / (double)lineHeight) - 4;
            int numBreaks = (this.textLines.length - 1) / linesPerPage;
            this.pageBreaks = new int[numBreaks];
            for (int b = 0; b < numBreaks; ++b) {
                this.pageBreaks[b] = (b + 1) * linesPerPage;
            }
        }
    }

    private static final class CUPSDescriptor {
        String cups = "unable to detect";
        String server = "unknown";
        int port = -1;

        private CUPSDescriptor() {
        }
    }

    private static class Option {
        String cmd;
        String description;

        public Option(String cmd, String description) {
            this.cmd = cmd;
            this.description = description;
        }
    }
}

