/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum RedirectionType {
    None(0),
    Disabled(1),
    DBNameBased(2),
    TenantWithAZAware(3),
    Unknown(-1);

    private static final RedirectionType[] VALUES;

    public static RedirectionType decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return RedirectionType.decode(value).name() + '(' + value + ')';
    }

    private RedirectionType(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = RedirectionType.values();
    }
}

