/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl;

import com.sap.lm.sl.analytics.util.Log;
import com.sap.lm.sl.analytics.util.PropertiesHandler;
import com.sap.lm.sl.upg.notifier.MailNotifierConstants;
import com.sap.lm.sl.upg.notifier.MailNotifierException;
import com.sap.lm.sl.upg.notifier.Mailer;
import com.sap.lm.sl.upg.notifier.MailerException;
import com.sap.lm.sl.upg.notifier.SlpMonitorRequestFactory;
import com.sap.lm.sl.upg.notifier.SlpMonitorRequestor;
import com.sap.lm.sl.upg.notifier.SlpMonitorRequestorJava;
import com.sap.lm.sl.upg.notifier.SlpMonitorTask;
import java.io.Console;
import java.io.IOException;

public class SumMailNotifier
implements MailNotifierConstants {
    private static final String PNAME = "SumMailNotifier";
    private static final String PVERSION = "2.2.0";
    private static final String PROP_FILE = "MailNotifierApp.props";
    private static final String PROP_RESOURCE = "com/sap/lm/sl/upg/notifier/MailNotifierApp.props";
    private static final SlpMonitorTask NULL_TASK = new SlpMonitorTask("NULL_TASK");
    private PropertiesHandler props;
    private SlpMonitorRequestor[] reqs;
    private SlpMonitorRequestFactory facs;
    private Mailer mailer;
    private String host;
    private String sid;
    private int interval;
    private int[] dialogTries;
    private int[] bucketTries;
    private int maxFailed;
    private SlpMonitorTask[] curTask = new SlpMonitorTask[]{NULL_TASK, NULL_TASK};
    private int[] curTries = new int[]{0, 0};
    private int failed = 0;

    public SumMailNotifier(String[] args) throws MailNotifierException, MailerException, IOException {
        int i;
        this.props = this.prepareProps(args);
        this.interval = Integer.parseInt(this.props.getTrimmedProperty("check.interval"));
        String[] tryStrs = this.props.getProperties("check.dialog.tries");
        this.dialogTries = new int[tryStrs.length];
        for (i = 0; i < this.dialogTries.length; ++i) {
            this.dialogTries[i] = Integer.parseInt(tryStrs[i]);
        }
        tryStrs = this.props.getProperties("check.bucket.tries");
        this.bucketTries = new int[tryStrs.length];
        for (i = 0; i < this.bucketTries.length; ++i) {
            this.bucketTries[i] = Integer.parseInt(tryStrs[i]);
        }
        String maxFailedStr = this.props.getProperty("check.max.failed");
        this.maxFailed = maxFailedStr != null ? Integer.parseInt(maxFailedStr) : 0x7FFFFFFE;
        this.host = this.props.getTrimmedProperty("sum.host");
        this.sid = this.props.getTrimmedProperty("sum.sid");
        String type = this.props.getTrimmedProperty("sum.type");
        if ("dualabap".equals(type)) {
            this.reqs = new SlpMonitorRequestor[2];
            this.reqs[0] = new SlpMonitorRequestor(this.props);
            PropertiesHandler javaPropsHandler = this.props.clone();
            javaPropsHandler.setProperty("sum.type", "sumjava");
            this.reqs[1] = new SlpMonitorRequestorJava(javaPropsHandler);
        } else if ("sumjava".equals(type)) {
            this.reqs = new SlpMonitorRequestor[1];
            this.reqs[0] = new SlpMonitorRequestorJava(this.props);
        } else {
            this.reqs = new SlpMonitorRequestor[1];
            this.reqs[0] = new SlpMonitorRequestor(this.props);
        }
        this.facs = new SlpMonitorRequestFactory();
        for (int i2 = 0; i2 < this.reqs.length; ++i2) {
            Log.info("Starting check request ... ");
            String req = this.reqs[i2].getRequest();
            Log.info("Check request successful : %s", req);
            SlpMonitorTask task = this.facs.build(this.reqs[i2]);
            Log.info("Check request id %s", task.getExtId());
        }
        this.mailer = new Mailer(this.props);
        this.sendWelcomeMail();
    }

    private PropertiesHandler prepareProps(String[] cmdLine) throws IOException {
        PropertiesHandler props = new PropertiesHandler();
        props.addHidden("sum.pwd");
        props.addHidden("mail.pwd");
        props.addMandatory("sum.host");
        props.addMandatory("sum.port");
        props.addMandatory("sum.user");
        props.addMandatory("sum.pwd");
        props.addMandatory("sum.sid");
        props.addMandatory("sum.type");
        props.addMandatory("sum.ssl");
        props.addMandatory("mail.host");
        props.addMandatory("mail.from");
        props.addMandatory("mail.to");
        props.addMandatory("check.interval");
        props.addMandatory("check.dialog.tries");
        props.addMandatory("check.bucket.tries");
        props.setCmdKeyName("properties");
        props.setResource(PROP_RESOURCE);
        props.setCmdLine(cmdLine);
        props.loadProperties();
        Log.setLogFile(props.getTrimmedProperty("log.file"));
        Log.setLogLevel(props.getTrimmedProperty("log.level"));
        this.readMandatoryProperties(props);
        props.logProperties("SumMailNotifier Properties");
        return props;
    }

    private void readMandatoryProperties(PropertiesHandler props) throws IOException {
        Console console = System.console();
        if (console == null) {
            Log.error("Cannot open System.console ()");
            return;
        }
        Log.info("Requesting missing mandatory properties: ");
        for (String key : props.getMandatoryProperties()) {
            String val = props.getTrimmedProperty(key);
            if (val != null && val.length() != 0) continue;
            val = props.isHiddenProperty(key) ? new String(console.readPassword("Property %s: ", key)) : console.readLine("Property %s: ", key);
            props.setProperty(key, val);
        }
    }

    private void sendWelcomeMail() throws MailerException {
        String subject = String.format("%s was started (%s on %s)", PNAME, this.sid, this.host);
        StringBuffer body = new StringBuffer();
        body.append("Dear SUM user,\n\n");
        body.append("this initial notification mail was sent and received successfully!\n\n");
        body.append("This email was generated automatically, based on settings for ");
        body.append(PNAME);
        body.append(". Do not reply.\n");
        Log.info("Sending welcome mail \"%s\"", subject);
        this.mailer.send(subject, body.toString());
    }

    private void sendGoodByeMail() throws MailerException {
        String subject = String.format("%s was stopped for %s on %s", PNAME, this.sid, this.host);
        StringBuffer body = new StringBuffer();
        body.append("Dear SUM user,\n\n");
        body.append(PNAME);
        body.append(" was not able to connect successfully to ");
        body.append(String.format("your SUM process (%s on %s) ", this.sid, this.host));
        body.append(String.format("(number of unsuccessful retries %s).\n\n", this.maxFailed));
        body.append("This email was generated automatically, based on settings for ");
        body.append(PNAME);
        body.append(". Do not reply.\n");
        Log.info("Sending good bye mail \"%s\"", subject);
        this.mailer.send(subject, body.toString());
    }

    private void sendDialogMail(SlpMonitorTask task) throws MailerException {
        String subject = String.format("SUM process (%s on %s) requires action", this.sid, this.host);
        StringBuffer body = new StringBuffer();
        body.append("Dear SUM user,\n\n");
        body.append(String.format("your SUM process (%s on %s) ", this.sid, this.host));
        body.append("is in dialog state and requires your action:\n");
        body.append(task.getMessages());
        body.append("\n");
        String errors = task.getErrors();
        if (errors != null && errors.length() > 0) {
            body.append("The following error message is shown:\n");
            body.append(errors);
            body.append("\n");
            String logs = task.getExtLogs();
            if (logs != null && logs.length() > 0) {
                try {
                    String logfile = logs.substring(logs.indexOf(".") + 1);
                    String logdir = logfile.substring(0, logfile.indexOf("."));
                    String logfilename = logfile.substring(logfile.indexOf(".") + 1);
                    body.append("For more information, see the files: <SUM directory>/sdt/log/");
                    body.append(logdir + "/" + logfilename);
                    body.append("\n");
                    body.append("\n");
                }
                catch (Exception e) {
                    Log.info("The log file from request is \"%s\" " + logs);
                }
            }
        }
        body.append("This email was generated automatically, based on settings for ");
        body.append(PNAME);
        body.append(". Do not reply.\n");
        Log.info("Sending mail \"%s\"", subject);
        this.mailer.send(subject, body.toString());
    }

    private void sendBucketMail(SlpMonitorTask task) throws MailerException {
        String subject = String.format("SUM migration process (%s on %s) requires action", this.sid, this.host);
        StringBuffer body = new StringBuffer();
        body.append("Dear SUM user,\n\n");
        body.append(String.format("your SUM migration process (%s on %s) ", this.sid, this.host));
        body.append("has encountered an issue with one or more broken buckets:\n\n");
        body.append(task.getMessages());
        body.append("\n");
        body.append("You have the option to restart these buckets from the Process Control Center ");
        body.append("even before the end of the migration phase. ");
        body.append("This only makes sense if the reason for the issue was solved meanwhile.");
        body.append("\n\n");
        body.append("This email was generated automatically, based on settings for ");
        body.append(PNAME);
        body.append(". Do not reply.\n");
        Log.info("Sending mail \"%s\"", subject);
        this.mailer.send(subject, body.toString());
    }

    private boolean checkDialogTries(int curTries) {
        return this.checkTries(this.dialogTries, curTries);
    }

    private boolean checkBucketTries(int curTries) {
        return this.checkTries(this.bucketTries, curTries);
    }

    private boolean checkTries(int[] tries, int curTries) {
        for (int t : tries) {
            if (t != curTries) continue;
            return true;
        }
        return false;
    }

    public void run() throws InterruptedException {
        while (true) {
            for (int i = 0; i < this.reqs.length; ++i) {
                try {
                    SlpMonitorTask task = this.facs.build(this.reqs[i]);
                    this.failed = 0;
                    if (task == null) continue;
                    Log.finest("Request/task \"%s\"", task.getExtId());
                    if (task.isInDialog() || task.isBucket()) {
                        if (!this.curTask[i].getExtId().equals(task.getExtId())) {
                            this.curTries[i] = 0;
                        }
                        this.curTask[i] = task;
                        int n = i;
                        this.curTries[n] = this.curTries[n] + 1;
                    } else {
                        this.curTask[i] = NULL_TASK;
                        this.curTries[i] = 0;
                    }
                    if (task.isInDialog() && this.checkDialogTries(this.curTries[i])) {
                        this.sendDialogMail(this.curTask[i]);
                    }
                    if (!task.isBucket() || !this.checkBucketTries(this.curTries[i])) continue;
                    this.sendBucketMail(this.curTask[i]);
                    continue;
                }
                catch (Exception e) {
                    ++this.failed;
                    Log.warning("Failed %d Exception %s", this.failed, e.getMessage());
                    Log.stackTrace(e);
                    if (this.failed < this.maxFailed) continue;
                    try {
                        this.sendGoodByeMail();
                    }
                    catch (MailerException e1) {
                        Log.stackTrace(e1);
                    }
                    return;
                }
            }
            Log.finest("Sleeping %d seconds", this.interval);
            Thread.sleep(this.interval * 1000);
        }
    }

    public static void main(String[] args) {
        try {
            Log.info("%s (Version %s) - starting ...", PNAME, PVERSION);
            new SumMailNotifier(args).run();
            Log.info("%s (Version %s) successfully finished", PNAME, PVERSION);
        }
        catch (Exception e) {
            Log.error("%s (Version %s) finished with errors", PNAME, PVERSION);
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

