/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl;

import com.sap.lm.sl.xml.XMLConverter;
import com.sap.lm.sl.zip.ZIPFiles;

public class SumTools {
    private static void showHelp() {
        System.out.println("Usage: java -jar com.sap.lm.sl.SUMTools ... ");
        System.out.println("    convertxml <xmlpath> <xslpath> <output>");
        System.out.println("    zipfiles <basedir> <mappingpath> <output>");
    }

    private static void convertXML(String[] args) throws Exception {
        if (args.length != 4) {
            throw new Exception("Usage: convertxml <xmlpath> <xslpath> <output>");
        }
        XMLConverter conv = new XMLConverter(args[1], args[2], args[3]);
        conv.convert();
    }

    private static void zipFiles(String[] args) throws Exception {
        if (args.length != 4) {
            throw new Exception("Usage: zipfiles <basedir> <mappingpath> <output>");
        }
        ZIPFiles zipper = new ZIPFiles(args[1], args[2], args[3]);
        zipper.zip();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            SumTools.showHelp();
            System.exit(1);
        }
        try {
            String command = args[0];
            if (command.equalsIgnoreCase("convertxml")) {
                SumTools.convertXML(args);
            } else if (command.equalsIgnoreCase("zipfiles")) {
                SumTools.zipFiles(args);
            } else if (command.equalsIgnoreCase("help")) {
                SumTools.showHelp();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

