/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.analytics.util;

import com.sap.lm.sl.analytics.util.LogLevel;
import com.sap.lm.sl.analytics.util.Timer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class Log {
    private static PrintStream out;
    private static PrintStream err;
    private static LogLevel logLevel;

    public static void setLogLevel(String levelName) {
        try {
            if (levelName != null) {
                logLevel = LogLevel.valueOf(levelName);
            }
        }
        catch (IllegalArgumentException e) {
            Log.error("Illegal Log Level \"%s\"", levelName);
        }
    }

    public static void setLogLevel(LogLevel level) {
        logLevel = level;
    }

    public static void setLogFile(String logName) {
        if (logName == null) {
            return;
        }
        File logFile = new File(logName);
        Log.info("Log File: %s", logFile.getAbsolutePath());
        try {
            out = new PrintStream(logFile);
        }
        catch (FileNotFoundException e) {
            out = System.out;
            Log.error("Cannot open log file \"%s\"", logFile);
        }
        err = out;
    }

    public static void stackTrace(Exception e) {
        Log.print(err, "FATAL", "Stack trace");
        e.printStackTrace(err);
    }

    public static void finest(String msg) {
        Log.print(out, LogLevel.FINEST, msg);
    }

    public static void finest(String msg, Object ... params) {
        if (logLevel.compareTo(LogLevel.FINEST) > 0) {
            return;
        }
        Log.print(out, LogLevel.FINEST, String.format(msg, params));
    }

    public static void finer(String msg) {
        Log.print(out, LogLevel.FINER, msg);
    }

    public static void finer(String msg, Object ... params) {
        if (logLevel.compareTo(LogLevel.FINER) > 0) {
            return;
        }
        Log.print(out, LogLevel.FINER, String.format(msg, params));
    }

    public static void info(String msg) {
        Log.print(out, LogLevel.INFO, msg);
    }

    public static void info(String msg, Object ... params) {
        if (logLevel.compareTo(LogLevel.INFO) > 0) {
            return;
        }
        Log.print(out, LogLevel.INFO, String.format(msg, params));
    }

    public static void warning(String msg) {
        Log.print(out, LogLevel.WARNING, msg);
    }

    public static void warning(String msg, Object ... params) {
        if (logLevel.compareTo(LogLevel.WARNING) > 0) {
            return;
        }
        Log.print(out, LogLevel.WARNING, String.format(msg, params));
    }

    public static void error(String msg) {
        Log.print(err, LogLevel.ERROR, msg);
    }

    public static void error(String msg, Object ... params) {
        if (logLevel.compareTo(LogLevel.ERROR) > 0) {
            return;
        }
        Log.print(err, LogLevel.ERROR, String.format(msg, params));
    }

    private static void print(PrintStream pS, LogLevel level, String msg) {
        if (logLevel.compareTo(level) > 0) {
            return;
        }
        Log.print(pS, level.toString(), msg);
    }

    private static void print(PrintStream pS, String levelName, String msg) {
        pS.printf("[%s] %7s %s\n", Timer.getTimestamp(), levelName, msg);
    }

    static {
        logLevel = LogLevel.INFO;
        out = System.out;
        err = System.err;
    }
}

