/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.analytics.util;

import com.sap.lm.sl.analytics.util.Log;
import com.sap.lm.sl.analytics.util.PropertiesIF;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesHandler
implements PropertiesIF {
    static final String PROP_HIDDEN_VALUE = "<hidden>";
    private Properties props = new Properties();
    private Set<String> hiddenProps = new HashSet<String>();
    private List<String> mandatoryProps = new LinkedList<String>();
    private String propResource = null;
    private String propFileName = null;
    private String[] propCmdLine = null;
    private String cmdPropKeyName = null;

    public String getCmdKeyName() {
        return this.cmdPropKeyName;
    }

    public void setCmdKeyName(String cmdPropKeyName) {
        this.cmdPropKeyName = cmdPropKeyName;
    }

    @Override
    public void addHidden(String key) {
        this.hiddenProps.add(key);
    }

    @Override
    public void addMandatory(String key) {
        this.mandatoryProps.add(key);
    }

    public String getResource() {
        return this.propResource;
    }

    public void setResource(String propResource) {
        this.propResource = propResource;
    }

    public String getFileName() {
        return this.propFileName;
    }

    public void setFileName(String propFileName) {
        this.propFileName = propFileName;
    }

    public String[] getCmdLine() {
        return this.propCmdLine;
    }

    public void setCmdLine(String[] propCmdLine) {
        this.propCmdLine = propCmdLine;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : this.props.keySet()) {
            if (!(key instanceof String)) continue;
            keys.add((String)key);
        }
        return keys;
    }

    private void getPropertiesFromClasspath(String resource) {
        try {
            Log.info("Reading properties from classpath \"%s\"", resource);
            URL url = this.getClass().getClassLoader().getResource(resource);
            if (url != null) {
                this.props.load(url.openStream());
            } else {
                Log.warning("Properties resource file \"%s\" not found", resource);
            }
        }
        catch (IOException e) {
            Log.error("Cannot read properties resource file \"%s\": \"%s\"", resource, e.getMessage());
        }
    }

    private void getPropertiesFromFile(String fileName) {
        try {
            Log.info("Reading properties from file \"%s\"", fileName);
            FileReader fileReader = new FileReader(fileName);
            this.props.load(fileReader);
        }
        catch (IOException e) {
            Log.error("Cannot read properties file \"%s\": \"%s\"", fileName, e.getMessage());
        }
    }

    private Properties getPropertiesFromCmdLine(String[] cmdArgs) {
        Properties cmdProps = new Properties();
        for (String cmdArg : cmdArgs) {
            String escaped = cmdArg.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\"));
            StringReader strReader = new StringReader(escaped);
            try {
                cmdProps.load(strReader);
            }
            catch (IOException e) {
                Log.error("Cannot read properties from command line argument \"%s\": \"%s\"", cmdArg, e.getMessage());
            }
        }
        return cmdProps;
    }

    public boolean isHiddenProperty(String key) {
        return this.hiddenProps.contains(key);
    }

    public void logProperties(String headline) {
        Log.info("Properties \"%s\"", headline);
        int maxLength = 0;
        for (String key : this.props.stringPropertyNames()) {
            if (key.length() <= maxLength) continue;
            maxLength = key.length();
        }
        LinkedList<String> propNames = new LinkedList<String>(this.props.stringPropertyNames());
        Collections.sort(propNames);
        String format = "    %" + maxLength + "s = \"%s\"";
        for (String key : propNames) {
            String value = this.isHiddenProperty(key) ? PROP_HIDDEN_VALUE : this.props.getProperty(key);
            Log.info(format, key, value);
        }
    }

    public void loadProperties() {
        Properties cmdProps = null;
        if (this.getResource() != null) {
            this.getPropertiesFromClasspath(this.getResource());
        }
        if (this.getCmdLine() != null) {
            cmdProps = this.getPropertiesFromCmdLine(this.getCmdLine());
            if (this.getCmdKeyName() != null) {
                String propFile = cmdProps.getProperty(this.getCmdKeyName());
                this.setFileName(propFile);
            }
        }
        if (this.getFileName() != null) {
            this.getPropertiesFromFile(this.getFileName());
        } else {
            Log.info("No command line properties file was specified");
        }
        if (cmdProps != null) {
            this.props.putAll((Map<?, ?>)cmdProps);
        }
    }

    @Override
    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    @Override
    public String getTrimmedProperty(String key) {
        String value = this.props.getProperty(key);
        return value != null ? value.trim() : null;
    }

    public boolean isSet(String key) {
        String value = this.getTrimmedProperty(key);
        if (value == null) {
            return false;
        }
        if ("true".equals(value = value.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        if ("yes".equals(value)) {
            return true;
        }
        return "1".equals(value);
    }

    public String[] getProperties(String keyPrefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object keyObj : this.props.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith(keyPrefix)) continue;
            list.add(this.props.getProperty(key));
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    @Override
    public void setProperty(String key, String value) {
        Log.finer("Set property %s = %s", key, this.isHiddenProperty(key) ? PROP_HIDDEN_VALUE : value);
        this.props.setProperty(key, value);
    }

    public List<String> getMandatoryProperties() {
        return this.mandatoryProps;
    }

    public boolean checkMandatoryProperties() {
        boolean allSet = true;
        for (String key : this.mandatoryProps) {
            String value = this.props.getProperty(key);
            if (value != null && value.length() != 0) continue;
            Log.error("Mandatory property \"%s\" was not set", key);
            allSet = false;
        }
        return allSet;
    }

    public PropertiesHandler clone() {
        PropertiesHandler propsHandler = new PropertiesHandler();
        propsHandler.setProperties(new Properties(this.props));
        return propsHandler;
    }

    private void setProperties(Properties newProps) {
        this.props = newProps;
    }
}

