/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.analytics.util;

import com.sap.lm.sl.analytics.util.VersionException;

public class Version
implements Comparable<Version> {
    private String versionStr;
    private int[] subVersions;

    public Version(String versionStr) throws VersionException {
        this.versionStr = versionStr != null ? versionStr : "";
        String[] subStrings = this.versionStr.split("\\.");
        this.subVersions = new int[subStrings.length];
        for (int i = 0; i < this.subVersions.length; ++i) {
            try {
                this.subVersions[i] = Integer.parseInt(subStrings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new VersionException("Illegal version %s : %s", this.versionStr, e.getMessage());
            }
        }
    }

    private int[] getSubVersions() {
        return this.subVersions;
    }

    public String toString() {
        return "Version [versionStr=" + this.versionStr + "]";
    }

    @Override
    public int compareTo(Version arg0) {
        int[] right;
        int[] left = this.getSubVersions();
        int length = left.length < (right = arg0.getSubVersions()).length ? left.length : right.length;
        for (int i = 0; i < length; ++i) {
            if (left[i] < right[i]) {
                return -1;
            }
            if (left[i] <= right[i]) continue;
            return 1;
        }
        if (left.length < right.length) {
            return -1;
        }
        if (left.length > right.length) {
            return 1;
        }
        return 0;
    }

    private static String getComparator(int cmpResult) {
        if (cmpResult > 0) {
            return " > ";
        }
        if (cmpResult < 0) {
            return " < ";
        }
        return " = ";
    }

    public static void main(String[] args) throws VersionException {
        Version v1 = new Version("1.2.3.4.");
        Version v2 = new Version("1.2.3.");
        System.out.println(v1 + Version.getComparator(v1.compareTo(v2)) + v2);
        v1 = new Version("58.000");
        v2 = new Version("58.00.1");
        System.out.println(v1 + Version.getComparator(v1.compareTo(v2)) + v2);
    }
}

