/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.upg.notifier;

import com.sap.lm.sl.analytics.util.Log;
import com.sap.lm.sl.analytics.util.PropertiesHandler;
import com.sap.lm.sl.upg.notifier.MailerConstants;
import com.sap.lm.sl.upg.notifier.MailerException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Mailer
implements MailerConstants {
    private Properties mailProps;
    private MailAuthenticator mailAuth;
    private String mailFrom;
    private String mailTo;
    private boolean mailDebug;

    public Mailer(PropertiesHandler pH) {
        String mailHost = pH.getTrimmedProperty("mail.host");
        String mailPort = pH.getTrimmedProperty("mail.port");
        String mailUser = pH.getTrimmedProperty("mail.user");
        String mailPwd = pH.getTrimmedProperty("mail.pwd");
        Log.info("Mailer %s  = \"%s\"", "mail.host", mailHost);
        Log.info("Mailer %s  = \"%s\"", "mail.port", mailPort);
        Log.info("Mailer %s  = \"%s\"", "mail.user", mailUser);
        this.mailFrom = pH.getTrimmedProperty("mail.from");
        this.mailTo = pH.getTrimmedProperty("mail.to");
        Log.info("Mailer %s  = \"%s\"", "mail.from", this.mailFrom);
        Log.info("Mailer %s    = \"%s\"", "mail.to", this.mailTo);
        this.mailDebug = pH.isSet("mail.debug");
        Log.info("Mailer %s = \"%s\"", "mail.debug", this.mailDebug ? "true" : "false");
        this.mailProps = new Properties();
        for (String key : pH.getKeys()) {
            if (!key.startsWith("mail.smtp.")) continue;
            this.mailProps.put(key, pH.getTrimmedProperty(key));
            Log.info("Mailer %s = \"%s\"", key, pH.getTrimmedProperty(key));
        }
        this.mailProps.put("mail.smtp.host", mailHost);
        if (this.isSet(mailPort)) {
            this.mailProps.setProperty("mail.smtp.port", mailPort);
        }
        if (this.isSet(mailUser) && this.isSet(mailPwd)) {
            this.mailProps.put("mail.smtp.auth", "true");
            this.mailAuth = new MailAuthenticator(mailUser, mailPwd);
        } else {
            this.mailAuth = null;
        }
    }

    private boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    private MimeMessage createMessage() {
        Session session = this.mailAuth != null ? Session.getDefaultInstance(this.mailProps, this.mailAuth) : Session.getDefaultInstance(this.mailProps);
        session.setDebug(this.mailDebug);
        return new MimeMessage(session);
    }

    public void send(String subject, String body) throws MailerException {
        try {
            MimeMessage msg = this.createMessage();
            if (this.mailFrom != null && this.mailFrom.length() > 0) {
                msg.setFrom(new InternetAddress(this.mailFrom));
            }
            msg.setRecipients(Message.RecipientType.TO, this.mailTo);
            msg.setSubject(subject);
            msg.setText(body);
            msg.setSentDate(new Date());
            Log.finer("Sending mail \"%s\" from \"%s\" to \"%s\"", subject, this.mailFrom, this.mailTo);
            Transport.send(msg);
        }
        catch (MessagingException e) {
            throw new MailerException(e);
        }
    }

    class MailAuthenticator
    extends Authenticator {
        private String user;
        private String pwd;

        MailAuthenticator(String user, String pwd) {
            this.user = user;
            this.pwd = pwd;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pwd);
        }
    }
}

