/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.upg.notifier;

import com.sap.lm.sl.upg.notifier.MailNotifierException;
import com.sap.lm.sl.upg.notifier.SlpMonitorRequestConstants;
import com.sap.lm.sl.upg.notifier.SlpMonitorRequestor;
import com.sap.lm.sl.upg.notifier.SlpMonitorRequestorJava;
import com.sap.lm.sl.upg.notifier.SlpMonitorTask;
import com.sap.lm.sl.upg.notifier.SlpMonitorTaskType;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SlpMonitorRequestFactory
implements SlpMonitorRequestConstants {
    private DocumentBuilderFactory docBF;
    private DocumentBuilder docB;

    public SlpMonitorRequestFactory() throws MailNotifierException {
        try {
            this.docBF = DocumentBuilderFactory.newInstance();
            this.docB = this.docBF.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MailNotifierException(e);
        }
    }

    public SlpMonitorTask build(SlpMonitorRequestor request) throws MailNotifierException {
        try {
            StringReader rdr = new StringReader(request.getRequest());
            Document doc = this.docB.parse(new InputSource(rdr));
            SlpMonitorTask task = request instanceof SlpMonitorRequestorJava ? this.buildJava(doc) : this.build(doc);
            SlpMonitorTask slpMonitorTask = task;
            return slpMonitorTask;
        }
        catch (IOException e) {
            throw new MailNotifierException(e);
        }
        catch (SAXException e) {
            throw new MailNotifierException(e);
        }
        finally {
            this.docB.reset();
        }
    }

    private SlpMonitorTask build(Document doc) throws MailNotifierException {
        NodeList nList = doc.getElementsByTagName("Task");
        HashMap<String, SlpMonitorTask> tMap = new HashMap<String, SlpMonitorTask>();
        for (int i = 0; i < nList.getLength(); ++i) {
            SlpMonitorTask task;
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || (task = this.build((Element)node)) == null) continue;
            tMap.put(task.getId(), task);
        }
        SlpMonitorTask top = null;
        for (SlpMonitorTask child : tMap.values()) {
            if (child.getParentId() != null) {
                SlpMonitorTask parent = (SlpMonitorTask)tMap.get(child.getParentId());
                child.setParent(parent);
                parent.addChild(child);
                continue;
            }
            top = child;
        }
        return top;
    }

    private SlpMonitorTask buildJava(Document doc) throws MailNotifierException {
        NodeList nList = doc.getElementsByTagName("Task");
        HashMap<String, SlpMonitorTask> tMap = new HashMap<String, SlpMonitorTask>();
        for (int i = 0; i < nList.getLength(); ++i) {
            SlpMonitorTask task;
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || (task = this.build((Element)node)) == null) continue;
            tMap.put(task.getId(), task);
        }
        SlpMonitorTask top = null;
        for (SlpMonitorTask child : tMap.values()) {
            if (!"SUM4Java".equals(child.getId())) continue;
            top = child;
        }
        for (SlpMonitorTask child : tMap.values()) {
            if (child.getType() != SlpMonitorTaskType.STEP) continue;
            top.addChild(child);
        }
        return top;
    }

    private SlpMonitorTask build(Element elem) {
        SlpMonitorTask task = null;
        NodeList nList = elem.getElementsByTagName("id");
        if (nList.getLength() <= 0) {
            return null;
        }
        String id = nList.item(0).getTextContent();
        task = new SlpMonitorTask(id);
        nList = elem.getElementsByTagName("parent");
        if (nList.getLength() > 0) {
            String parentId = nList.item(0).getTextContent();
            task.setParentId(parentId);
        }
        if ((nList = elem.getElementsByTagName("type")).getLength() > 0) {
            String type = nList.item(0).getTextContent();
            task.setType(type);
        }
        if ((nList = elem.getElementsByTagName("status")).getLength() > 0) {
            String status = nList.item(0).getTextContent();
            task.setStatus(status);
        }
        if ((nList = elem.getElementsByTagName("error")).getLength() > 0) {
            String error = nList.item(0).getTextContent();
            task.setError(error);
        }
        if ((nList = elem.getElementsByTagName("message")).getLength() > 0) {
            String message = nList.item(0).getTextContent();
            task.setMessage(message);
        }
        if ((nList = elem.getElementsByTagName("logs")).getLength() > 0) {
            String logs = nList.item(0).getTextContent();
            task.setLogs(logs);
        }
        return task;
    }
}

