/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.upg.notifier;

import com.sap.lm.sl.analytics.util.Log;
import com.sap.lm.sl.analytics.util.PropertiesHandler;
import com.sap.lm.sl.upg.notifier.MailNotifierConstants;
import com.sap.lm.sl.upg.notifier.MailNotifierException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.DatatypeConverter;

public class SlpMonitorRequestor
implements MailNotifierConstants {
    protected URL reqUrl;
    protected String reqAuth;
    protected String uiUrlString;

    public SlpMonitorRequestor(PropertiesHandler props) throws MailNotifierException {
        this.init(props);
    }

    protected void init(PropertiesHandler props) throws MailNotifierException {
        String host = props.getProperty("sum.host");
        String port = props.getProperty("sum.port");
        String type = props.getProperty("sum.type");
        String sid = props.getProperty("sum.sid");
        boolean isSSL = "true".equals(props.getProperty("sum.ssl"));
        String prot = isSSL ? "https" : "http";
        String urlString = String.format("%s://%s:%s/slp/%s/%s/monitor", prot, host, port, type, sid);
        Log.info("SUM Monitor Request URL = %s", urlString);
        String user = props.getProperty("sum.user");
        String pwd = props.getProperty("sum.pwd");
        String authString = user + ":" + pwd;
        try {
            this.reqUrl = new URL(urlString);
            this.reqAuth = DatatypeConverter.printBase64Binary(authString.getBytes("UTF-8"));
            this.uiUrlString = String.format("%s://%s:%s/lmsl/%s/%s/doc/sluigui", prot, host, port, type, sid);
        }
        catch (MalformedURLException e) {
            throw new MailNotifierException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MailNotifierException(e);
        }
    }

    public String getRequest() throws MailNotifierException {
        try {
            int n;
            char[] cBuf = new char[1024];
            StringBuffer sBuf = new StringBuffer();
            HttpURLConnection con = (HttpURLConnection)this.reqUrl.openConnection();
            con.setRequestProperty("Authorization", "Basic " + this.reqAuth);
            BufferedReader rdr = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            while ((n = rdr.read(cBuf, 0, cBuf.length)) > 0) {
                sBuf.append(cBuf, 0, n);
            }
            rdr.close();
            con.disconnect();
            return sBuf.toString();
        }
        catch (IOException e) {
            throw new MailNotifierException(e);
        }
    }

    public String getUiUrlString() {
        return this.uiUrlString;
    }
}

