/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.upg.notifier;

import com.sap.lm.sl.analytics.util.Log;
import com.sap.lm.sl.analytics.util.PropertiesHandler;
import com.sap.lm.sl.upg.notifier.MailNotifierException;
import com.sap.lm.sl.upg.notifier.SlpMonitorRequestor;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.DatatypeConverter;

public class SlpMonitorRequestorJava
extends SlpMonitorRequestor {
    public SlpMonitorRequestorJava(PropertiesHandler props) throws MailNotifierException {
        super(props);
    }

    @Override
    protected void init(PropertiesHandler props) throws MailNotifierException {
        String host = props.getProperty("sum.host");
        String port = props.getProperty("sum.port");
        String type = props.getProperty("sum.type");
        String sid = props.getProperty("sum.sid");
        boolean isSSL = "true".equals(props.getProperty("sum.ssl"));
        String prot = isSSL ? "https" : "http";
        String urlString = String.format("%s://%s:%s/lmsl/%s/%s/slp/processes/SUM4Java/monitor", prot, host, port, type, sid);
        Log.info("SUM Monitor Request URL = %s", urlString);
        String user = props.getProperty("sum.user");
        String pwd = props.getProperty("sum.pwd");
        String authString = user + ":" + pwd;
        try {
            this.reqUrl = new URL(urlString);
            this.reqAuth = DatatypeConverter.printBase64Binary(authString.getBytes("UTF-8"));
            this.uiUrlString = String.format("%s://%s:%s/lmsl/%s/%s/index.html", prot, host, port, type, sid);
        }
        catch (MalformedURLException e) {
            throw new MailNotifierException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MailNotifierException(e);
        }
    }
}

