/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.upg.notifier;

import com.sap.lm.sl.analytics.util.Log;
import com.sap.lm.sl.upg.notifier.SlpMonitorTaskStatus;
import com.sap.lm.sl.upg.notifier.SlpMonitorTaskType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SlpMonitorTask {
    private static final String INDENT = "    ";
    private static final String LF = "\n";
    private List<SlpMonitorTask> childs = new LinkedList<SlpMonitorTask>();
    private String id;
    private String parentId;
    private SlpMonitorTask parent;
    private String error;
    private String message;
    private String logs;
    private SlpMonitorTaskType type;
    private SlpMonitorTaskStatus status;

    public SlpMonitorTask(String id) {
        this.setId(id);
        this.parentId = null;
        this.parent = null;
        this.error = null;
        this.message = null;
    }

    public String getExtId() {
        if (this.hasChilds()) {
            return this.getId() + " -> " + this.childs.get(0).getExtId();
        }
        return this.getId() + " (" + this.getError() + ")";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId == null || parentId.length() == 0 ? null : parentId;
    }

    public SlpMonitorTask getParent() {
        return this.parent;
    }

    public void setParent(SlpMonitorTask parent) {
        this.parent = parent;
    }

    public List<SlpMonitorTask> getChilds() {
        return this.childs;
    }

    public void addChild(SlpMonitorTask child) {
        this.childs.add(child);
    }

    public boolean hasChilds() {
        return this.childs.size() > 0;
    }

    public SlpMonitorTaskType getType() {
        return this.type;
    }

    public void setType(SlpMonitorTaskType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = SlpMonitorTaskType.get(type);
    }

    public SlpMonitorTaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(SlpMonitorTaskStatus status) {
        this.status = status;
    }

    public void setStatus(String status) {
        this.status = SlpMonitorTaskStatus.get(status);
    }

    public boolean isInDialog() {
        if (this.status != SlpMonitorTaskStatus.RUNNING) {
            Log.finest("Task \"%s\" indicates waiting dialog", this.getExtId());
            return true;
        }
        return false;
    }

    public boolean isBucket() {
        Iterator<SlpMonitorTask> iterator = this.getChilds().iterator();
        if (iterator.hasNext()) {
            SlpMonitorTask child = iterator.next();
            return child.isBucket();
        }
        if (this.type == SlpMonitorTaskType.INTERNAL_SUBSTEP && this.status == SlpMonitorTaskStatus.ACTION_REQUIRED) {
            Log.finest("Task \"%s\" indicates failed buckets", this.getExtId());
            return true;
        }
        return false;
    }

    public String getError() {
        return this.error != null ? this.error : "";
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrors() {
        LinkedList<String> list = new LinkedList<String>();
        this.getErrors(list);
        return this.toString(list);
    }

    private void getErrors(List<String> list) {
        if (this.error != null && this.error.length() > 0) {
            this.add(list, this.error);
        }
        for (SlpMonitorTask child : this.childs) {
            child.getErrors(list);
        }
    }

    private void add(List<String> list, String newStr) {
        for (String str : list) {
            if (!str.equals(newStr)) continue;
            return;
        }
        list.add(newStr);
    }

    private String toString(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String str : list) {
            buf.append(INDENT);
            buf.append(str);
            buf.append(LF);
        }
        return buf.toString();
    }

    public String getMessages() {
        LinkedList<String> list = new LinkedList<String>();
        this.getMessages(list);
        return this.toString(list);
    }

    private void getMessages(List<String> list) {
        if (this.message != null && this.message.length() > 0) {
            this.add(list, this.message);
        }
        for (SlpMonitorTask child : this.childs) {
            child.getMessages(list);
        }
    }

    public String getLogs() {
        return this.logs;
    }

    public void setLogs(String logs) {
        this.logs = logs;
    }

    public String getExtLogs() {
        if (this.hasChilds()) {
            return this.childs.get(0).getLogs();
        }
        return this.getLogs();
    }
}

