/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XMLConverter {
    private File m_XmlFile;
    private File m_XslFile;
    private String m_HtmlFile;

    public XMLConverter(String xmlFile, String xslFile, String htmlFile) {
        this.m_XmlFile = new File(xmlFile);
        this.m_XslFile = new File(xslFile);
        this.m_HtmlFile = htmlFile;
    }

    public void convert() throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        String xmlPath = this.m_XmlFile.getAbsolutePath();
        String xslPath = this.m_XslFile.getAbsolutePath();
        if (!this.m_XmlFile.exists()) {
            throw new Exception("XML file '" + xmlPath + "' does not exist!");
        }
        if (!this.m_XslFile.exists()) {
            throw new Exception("XSL file '" + xslPath + "' does not exist!");
        }
        System.out.println("Convert XML file '" + xmlPath + "' to '" + this.m_HtmlFile + "'");
        try {
            Transformer transformer = tFactory.newTransformer(new StreamSource(this.m_XslFile));
            transformer.transform(new StreamSource(this.m_XmlFile), new StreamResult(new FileOutputStream(this.m_HtmlFile)));
        }
        catch (FileNotFoundException e) {
            throw new Exception("Transformation of XML file '" + xmlPath + "' failed!");
        }
    }
}

