/*
 * Decompiled with CFR 0.152.
 */
package com.sap.lm.sl.zip;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZIPFiles {
    private String m_OutputFile;
    private String m_MappingFile;
    private String m_BaseDir;

    public ZIPFiles(String baseDir, String mappingFile, String outputFile) {
        this.m_OutputFile = outputFile;
        this.m_MappingFile = mappingFile;
        this.m_BaseDir = baseDir;
    }

    private String getZipEntryName(File file) {
        String path = file.getAbsolutePath();
        int idx = path.indexOf(this.m_BaseDir);
        if (idx >= 0) {
            path = path.substring(this.m_BaseDir.length());
        }
        if (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        if (path.startsWith("./") || path.startsWith(".\\")) {
            path = path.substring(2);
        }
        return path;
    }

    private LinkedList<File> getFiles2zip() throws Exception {
        String line;
        File mappingFile = new File(this.m_MappingFile);
        LinkedList<File> files = new LinkedList<File>();
        HashMap<String, Boolean> hash = new HashMap<String, Boolean>();
        if (!mappingFile.exists()) {
            throw new Exception("Mapping file '" + this.m_MappingFile + "' does not exist!");
        }
        FileInputStream fileStream = new FileInputStream(mappingFile);
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(fileStream));
        while ((line = fileReader.readLine()) != null) {
            File file;
            String filePath;
            if ((line = line.trim()).isEmpty() || line.startsWith("#") || hash.containsKey(filePath = this.m_BaseDir + File.separator + line) || (file = new File(filePath)) == null || !file.exists()) continue;
            files.add(file);
            hash.put(filePath, true);
        }
        fileStream.close();
        return files;
    }

    private void addFile2Archive(ZipOutputStream outStream, File file) throws Exception {
        int length;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File tmpFile : file.listFiles()) {
                this.addFile2Archive(outStream, tmpFile);
            }
            return;
        }
        String path = this.getZipEntryName(file);
        System.out.println("Zip file '" + path + "'");
        byte[] buffer = new byte[1024];
        FileInputStream inStream = new FileInputStream(file);
        outStream.putNextEntry(new ZipEntry(path));
        while ((length = inStream.read(buffer)) > 0) {
            outStream.write(buffer, 0, length);
        }
        inStream.close();
    }

    public void zip() throws Exception {
        LinkedList<File> files = this.getFiles2zip();
        FileOutputStream fileOut = new FileOutputStream(this.m_OutputFile);
        ZipOutputStream zipOut = new ZipOutputStream(fileOut);
        System.out.println("Create archive '" + this.m_OutputFile + "'");
        for (File file : files) {
            this.addFile2Archive(zipOut, file);
        }
        zipOut.close();
    }
}

