/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.abap;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.util.List;

public class BasisUtils {
    static int release = 0;
    static String destvers = null;

    public static boolean tableExists(String tableName, JdbcConnection connection) {
        List<String> result = connection.executeSQLCommand("SELECT COUNT(*) FROM TABLES WHERE TABLE_NAME = '" + tableName + "' AND SCHEMA_NAME = CURRENT_USER");
        return result.get(0).equals("1");
    }

    public static boolean tableHasField(String tableName, String fieldName, JdbcConnection connection) {
        if (!BasisUtils.tableExists(tableName, connection)) {
            return false;
        }
        List<String> result = connection.executeSQLCommand("SELECT COUNT(*) FROM SYS.TABLE_COLUMNS WHERE TABLE_NAME = '" + tableName + "' AND COLUMN_NAME = '" + fieldName + "' AND SCHEMA_NAME = CURRENT_USER");
        return result.get(0).equals("1");
    }

    public static int checkCVERSBasisRelease(JdbcConnection connection, DatabaseUser sqlUser) {
        if (release > 0) {
            return release;
        }
        HdbsllibMem mem = HdbsllibMem.getInstance();
        destvers = mem.read(HdbsllibMem.DESTVERS);
        if (null != destvers) {
            try {
                release = Integer.parseInt(destvers);
                return BasisUtils.getOnPremRel(release);
            }
            catch (NumberFormatException nfe) {
                release = 0;
            }
        }
        if (0 == release) {
            connection.setConnectUser(sqlUser);
            if (BasisUtils.tableExists("CVERS", connection)) {
                List<String> result = connection.executeSQLCommand("SELECT RELEASE FROM CVERS WHERE COMPONENT = 'SAP_BASIS'");
                if (result.isEmpty()) {
                    return release;
                }
                try {
                    release = Integer.parseInt(result.get(0));
                }
                catch (NumberFormatException e) {
                    LogFactory.writeLogEntry(BasisUtils.class, "Could not parse SAP_BASIS release from CVERS " + result.get(0) + " to integer.");
                }
                LogFactory.writeLogEntry(BasisUtils.class, "Found SAP_BASIS release from CVERS " + release);
            }
        }
        return BasisUtils.getOnPremRel(release);
    }

    public static int checkRealCVERSBasisRelease(JdbcConnection connection, DatabaseUser sqlUser) {
        BasisUtils.checkCVERSBasisRelease(connection, sqlUser);
        return release;
    }

    public static boolean isIBPCloudSystem(JdbcConnection connection, DatabaseUser sqlUser) {
        List<String> result;
        boolean ibp = false;
        connection.setConnectUser(sqlUser);
        if (BasisUtils.tableExists("CVERS", connection) && !(result = connection.executeSQLCommand("SELECT RELEASE FROM CVERS WHERE COMPONENT = 'IBPCLOUD'")).isEmpty()) {
            ibp = true;
        }
        return ibp;
    }

    private static int getOnPremRel(int rel) {
        if (rel <= 759) {
            return rel;
        }
        if (rel <= 773) {
            return 753;
        }
        if (rel <= 777) {
            return 754;
        }
        if (rel <= 781) {
            return 755;
        }
        if (rel <= 785) {
            return 756;
        }
        return 757;
    }
}

