/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.connection.sql;

import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;

public class HdbClazzLoader {
    protected ClassLoader cL = null;
    protected JdbcDriver jdbcDriver = null;
    private Class<? extends Driver> sqlClass = null;

    protected HdbClazzLoader(JdbcDriver jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        this.loadClazzes();
    }

    private void loadClazzes() {
        block7: {
            try {
                if (this.jdbcDriver.exists()) {
                    try {
                        URL url = this.jdbcDriver.getUrl();
                        this.cL = new URLClassLoader(new URL[]{url});
                        Class<?> driverClass = this.cL.loadClass(this.jdbcDriver.getClassName());
                        if (!Driver.class.isAssignableFrom(driverClass)) {
                            throw new HdbException("Class " + this.jdbcDriver.getClassName() + " is not a java.sql.Driver.");
                        }
                        this.sqlClass = driverClass;
                        break block7;
                    }
                    catch (MalformedURLException e) {
                        throw new HdbException(e);
                    }
                }
                LogFactory.writeLogEntry(this.getClass(), this.jdbcDriver + " JDBC driver does not exist. Try to load JDBC driver from current class path: " + System.getProperty("java.class.path"));
                Class<?> driverClass = Class.forName(this.jdbcDriver.getClassName());
                if (!Driver.class.isAssignableFrom(driverClass)) {
                    throw new HdbException("Class " + this.jdbcDriver.getClassName() + " is not a java.sql.Driver.");
                }
                this.sqlClass = driverClass;
            }
            catch (ClassNotFoundException e) {
                LogFactory.writeLogEntry(this.getClass(), this.jdbcDriver.get() + " Jdbc Driver is missing!");
                throw new HdbException(e);
            }
        }
    }

    public Class<? extends Driver> getDriverClass() {
        return this.sqlClass;
    }
}

