/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.connection.sql;

import com.sap.hdb.sl.lib.connection.sql.HdbsqlExecutable;
import com.sap.hdb.sl.lib.exceptions.HdbsqlException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import java.io.File;
import java.util.List;
import java.util.Locale;

public class Hdbsql
extends ExternalProcess {
    private HdbsqlExecutable hdbsqlExecutable = null;
    private boolean foundErrorInOutput = false;
    private String errorMessage = "";
    private int extractedErrorCode = 0;
    private String key;
    private boolean isResult = false;
    private static final String U = "-U";
    private static final String A = "-a";
    private static final String C = "-C";
    private static final String I = "-I";
    private static final String o = "-o";
    private static final String EXECUTE_COMMAND = "Execute command:";
    private static final String ERROR_REGEX = "\\*[ -]*[0-9]+[:].*";

    protected Hdbsql() {
    }

    public Hdbsql(HdbsqlExecutable hdbsqlExecutable, String key) {
        this.hdbsqlExecutable = hdbsqlExecutable;
        this.key = key;
    }

    private String getHdbsqlExecutable() {
        String hdsql = this.hdbsqlExecutable.toString();
        return hdsql;
    }

    @Override
    protected void handleStdoutStderr(String message) {
        String tmpMsg = message.toUpperCase(Locale.ENGLISH);
        if (this.isResult) {
            if (tmpMsg.contains("ERROR")) {
                this.foundErrorInOutput = true;
                this.errorMessage = message;
            }
            if (message.matches(ERROR_REGEX)) {
                this.extractErrorCode(message);
            }
            this.resltList.add(message);
        } else if (message.startsWith(EXECUTE_COMMAND)) {
            this.isResult = true;
        }
    }

    private void extractErrorCode(String message) {
        message.indexOf(":");
        message = message.substring(1, message.indexOf(":"));
        message = message.trim();
        try {
            this.extractedErrorCode = Integer.parseInt(message);
        }
        catch (NumberFormatException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
        }
    }

    public void executeNoResult(String statement) {
        LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + statement);
        String[] commandLine = new String[]{this.getHdbsqlExecutable(), U, this.key.toString(), A, C, statement};
        this.execute(commandLine);
        if (this.foundErrorInOutput || this.exitValue != 0) {
            if (this.extractedErrorCode % 256 == this.exitValue) {
                this.exitValue = this.extractedErrorCode;
            }
            throw new HdbsqlException(this.exitValue, "The following error occured during execution of hdbsql | " + (String)this.resltList.get(0) + " | The command line was: " + this.getCmdAsString());
        }
    }

    public List<String> execute(String statement) {
        LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + statement);
        String[] commandLine = new String[]{this.getHdbsqlExecutable(), U, this.key.toString(), A, C, statement};
        this.execute(commandLine);
        if (this.foundErrorInOutput || this.exitValue != 0) {
            throw new HdbsqlException(this.exitValue, "The following error occured during execution of hdbsql | " + (String)this.resltList.get(0) + " | The command line was: " + this.getCmdAsString());
        }
        List<String> result = this.getResult();
        return result;
    }

    public void executeWithFile(File sqlFile) {
        LogFactory.writeLogEntry(this.getClass(), "Run SQL from file: " + sqlFile.getPath());
        File sqlOut = new File(sqlFile.getParent(), "HdiShadowGrants.out");
        String[] commandLine = new String[]{this.getHdbsqlExecutable(), U, this.key.toString(), A, C, I, sqlFile.getPath(), o, sqlOut.getPath()};
        try {
            this.execute(commandLine);
        }
        catch (Exception e) {
            throw new HdbsqlException(this.exitValue, "The following error occured during execution of hdbsql | " + (String)this.resltList.get(0) + " | The command line was: " + this.getCmdAsString());
        }
        if (this.foundErrorInOutput || this.exitValue != 0) {
            throw new HdbsqlException(this.exitValue, "The following error occured during execution of hdbsql | " + (String)this.resltList.get(0) + " | The command line was: " + this.getCmdAsString());
        }
    }
}

