/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.connection.sql;

import com.sap.hdb.sl.lib.connection.sql.HdbConnection;
import com.sap.hdb.sl.lib.connection.sql.Hdbsql;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.exceptions.HdbsqlException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseHdbsqlUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HdbsqlConnection
implements HdbConnection {
    private DatabaseHdbsqlUser connectUser = null;
    private boolean isConnectUserSet = false;
    private Hdbsql hdbsql = null;
    private int errorCode = 0;

    @Override
    public void setConnectUser(DatabaseUser user) {
        if (!(user instanceof DatabaseHdbsqlUser)) {
            throw new HdbException("user " + user.getName() + " cannot be used in " + this.getClass());
        }
        this.setConnectSqlUser((DatabaseHdbsqlUser)user);
    }

    public void setConnectSqlUser(DatabaseHdbsqlUser user) {
        DatabaseHdbsqlUser lastConnectUser = this.connectUser;
        this.connectUser = user;
        this.hdbsql = new Hdbsql(this.connectUser.getHdbsqlExecutable(), this.connectUser.getKey());
        this.isConnectUserSet = true;
        if (lastConnectUser != null && !lastConnectUser.getName().get().equalsIgnoreCase(this.connectUser.getName().get())) {
            this.localLogger("Last user: " + lastConnectUser.getName().get() + ", New user: " + this.connectUser.getName().get());
        }
    }

    @Override
    public void executeSQLCommandNoReslt(String statement) {
        try {
            this.localLogger("Run SQL command: " + statement);
            this.hdbsql.execute(statement);
        }
        catch (HdbsqlException e) {
            this.localLogger(e.getMessage());
            this.errorCode = e.getErrorCode();
            throw e;
        }
    }

    @Override
    public void executeSQLCommandsNoReslt(List<String> statementList) {
        String statement = "";
        Iterator<String> i$ = statementList.iterator();
        while (i$.hasNext()) {
            String s;
            statement = s = i$.next();
            this.localLogger("Run SQL command: " + statement);
            try {
                this.hdbsql.executeNoResult(statement);
            }
            catch (HdbsqlException e) {
                this.localLogger(e.getMessage());
                this.errorCode = e.getErrorCode();
                throw e;
            }
        }
    }

    private void localLogger(String logText) {
        LogFactory.writeLogEntry(this.getClass(), logText);
    }

    @Override
    public List<String> executeSQLCommand(String statement) {
        return this.executeSQLCommand(statement, false);
    }

    @Override
    public List<String> executeSQLCommand(String statement, boolean allowExceptions) {
        ArrayList<String> sqlResult = new ArrayList();
        try {
            sqlResult = this.hdbsql.execute(statement);
        }
        catch (HdbsqlException e) {
            this.localLogger(e.getMessage());
            this.errorCode = e.getErrorCode();
            if (!allowExceptions) {
                throw e;
            }
            this.localLogger("Continuing since the call is error tolerant...");
        }
        return sqlResult;
    }

    public void executeWithFile(File sqlFile) {
        this.executeWithFile(sqlFile, false);
    }

    public void executeWithFile(File sqlFile, boolean allowExceptions) {
        try {
            this.hdbsql.executeWithFile(sqlFile);
        }
        catch (HdbsqlException e) {
            this.localLogger(e.getMessage());
            this.errorCode = e.getErrorCode();
            if (!allowExceptions) {
                throw e;
            }
            this.localLogger("Continuing since the call is error tolerant...");
        }
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }
}

