/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.connection.sql;

import com.sap.hdb.sl.lib.connection.sql.HdbConnection;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.User;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class JdbcConnection
implements HdbConnection {
    private static final String CERTIFICATE_VALIDATION = "[Certificate_Validation]";
    private Connection connection;
    private Properties connectProperties;
    private String connectUrl;
    private String databaseHost;
    private String port;
    private Class<? extends Driver> sqlClass;
    private Database database;
    private DatabaseUser connectUser;
    private int errorCode;
    private boolean isFakeConnection;
    private String driverVersion;
    private boolean isConnectUserSet;
    private boolean doesDatabaseExist;
    private int dbVersion;
    private boolean checkNoValidateFirst;
    private String versionString;
    private boolean logging;

    protected JdbcConnection(Class<? extends Driver> sqlClass, Database database) {
        this(sqlClass, database, new Properties());
    }

    protected JdbcConnection(Class<? extends Driver> sqlClass, Database database, Properties additionalConnectProperties) {
        block15: {
            block16: {
                block14: {
                    this.connection = null;
                    this.connectProperties = null;
                    this.connectUrl = null;
                    this.databaseHost = null;
                    this.port = null;
                    this.sqlClass = null;
                    this.database = null;
                    this.connectUser = null;
                    this.errorCode = 0;
                    this.isFakeConnection = false;
                    this.isConnectUserSet = false;
                    this.doesDatabaseExist = true;
                    this.checkNoValidateFirst = false;
                    this.logging = true;
                    this.connectProperties = new Properties();
                    this.connectProperties.setProperty("APPLICATION", "SLTOOLSET");
                    this.addAdditionalConnectProperties(additionalConnectProperties);
                    if (database.isEncryptTrue()) {
                        if (database.validateCertificate()) {
                            String validateCertificate = HdbsllibMem.getInstance().read(CERTIFICATE_VALIDATION);
                            if (database.getForceEncrypt() || validateCertificate != null && Boolean.parseBoolean(validateCertificate)) {
                                this.checkNoValidateFirst = false;
                                this.addAdditionalConnectProperties(database.getEncrytionProperties());
                            } else {
                                if (validateCertificate == null) {
                                    LogFactory.writeLogEntry(this.getClass(), "Validate certificate is set, but we try without first...");
                                    this.checkNoValidateFirst = true;
                                } else {
                                    LogFactory.writeLogEntry(this.getClass(), "Validate certificate turned OFF via HDBSLLIBMem parameter: [Certificate_Validation]");
                                }
                                this.addAdditionalConnectProperties(database.getDefaultEncrytionProperties());
                            }
                        } else {
                            HdbsllibMem.getInstance().delete(CERTIFICATE_VALIDATION);
                            this.addAdditionalConnectProperties(database.getEncrytionProperties());
                        }
                    }
                    this.sqlClass = sqlClass;
                    this.database = database;
                    this.databaseHost = this.getDatabaseHost(this.database);
                    if (database.getPort() == null) break block14;
                    this.port = database.getPort();
                    break block15;
                }
                if (!this.database.isDatabaseModeSet()) break block16;
                switch (this.database.getDatabaseMode()) {
                    case MULTIPLE: {
                        this.port = "3" + this.getInstanceNumber(this.database) + "13";
                        break block15;
                    }
                    case SINGLE: {
                        this.port = "3" + this.getInstanceNumber(this.database) + "15";
                        break block15;
                    }
                    default: {
                        throw new HdbException("Invalid database mode: " + (Object)((Object)this.getDatabaseMode()));
                    }
                }
            }
            this.port = "3" + this.getInstanceNumber(this.database) + "13";
        }
        User defaultUser = database.getConnectUser();
        if (null != defaultUser) {
            if (defaultUser instanceof DatabaseUser) {
                this.setConnectUser((DatabaseUser)defaultUser);
            } else {
                throw new HdbException(defaultUser + " is not a valid connect user!");
            }
        }
    }

    public void createConnection() {
        this.closeConnection();
        try {
            this.connect();
            if (this.database.validateCertificate() && this.checkNoValidateFirst) {
                LogFactory.writeLogEntry(this.getClass(), "Connect without certificate validation successful. Turning OFF HDBSLLIBMem parameter: [Certificate_Validation]");
                HdbsllibMem.getInstance().save(CERTIFICATE_VALIDATION, "false");
                this.checkNoValidateFirst = false;
            }
        }
        catch (HdbException e) {
            if ((e.testConnectionRefused() || e.testConnectionReset()) && this.database.validateCertificate() && this.checkNoValidateFirst) {
                LogFactory.writeLogEntry(this.getClass(), "Retrying with certificate validation...");
                this.connectProperties.remove("validateCertificate");
                this.addAdditionalConnectProperties(this.database.getEncrytionProperties());
                this.connect();
                LogFactory.writeLogEntry(this.getClass(), "Connect with certificate validation successful. Turning ON HDBSLLIBMem parameter: [Certificate_Validation]");
                HdbsllibMem.getInstance().save(CERTIFICATE_VALIDATION, "true");
                this.checkNoValidateFirst = false;
                return;
            }
            throw e;
        }
    }

    private void connect() {
        block9: {
            block8: {
                if (!this.database.isDatabaseModeSet()) break block8;
                switch (this.database.getDatabaseMode()) {
                    case SINGLE: {
                        LogFactory.writeLogEntry(this.getClass(), "Instance is a single-container system.");
                        this.establishConnection("jdbc:sap://" + this.getDBHostnameString(this.databaseHost, this.port));
                        break block9;
                    }
                    case MULTIPLE: {
                        if (!this.database.isSystemDB() && this.database.getPort() != null) {
                            this.establishConnection("jdbc:sap://" + this.getDBHostnameString(this.databaseHost, this.database.getPort()));
                        } else {
                            this.connectToTenant();
                        }
                        break block9;
                    }
                    default: {
                        throw new HdbException("Unsupported database mode: " + (Object)((Object)this.database.getDatabaseMode()));
                    }
                }
            }
            if (this.database.getPort() != null) {
                this.connectWithPort();
            } else {
                this.connectWithoutPort();
            }
        }
    }

    private String getDBHostnameString(String hostname, String port) {
        String connectString = hostname + ":" + port;
        if (hostname.indexOf(",") > -1) {
            String[] hostnames = hostname.split(",");
            connectString = hostnames[0] + ":" + port;
            for (int i = 1; i < hostnames.length; ++i) {
                connectString = connectString + ";" + hostnames[i] + ":" + port;
            }
        } else if (hostname.indexOf(":") > -1) {
            connectString = hostname;
        }
        return connectString;
    }

    private void connectWithPort() {
        Database.DatabaseMode mode = Database.DatabaseMode.SINGLE;
        this.establishConnection("jdbc:sap://" + this.getDBHostnameString(this.databaseHost, this.database.getPort()));
        if (!this.isHANA4orNewer()) {
            mode = this.determineDbModeViaSQL();
            LogFactory.writeLogEntry(this.getClass(), "Instance is a " + (Object)((Object)mode) + "-container system.");
        }
        this.database.setDatabaseMode(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithoutPort() {
        DatabaseUser originalConnectUser = null;
        try {
            try {
                originalConnectUser = this.setDummyConnectUser();
                this.establishConnection("jdbc:sap://" + this.getDBHostnameString(this.databaseHost, this.port));
                throw new HdbException("User " + this.getConnectUser().getName().get() + " exists unexpectedly.");
            }
            catch (HdbException e) {
                if (originalConnectUser != null) {
                    this.setConnectUser(originalConnectUser);
                    originalConnectUser = null;
                }
                if (e.testConnectionRefused()) {
                    this.database.setDatabaseMode(Database.DatabaseMode.SINGLE);
                    LogFactory.writeLogEntry(this.getClass(), "Recieved connection refused at port " + this.port + ". Suppose that instance is a single-container system.");
                    this.port = "3" + this.getInstanceNumber(this.database) + "15";
                    this.establishConnection("jdbc:sap://" + this.getDBHostnameString(this.databaseHost, this.port));
                    Database.DatabaseMode mode = this.determineDbModeViaSQL();
                    this.database.setDatabaseMode(mode);
                    LogFactory.writeLogEntry(this.getClass(), "Determined dbmode via sql - Instance is a " + (Object)((Object)mode) + "-container system.");
                } else if (e.testInvalidUsernameOrPassword() || e.testSQLNonTransientConnectionException()) {
                    this.database.setDatabaseMode(Database.DatabaseMode.MULTIPLE);
                    this.connectToTenant();
                    this.compareDatabaseSid();
                } else {
                    if (e.testDatabaseNotExists()) {
                        this.doesDatabaseExist = false;
                    }
                    throw e;
                }
                if (originalConnectUser != null) {
                    this.setConnectUser(originalConnectUser);
                }
            }
        }
        catch (Throwable throwable) {
            if (originalConnectUser != null) {
                this.setConnectUser(originalConnectUser);
            }
            throw throwable;
        }
    }

    private void compareDatabaseSid() {
        String givenSid = this.database.getSid().get();
        String realSid = null;
        String statement = "SELECT DATABASE_NAME FROM M_DATABASE";
        List<String> result = this.executeSQLCommand(statement);
        if (result.size() != 1) {
            throw new HdbException(result.size() + ", expected result size was 1. Error during execution of SQL command: " + statement);
        }
        realSid = result.get(0);
        if (!givenSid.equals(realSid)) {
            throw new HdbException(realSid + ", database SID differs from given tenant database SID: " + givenSid + " ! Switch to tenant was not successful. JDBC driver might be too old. Version is: " + this.driverVersion);
        }
    }

    private void connectToTenant() {
        String sid = this.database.getSid().get();
        if (sid.length() == 0) {
            throw new HdbException("Parameter " + CmdClazzParameterName.DATABASE_SID.toString() + " must not be empty for a connect to a multiple-container system!");
        }
        LogFactory.writeLogEntry(this.getClass(), "Instance is a multiple-container system.");
        String systemDBPort = this.database.getSystemDBPort();
        if (null == systemDBPort) {
            systemDBPort = "3" + this.getInstanceNumber(this.database) + "13";
        }
        try {
            this.establishConnection("jdbc:sap://" + this.getDBHostnameString(this.databaseHost, systemDBPort) + "?databaseName=" + sid);
        }
        catch (HdbException e) {
            if (e.testDatabaseNotExists()) {
                this.doesDatabaseExist = false;
            }
            throw e;
        }
    }

    private void establishConnection(String connectUrlParam) {
        this.connectUrl = connectUrlParam;
        try {
            Driver ngdbc = this.sqlClass.newInstance();
            boolean x509 = false;
            String x509Path = "";
            if (this.getConnectUser() instanceof DatabaseSqlUser) {
                DatabaseSqlUser sqlUser = (DatabaseSqlUser)this.getConnectUser();
                x509 = sqlUser.useCertificateForAuth();
                x509Path = sqlUser.getX509CertPath();
                if (null == x509Path) {
                    x509Path = "<PEM STRING>";
                }
            }
            this.localLogger("Start new connection with connect URL: " + this.connectUrl + " connect user: " + this.getConnectUserProperties().get("user") + (x509 ? " using certificate " + x509Path : ""));
            this.connection = ngdbc.connect(this.connectUrl, this.getConnectProperties());
            this.driverVersion = this.connection.getMetaData().getDriverVersion();
            this.dbVersion = this.connection.getMetaData().getDatabaseMajorVersion();
            this.versionString = this.connection.getMetaData().getDatabaseProductVersion();
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e);
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e);
        }
        catch (InstantiationException e) {
            throw new HdbException(e);
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
    }

    public Connection cloneConnection() {
        if (this.connectUrl == null) {
            return null;
        }
        try {
            Driver ngdbc = this.sqlClass.newInstance();
            this.localLogger("Cloning connection with connect URL: " + this.connectUrl + " connect user: " + this.getConnectUserProperties().get("user"));
            return ngdbc.connect(this.connectUrl, this.getConnectProperties());
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e);
        }
        catch (InstantiationException e) {
            throw new HdbException(e);
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean testConnectionUrl(String url) {
        boolean test = false;
        if (url == null) {
            return false;
        }
        try {
            Driver ngdbc = this.sqlClass.newInstance();
            this.localLogger("Testing connection with connect URL: " + url + " connect user: " + this.getConnectUserProperties().get("user"));
            Connection con = ngdbc.connect(url, this.getConnectProperties());
            con.close();
            test = true;
        }
        catch (Exception e) {
            this.localLogger("Test failed: " + e.getMessage());
        }
        return test;
    }

    public Properties getConnectProperties() {
        if (this.connectProperties.get("authenticationX509") == null) {
            return this.connectProperties;
        }
        return this.getConnectPropertiesX509();
    }

    public Properties getConnectPropertiesX509() {
        Properties x509 = new Properties();
        Set<String> stringPropertyNames = this.connectProperties.stringPropertyNames();
        for (String propertyName : stringPropertyNames) {
            if (propertyName == "user" || propertyName == "password") continue;
            x509.put(propertyName, this.connectProperties.get(propertyName));
        }
        return x509;
    }

    private String getInstanceNumber(Database databaseParameter) {
        InstanceNumber number = databaseParameter.getNumber();
        if (null == number) {
            throw new HdbException("Instance number must be set!");
        }
        return number.get();
    }

    private String getDatabaseHost(Database databaseParameter) {
        Hostname host = databaseParameter.getHostname();
        if (null == host) {
            throw new HdbException("Database hostname must be set!");
        }
        return host.get();
    }

    public Connection getConnection() {
        if (this.isClosed()) {
            this.createConnection();
        }
        return this.connection;
    }

    public boolean isClosed() {
        boolean isClosed = true;
        try {
            if (null != this.connection && !this.connection.isClosed()) {
                isClosed = false;
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
        }
        return isClosed;
    }

    @Override
    public List<String> executeSQLCommand(String statement) {
        return this.executeSQLCommand(statement, false);
    }

    @Override
    public List<String> executeSQLCommand(String statement, boolean allowExceptions) {
        Statement stmt = null;
        ResultSet resultSet = null;
        ArrayList<String> sqlResult = new ArrayList<String>();
        try {
            stmt = this.getConnection().createStatement();
            if (this.logging) {
                this.localLogger("Run SQL command: " + statement);
            }
            if (stmt.execute(statement)) {
                resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    do {
                        String strResult = resultSet.getString(1);
                        sqlResult.add(strResult);
                    } while (resultSet.next());
                }
                resultSet.close();
            }
            stmt.close();
        }
        catch (SQLException e) {
            String message = "Error during execution of SQL command: " + statement + " " + e.getMessage();
            this.localLogger(message);
            this.closeConnection();
            this.errorCode = e.getErrorCode();
            if (!allowExceptions) {
                throw new HdbException(message);
            }
            this.localLogger("Continuing since the call is error tolerant...");
        }
        return sqlResult;
    }

    public Statement createStatement() {
        try {
            return this.getConnection().createStatement();
        }
        catch (SQLException e) {
            String message = "Can not create SQL Statement Object.  " + e.getMessage();
            this.localLogger(message);
            return null;
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            this.localLogger("Closing connection: " + this.connectUrl + " Connect user: " + this.connectUser);
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                String message = null;
                message = "Error during close of connection: " + e.getMessage();
                this.localLogger(message);
                this.errorCode = e.getErrorCode();
                throw new HdbException(message);
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public void executeSQLCommandNoReslt(String statement) {
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            this.localLogger("Run SQL command: " + statement);
            stmt.execute(statement);
            stmt.close();
        }
        catch (SQLException e) {
            String message = "Error during execution of SQL command: " + statement + " " + e.getMessage();
            this.localLogger(message);
            this.errorCode = e.getErrorCode();
            this.closeConnection();
            throw new HdbException(message);
        }
    }

    @Override
    public void executeSQLCommandsNoReslt(List<String> statementList) {
        Statement stmt = null;
        String statement = "";
        try {
            Iterator<String> i$ = statementList.iterator();
            while (i$.hasNext()) {
                String s;
                statement = s = i$.next();
                stmt = this.getConnection().createStatement();
                this.localLogger("Run SQL command: " + statement);
                stmt.execute(statement);
                stmt.close();
            }
        }
        catch (SQLException e) {
            String message = "Error during execution of SQL command: " + statement + " " + e.getMessage();
            this.localLogger(message);
            this.errorCode = e.getErrorCode();
            this.closeConnection();
            throw new HdbException(message);
        }
    }

    @Override
    public void setConnectUser(DatabaseUser user) {
        DatabaseSqlUser dbuser;
        DatabaseUser lastConnectUser = this.connectUser;
        this.connectUser = user;
        this.connectProperties.remove("x509");
        this.connectProperties.remove("authenticationX509");
        this.connectProperties.setProperty("user", this.connectUser.getName().get().toUpperCase(Locale.ENGLISH));
        this.connectProperties.setProperty("password", this.connectUser.getPassword().get());
        if (this.connectUser instanceof DatabaseSqlUser && (dbuser = (DatabaseSqlUser)this.connectUser).useCertificateForAuth()) {
            this.localLogger("Adding Certificate Based connection properties...");
            String certPath = dbuser.getX509CertPath();
            String pem = dbuser.getX509PemString();
            if (pem != null) {
                this.connectProperties.setProperty("authenticationX509", pem);
            } else {
                this.connectProperties.setProperty("authenticationX509", certPath);
            }
        }
        this.isConnectUserSet = true;
        if (lastConnectUser != null) {
            if (!lastConnectUser.getName().get().equalsIgnoreCase(this.connectUser.getName().get())) {
                this.localLogger("Last user: " + lastConnectUser.getName().get() + ", New user: " + this.connectUser.getName().get());
                this.closeConnection();
            } else if (lastConnectUser.getPassword() != null && !lastConnectUser.getPassword().get().isEmpty() && !lastConnectUser.getPassword().get().equals(this.connectUser.getPassword().get())) {
                this.localLogger("Password has changed for user: " + this.connectUser);
                this.closeConnection();
            }
        }
    }

    public void setUserAndConnect(DatabaseUser user) {
        this.setConnectUser(user);
        this.createConnection();
    }

    private Properties getConnectUserProperties() {
        if (!this.isConnectUserSet) {
            throw new HdbException("No connect user set!");
        }
        return this.connectProperties;
    }

    private void localLogger(String logText) {
        LogFactory.writeLogEntry(this.getClass(), logText);
    }

    public Database getDatabase() {
        return this.database;
    }

    public String toString() {
        String connectionString = "Class: " + this.sqlClass + " Connect URL: " + this.connectUrl + " Connect user: " + this.connectUser;
        return connectionString;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    public PreparedStatement prepareSQLCommand(String statement) {
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement(statement);
        }
        catch (SQLException e) {
            String message = "Error during execution of SQL command: " + statement + " " + e.getMessage();
            this.localLogger(message);
            this.errorCode = e.getErrorCode();
            this.closeConnection();
            throw new HdbException(message);
        }
        return stmt;
    }

    public List<String> executeSQLCommand(PreparedStatement statement) {
        ResultSet resultSet = null;
        ArrayList<String> sqlResult = new ArrayList<String>();
        try {
            if (statement.execute()) {
                resultSet = statement.getResultSet();
                if (resultSet.next()) {
                    do {
                        String strResult = resultSet.getString(1);
                        sqlResult.add(strResult);
                    } while (resultSet.next());
                }
                resultSet.close();
            }
            statement.close();
        }
        catch (SQLException e) {
            String message = "Error during execution of prepared SQL command: " + e.getMessage();
            this.localLogger(message);
            this.errorCode = e.getErrorCode();
            throw new HdbException(message);
        }
        finally {
            this.closeConnection();
        }
        return sqlResult;
    }

    public void executeSQLCommandNoReslt(PreparedStatement statement) {
        try {
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            String message = "Error during execution of prepared SQL command: " + e.getMessage();
            this.localLogger(message);
            this.errorCode = e.getErrorCode();
            this.closeConnection();
            throw new HdbException(message);
        }
    }

    private void addAdditionalConnectProperties(Properties additionalConnectProperties) {
        if (null != additionalConnectProperties) {
            Enumeration<?> e = additionalConnectProperties.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = additionalConnectProperties.getProperty(name);
                if (null == name || null == value || name.isEmpty() || value.isEmpty()) continue;
                if (!"password".equalsIgnoreCase(name)) {
                    this.localLogger("Adding connect property: " + name + "=" + value);
                } else {
                    this.localLogger("Adding connect property: " + name + "=*");
                }
                this.connectProperties.setProperty(name, value);
            }
        }
    }

    public Database.DatabaseMode getDatabaseMode() {
        block3: {
            if (this.database.isDatabaseModeSet()) {
                return this.database.getDatabaseMode();
            }
            try {
                this.getConnection();
            }
            catch (HdbException e) {
                if (e.testDatabaseNotExists() || e.testInvalidUsernameOrPassword() || e.testSQLNonTransientConnectionException()) break block3;
                throw new HdbException(e);
            }
        }
        return this.database.getDatabaseMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Database.DatabaseMode determineDbModeViaSQL() {
        String statement = "select layer_name, value from \"PUBLIC\".\"M_INIFILE_CONTENTS\" where file_name='global.ini' and section='multidb' and key='mode'";
        String mode = null;
        Database.DatabaseMode dbMode = null;
        TreeMap configMap = new TreeMap();
        PreparedStatement prepStmt = this.prepareSQLCommand(statement);
        ResultSet resultSet = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("DEFAULT", 1);
        map.put("SYSTEM", 2);
        map.put("DATABASE", 3);
        map.put("HOST", 4);
        try {
            resultSet = prepStmt.executeQuery();
            String layer_name = null;
            String value = null;
            while (resultSet.next()) {
                layer_name = resultSet.getString(1);
                value = resultSet.getString(2);
                configMap.put(map.get(layer_name), value);
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(this.getClass(), "Error determining database mode with statement: " + statement + " message: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
            throw new HdbException(e);
        }
        finally {
            IOUtils.closeQuietly(resultSet);
            IOUtils.closeQuietly(prepStmt);
        }
        if (configMap.size() > 0) {
            mode = (String)configMap.get(configMap.lastKey());
            if ("singledb".equalsIgnoreCase(mode)) {
                return Database.DatabaseMode.SINGLE;
            }
            if (!"multidb".equalsIgnoreCase(mode)) throw new HdbException("Could not determine db mode via sql. Found db mode: " + mode);
            return Database.DatabaseMode.MULTIPLE;
        }
        dbMode = Database.DatabaseMode.SINGLE;
        LogFactory.writeLogEntry(this.getClass(), "no multidb configuration section found -> set db mode to " + (Object)((Object)dbMode));
        return dbMode;
    }

    public boolean isMultiDB() {
        if (!this.isConnectUserSet) {
            this.setDummyConnectUser();
        }
        return this.getDatabaseMode().equals((Object)Database.DatabaseMode.MULTIPLE);
    }

    public boolean isFakeConnection() {
        return this.isFakeConnection;
    }

    public void setFakeConnection(boolean value) {
        this.isFakeConnection = value;
    }

    public boolean doesTenantExist() {
        block2: {
            try {
                this.getConnection();
            }
            catch (HdbException e) {
                if (e.testDatabaseNotExists() || e.testInvalidUsernameOrPassword() || e.testSQLNonTransientConnectionException()) break block2;
                throw new HdbException(e);
            }
        }
        return this.doesDatabaseExist;
    }

    public boolean isConnectedToSystemDB() {
        return this.database.getSid().isSystemDB();
    }

    public void setSid(Sid newSid) {
        Sid lastSid = this.database.getSid();
        if (!lastSid.equals(newSid)) {
            this.localLogger("Last database Sid: " + lastSid + ", New database Sid: " + newSid);
            this.closeConnection();
            this.database.setSid(newSid);
        }
    }

    public DatabaseUser getConnectUser() {
        return this.connectUser;
    }

    private DatabaseUser setDummyConnectUser() {
        DatabaseUser originalConnectUser = this.getConnectUser();
        DatabaseSqlUser user = DatabaseSqlUserFactory.getUser(new DatabaseSqlUserName("_SYS_DUMMY_"), PasswordFactory.getDatabaseSqlUserPassword("dummy"));
        this.setConnectUser(user);
        return originalConnectUser;
    }

    public String getUrl() {
        return this.connectUrl;
    }

    public int getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(int dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getPort() {
        return this.port;
    }

    public String getSystemdbPort() {
        if (this.getUrl().contains("databaseName=")) {
            return this.getPort();
        }
        this.localLogger("getSystemdbPort: no SYSTEMDB port in connection found, returning null.");
        return null;
    }

    public boolean isHANA4() {
        return this.dbVersion == 4;
    }

    public boolean isHANA4orNewer() {
        return this.dbVersion >= 4;
    }

    public boolean isHANA2() {
        return this.dbVersion == 2;
    }

    public boolean isHANA2orNewer() {
        return this.dbVersion >= 2;
    }

    public boolean supports_USER_GROUPS() {
        return this.isProductVersionEqualOrGreaterThan("2.00.020");
    }

    public boolean supports_NO_GRANT_TO_CREATOR() {
        return this.isSP03orNewer();
    }

    public boolean supports_M_EFFECTIVE_PASSWORD_POLICY() {
        return this.isSP03orNewer();
    }

    public boolean isSP03orNewer() {
        return this.isProductVersionEqualOrGreaterThan("2.00.030");
    }

    public boolean supports_NO_FORCE_FIRST_PASSWORD_CHANGE() {
        return this.isHANA2orNewer();
    }

    public boolean isProductVersionEqualOrGreaterThan(String version) {
        if (null == this.versionString || this.versionString.isEmpty()) {
            return false;
        }
        String[] currentRelease = this.versionString.split("[ ]")[0].split("[.]");
        String[] minRelease = version.split("[ ]")[0].split("[.]");
        for (int i = 0; i < minRelease.length; ++i) {
            if (i == currentRelease.length) {
                return false;
            }
            if (Integer.parseInt(currentRelease[i]) > Integer.parseInt(minRelease[i])) {
                return true;
            }
            if (Integer.parseInt(currentRelease[i]) >= Integer.parseInt(minRelease[i])) continue;
            return false;
        }
        return true;
    }

    public boolean supportsClientPKI() {
        if (this.isProductVersionEqualOrGreaterThan("2.00.060")) {
            DatabaseConfiguration config = new DatabaseConfiguration(this, this.connectUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
            DatabaseConfigurationSection section = config.getSection("communication");
            String sslclientpki = section.getParameterValue("sslclientpki");
            LogFactory.writeLogEntry(this.getClass(), "Checking sslclientpki configuration:" + sslclientpki);
            return "on".equals(sslclientpki);
        }
        return false;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public void waitForPKI() {
        int retry = 1;
        do {
            try {
                if (retry > 1) {
                    Thread.sleep(30000L);
                }
                LogFactory.writeLogEntry(this.getClass(), "Check connection with encryption try #" + retry);
                this.createConnection();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                break;
            }
            catch (HdbException e2) {
                if (e2.getMessage() == null || e2.getMessage().indexOf("unrecognized_name") == -1) break;
            }
        } while (++retry <= 60 && this.isClosed());
    }
}

