/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.connection.sql;

import com.sap.hdb.sl.lib.connection.sql.HdbClazzLoader;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.user.DatabaseUserAdmin;
import java.util.Properties;

public class JdbcConnectionFactory {
    private static JdbcConnection CONNECTION;
    private static Database DATABASE;
    private static JdbcConnection CONNECTION_NO_RECONNECT;
    private static Database DATABASE_NO_RECONNECT;

    public static JdbcConnection getInstance(JdbcDriver jdbcDriver, Database database) {
        if (null == DATABASE || !DATABASE.equals(database)) {
            if (null != CONNECTION) {
                CONNECTION.closeConnection();
            }
            HdbClazzLoader hdbClazzLoader = new HdbClazzLoader(jdbcDriver);
            DATABASE = database;
            CONNECTION = new JdbcConnection(hdbClazzLoader.getDriverClass(), DATABASE);
        }
        return CONNECTION;
    }

    public static JdbcConnection resetInstance(JdbcDriver jdbcDriver, Database database) {
        if (null != CONNECTION) {
            CONNECTION.closeConnection();
        }
        HdbClazzLoader hdbClazzLoader = new HdbClazzLoader(jdbcDriver);
        DATABASE = database;
        CONNECTION = new JdbcConnection(hdbClazzLoader.getDriverClass(), DATABASE);
        return CONNECTION;
    }

    public static JdbcConnection getInstanceNoReconnect(JdbcDriver jdbcDriver, Database database) {
        if (null == DATABASE_NO_RECONNECT || !DATABASE_NO_RECONNECT.equals(database)) {
            if (null != CONNECTION_NO_RECONNECT) {
                CONNECTION_NO_RECONNECT.closeConnection();
            }
            Properties additionalConnectProperties = new Properties();
            additionalConnectProperties.setProperty("reconnect", "false");
            HdbClazzLoader hdbClazzLoader = new HdbClazzLoader(jdbcDriver);
            DATABASE_NO_RECONNECT = database;
            CONNECTION_NO_RECONNECT = new JdbcConnection(hdbClazzLoader.getDriverClass(), DATABASE_NO_RECONNECT, additionalConnectProperties);
        }
        return CONNECTION_NO_RECONNECT;
    }

    public static JdbcConnection getInstance(JdbcDriver jdbcDriver, Database database, Properties additionalConnectProperties) {
        if (null == DATABASE || !DATABASE.equals(database)) {
            if (null != CONNECTION) {
                CONNECTION.closeConnection();
            }
            HdbClazzLoader hdbClazzLoader = new HdbClazzLoader(jdbcDriver);
            DATABASE = database;
            CONNECTION = new JdbcConnection(hdbClazzLoader.getDriverClass(), DATABASE, additionalConnectProperties);
        }
        return CONNECTION;
    }

    public static void closeAllConnections() {
        DatabaseUserAdmin admin;
        if (null != CONNECTION) {
            CONNECTION.closeConnection();
        }
        if (null != (admin = DatabaseUserAdmin.getInstance())) {
            if (admin.wasInitialStateDeactivated()) {
                admin.deactivate();
            }
            admin.resetInitialState();
        }
        if (null != CONNECTION_NO_RECONNECT) {
            CONNECTION_NO_RECONNECT.closeConnection();
        }
    }

    private JdbcConnectionFactory() {
    }

    public static JdbcConnection getUniqueInstance(JdbcDriver jdbcDriver, Database database) {
        HdbClazzLoader hdbClazzLoader = new HdbClazzLoader(jdbcDriver);
        return new JdbcConnection(hdbClazzLoader.getDriverClass(), database);
    }
}

