/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.connection.sql;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class JdbcConnectionPool {
    private List<JdbcConnection> connectionPool;
    private List<JdbcConnection> usedConnections = new ArrayList<JdbcConnection>();
    private JdbcDriver jdbcDriver;
    private Database database;
    private static int INITIAL_POOL_SIZE = 3;
    private static JdbcConnectionPool INSTANCE = null;

    public JdbcConnectionPool(List<JdbcConnection> pool) {
        this.connectionPool = pool;
    }

    public JdbcConnectionPool(JdbcDriver jdbcDriver, Database database) throws HdbException {
        this.jdbcDriver = jdbcDriver;
        this.database = database;
        this.connectionPool = new ArrayList<JdbcConnection>(INITIAL_POOL_SIZE);
        for (int i = 0; i < INITIAL_POOL_SIZE; ++i) {
            this.connectionPool.add(this.createConnection());
        }
    }

    public static JdbcConnectionPool create(JdbcDriver jdbcDriver, Database database) throws HdbException {
        if (null == INSTANCE) {
            INSTANCE = new JdbcConnectionPool(jdbcDriver, database);
        }
        return INSTANCE;
    }

    public static JdbcConnectionPool create(JdbcDriver jdbcDriver, Database database, int jobs) throws HdbException {
        if (null == INSTANCE) {
            INSTANCE = new JdbcConnectionPool(jdbcDriver, database, jobs);
        }
        return INSTANCE;
    }

    public JdbcConnectionPool(JdbcDriver jdbcDriver, Database database, int jobs) {
        this.jdbcDriver = jdbcDriver;
        this.database = database;
        this.connectionPool = new ArrayList<JdbcConnection>(jobs);
        for (int i = 0; i < jobs; ++i) {
            this.connectionPool.add(this.createConnection());
        }
    }

    private JdbcConnection createConnection() {
        JdbcConnection connection = JdbcConnectionFactory.getUniqueInstance(this.jdbcDriver, this.database);
        return connection;
    }

    public synchronized JdbcConnection getConnection() {
        while (this.connectionPool.isEmpty()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LogFactory.writeLogEntry(this.getClass(), "Error while waiting to get connection from pool " + e.getMessage());
            }
        }
        JdbcConnection connection = this.connectionPool.remove(this.connectionPool.size() - 1);
        this.usedConnections.add(connection);
        return connection;
    }

    public synchronized boolean releaseConnection(JdbcConnection connection) {
        this.connectionPool.add(connection);
        return this.usedConnections.remove(connection);
    }

    public int getSize() {
        return this.connectionPool.size() + this.usedConnections.size();
    }

    public void shutdown() throws HdbException {
        for (JdbcConnection used : this.usedConnections) {
            this.releaseConnection(used);
        }
        for (JdbcConnection c : this.connectionPool) {
            c.closeConnection();
        }
        this.connectionPool.clear();
    }
}

