/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.connection.sql;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;

public class JdbcDriver {
    private File jarFile = null;

    public JdbcDriver(File jarFile) {
        if (null == jarFile) {
            throw new HdbException(jarFile + " Parameter for jdbc driver must not be null!");
        }
        String fileName = jarFile.getName().toLowerCase(Locale.ENGLISH);
        this.jarFile = jarFile.isDirectory() || !fileName.endsWith(".jar") && !fileName.endsWith(".tca") ? new File(jarFile, "ngdbc.jar") : jarFile;
    }

    public JdbcDriver(CmdClazzParameterMap parameters) {
        this(new File(parameters.get(CmdClazzParameterName.JDBC_PATH).getValue()));
    }

    public URL getUrl() throws MalformedURLException {
        URI uri = this.jarFile.toURI();
        LogFactory.writeLogEntry(this.getClass(), "URI: " + uri.toString());
        return uri.toURL();
    }

    public String getClassName() {
        return "com.sap.db.jdbc.Driver";
    }

    public boolean exists() {
        return this.jarFile.exists() && this.jarFile.isFile() && "ngdbc.jar".equalsIgnoreCase(this.jarFile.getName());
    }

    public File get() {
        return this.jarFile;
    }

    public String toString() {
        return this.jarFile.toString();
    }
}

